/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.OptionContainer;
import org.infinispan.protostream.descriptors.ReservableDescriptor;
import org.infinispan.protostream.descriptors.ReservedContainer;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.SparseBitSet;

public final class EnumDescriptor
extends ReservableDescriptor
implements GenericDescriptor {
    private Integer typeId;
    private final List<Option> options;
    private final List<EnumValueDescriptor> values;
    private final Map<Integer, EnumValueDescriptor> valueByNumber;
    private final Map<String, EnumValueDescriptor> valueByName;
    private FileDescriptor fileDescriptor;
    private Descriptor containingType;

    private EnumDescriptor(Builder builder) {
        super(builder.name, builder.fullName, builder.documentation, builder.reservedNumbers, builder.reservedNames);
        this.options = List.copyOf(builder.options);
        this.values = List.copyOf(builder.values);
        this.valueByNumber = new HashMap<Integer, EnumValueDescriptor>(this.values.size());
        this.valueByName = new HashMap<String, EnumValueDescriptor>(this.values.size());
        Option allowAlias = this.options.stream().filter(o -> o.getName().equals("allow_alias")).findFirst().orElse(null);
        if (allowAlias == null || !"true".equals(allowAlias.getValue())) {
            SparseBitSet numbers = new SparseBitSet();
            for (EnumValueDescriptor c : this.values) {
                if (numbers.get(c.getNumber())) {
                    throw new IllegalStateException("Duplicate tag " + c.getNumber() + " in " + this.fullName);
                }
                numbers.set(c.getNumber());
            }
        }
        for (EnumValueDescriptor value : this.values) {
            if (this.name.equals(value.getName())) {
                throw new DescriptorParserException("Enum constant '" + value.getName() + "' clashes with enum type name: " + this.fullName);
            }
            if (this.valueByName.containsKey(value.getName())) {
                throw new DescriptorParserException("Enum constant '" + value.getName() + "' is already defined in " + this.fullName);
            }
            value.setContainingEnum(this);
            this.checkReserved(value);
            this.valueByName.put(value.getName(), value);
            this.valueByNumber.putIfAbsent(value.getNumber(), value);
        }
    }

    private void checkReserved(EnumValueDescriptor value) {
        if (this.reservedNumbers.get(value.getNumber())) {
            throw Log.LOG.reservedNumber(value.getNumber(), value.getName(), this.fullName);
        }
        if (this.reservedNames.contains(value.getName())) {
            throw Log.LOG.reservedName(value.getName(), this.fullName);
        }
    }

    @Override
    protected AnnotationConfiguration getAnnotationConfig(AnnotationElement.Annotation annotation) {
        AnnotationConfiguration annotationConfiguration = this.getAnnotationsConfig().annotations().get(annotation.getName());
        if (annotationConfiguration == null) {
            return null;
        }
        if (annotation.getPackageName() != null && !annotation.getPackageName().equals(annotationConfiguration.packageName())) {
            return null;
        }
        for (AnnotationElement.AnnotationTarget t : annotationConfiguration.target()) {
            if (t != AnnotationElement.AnnotationTarget.ENUM) continue;
            return annotationConfiguration;
        }
        throw new DescriptorParserException("Annotation '" + annotation + "' cannot be applied to enum types.");
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    @Override
    public Integer getTypeId() {
        return this.typeId;
    }

    @Override
    public Descriptor getContainingType() {
        return this.containingType;
    }

    void setContainingType(Descriptor containingType) {
        this.containingType = containingType;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String name) {
        for (Option o : this.options) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public List<EnumValueDescriptor> getValues() {
        return this.values;
    }

    public EnumValueDescriptor findValueByNumber(int number) {
        return this.valueByNumber.get(number);
    }

    public EnumValueDescriptor findValueByName(String name) {
        return this.valueByName.get(name);
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
        for (EnumValueDescriptor valueDescriptor : this.values) {
            valueDescriptor.setFileDescriptor(fileDescriptor);
        }
        this.typeId = (Integer)this.getProcessedAnnotation("TypeId");
        if (this.typeId != null && this.typeId < 0) {
            throw new DescriptorParserException("TypeId cannot be negative");
        }
    }

    public String toString() {
        return "EnumDescriptor{fullName=" + this.getFullName() + "}";
    }

    public void checkCompatibility(EnumDescriptor that, boolean strict, List<String> errors) {
        if (this.typeId == null && that.typeId != null || this.typeId != null && that.typeId == null || this.typeId != null && !this.typeId.equals(that.typeId)) {
            errors.add(Log.LOG.incompatibleTypeIds(this.fullName, this.typeId, that.typeId));
        }
        for (EnumValueDescriptor thatValue : that.getValues()) {
            if (this.reservedNumbers.get(thatValue.getNumber())) {
                errors.add(Log.LOG.reservedNumber(thatValue.getNumber(), thatValue.getName(), that.getFullName()).getMessage());
            }
            if (!this.reservedNames.contains(thatValue.getName())) continue;
            errors.add(Log.LOG.reservedName(thatValue.getName(), that.getFullName()).getMessage());
        }
        for (EnumValueDescriptor thisValue : this.values) {
            EnumValueDescriptor thatValue = that.valueByName.get(thisValue.getName());
            if (thatValue == null) {
                if (!that.reservedNames.contains(thisValue.getName())) {
                    errors.add(Log.LOG.removedFieldNotReserved(thisValue.getFullName()));
                }
                if (that.reservedNumbers.get(thisValue.getNumber())) continue;
                errors.add(Log.LOG.removedFieldNotReserved(thisValue.getFullName(), thisValue.getNumber()));
                continue;
            }
            if (thisValue.getNumber() == thatValue.getNumber()) continue;
            errors.add(Log.LOG.modifiedFieldNumber(thisValue.getFullName(), thisValue.getNumber(), thatValue.getNumber()));
        }
        this.checkReservation(that, strict, errors);
    }

    public static final class Builder
    implements OptionContainer<Builder>,
    ReservedContainer<Builder> {
        private String name;
        private String fullName;
        private List<Option> options = new ArrayList<Option>();
        private List<EnumValueDescriptor> values = new ArrayList<EnumValueDescriptor>();
        private String documentation;
        private final SparseBitSet reservedNumbers = new SparseBitSet();
        private final Set<String> reservedNames = new HashSet<String>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        String getName() {
            return this.name;
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder addOption(Option option) {
            this.options.add(option);
            return this;
        }

        public Builder withValues(List<EnumValueDescriptor> values) {
            this.values = values;
            return this;
        }

        public Builder addValue(EnumValueDescriptor.Builder value) {
            this.values.add(value.build());
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        @Override
        public Builder addReserved(int number) {
            this.reservedNumbers.set(number);
            return this;
        }

        @Override
        public Builder addReserved(int from, int to) {
            this.reservedNumbers.set((long)from, to + 1);
            return this;
        }

        @Override
        public Builder addReserved(String name) {
            this.reservedNames.add(name);
            return this;
        }

        public EnumDescriptor build() {
            return new EnumDescriptor(this);
        }
    }
}

