/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.telemetry;

import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.microprofile.telemetry.MicroProfileTelemetryDeploymentProcessor;
import org.wildfly.extension.microprofile.telemetry.MicroProfileTelemetrySubsystemDefinition;
import org.wildfly.extension.opentelemetry.api.WildFlyOpenTelemetryConfig;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;

class MicroProfileTelemetryDependencyProcessor
implements DeploymentUnitProcessor {
    MicroProfileTelemetryDependencyProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) {
        this.addDependencies(phaseContext.getDeploymentUnit());
        phaseContext.addDeploymentDependency(ServiceNameFactory.resolveServiceName((NullaryServiceDescriptor)WildFlyOpenTelemetryConfig.SERVICE_DESCRIPTOR), MicroProfileTelemetryDeploymentProcessor.CONFIG_ATTACHMENT_KEY);
    }

    private void addDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (String module : MicroProfileTelemetrySubsystemDefinition.EXPORTED_MODULES) {
            moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)module).setExport(true).setImportServices(true).build());
        }
    }
}

