/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateIdException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQShutdownException;
import org.apache.activemq.artemis.api.core.AutoCreateResult;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.AbstractPersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSettingJSON;
import org.apache.activemq.artemis.core.postoffice.AddressManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.QueueInfo;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.postoffice.impl.BindingsImpl;
import org.apache.activemq.artemis.core.postoffice.impl.DuplicateIDCaches;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.SimpleAddressManager;
import org.apache.activemq.artemis.core.postoffice.impl.WildcardAddressManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostOfficeImpl
implements PostOffice,
NotificationListener,
BindingsFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final SimpleString HDR_RESET_QUEUE_DATA = SimpleString.of((String)"_AMQ_RESET_QUEUE_DATA");
    public static final SimpleString HDR_RESET_QUEUE_DATA_COMPLETE = SimpleString.of((String)"_AMQ_RESET_QUEUE_DATA_COMPLETE");
    public static final SimpleString BRIDGE_CACHE_STR = SimpleString.of((String)"BRIDGE.");
    private final AddressManager addressManager;
    private final QueueFactory queueFactory;
    private final StorageManager storageManager;
    private final PagingManager pagingManager;
    private volatile boolean started;
    private final ManagementService managementService;
    private ExpiryReaper expiryReaperRunnable;
    private final long expiryReaperPeriod;
    private AddressQueueReaper addressQueueReaperRunnable;
    private final long addressQueueReaperPeriod;
    private final ConcurrentMap<SimpleString, DuplicateIDCache> duplicateIDCaches = new ConcurrentHashMap<SimpleString, DuplicateIDCache>();
    private final int idCacheSize;
    private final boolean persistIDCache;
    private final Map<SimpleString, QueueInfo> queueInfos = new HashMap<SimpleString, QueueInfo>();
    private final Object notificationLock = new Object();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ActiveMQServer server;
    private MirrorController mirrorControllerSource;

    public PostOfficeImpl(ActiveMQServer server, StorageManager storageManager, PagingManager pagingManager, QueueFactory bindableFactory, ManagementService managementService, long expiryReaperPeriod, long addressQueueReaperPeriod, WildcardConfiguration wildcardConfiguration, int idCacheSize, boolean persistIDCache, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this.storageManager = storageManager;
        this.queueFactory = bindableFactory;
        this.managementService = managementService;
        this.pagingManager = pagingManager;
        this.expiryReaperPeriod = expiryReaperPeriod;
        this.addressQueueReaperPeriod = addressQueueReaperPeriod;
        this.addressManager = wildcardConfiguration.isRoutingEnabled() ? new WildcardAddressManager(this, wildcardConfiguration, storageManager, server.getMetricsManager()) : new SimpleAddressManager(this, wildcardConfiguration, storageManager, server.getMetricsManager());
        this.idCacheSize = idCacheSize;
        this.persistIDCache = persistIDCache;
        this.addressSettingsRepository = addressSettingsRepository;
        this.server = server;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.managementService.addNotificationListener(this);
        this.queueFactory.setPostOffice(this);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
        this.managementService.removeNotificationListener(this);
        if (this.expiryReaperRunnable != null) {
            this.expiryReaperRunnable.stop();
        }
        if (this.addressQueueReaperRunnable != null) {
            this.addressQueueReaperRunnable.stop();
        }
        this.addressManager.clear();
        this.queueInfos.clear();
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public MirrorController getMirrorControlSource() {
        return this.mirrorControllerSource;
    }

    @Override
    public PostOfficeImpl setMirrorControlSource(MirrorController mirrorControllerSource) {
        this.mirrorControllerSource = mirrorControllerSource;
        return this;
    }

    @Override
    public void preAcknowledge(Transaction tx, MessageReference ref, AckReason reason) {
        if (this.mirrorControllerSource != null && reason != AckReason.REPLACED) {
            try {
                this.mirrorControllerSource.preAcknowledge(tx, ref, reason);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void postAcknowledge(MessageReference ref, AckReason reason) {
        if (this.mirrorControllerSource != null && reason != AckReason.REPLACED) {
            try {
                this.mirrorControllerSource.postAcknowledge(ref, reason);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void scanAddresses(MirrorController mirrorController) throws Exception {
        this.addressManager.scanAddresses(mirrorController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotification(Notification notification) {
        if (!(notification.getType() instanceof CoreNotificationType)) {
            return;
        }
        logger.trace("Receiving notification : {} on server {}", (Object)notification, (Object)this.server);
        Object object = this.notificationLock;
        synchronized (object) {
            CoreNotificationType type = (CoreNotificationType)notification.getType();
            switch (type) {
                case BINDING_ADDED: {
                    Binding binding;
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_BINDING_TYPE)) {
                        throw ActiveMQMessageBundle.BUNDLE.bindingTypeNotSpecified();
                    }
                    Integer bindingType = props.getIntProperty(ManagementHelper.HDR_BINDING_TYPE);
                    if (bindingType == 2) {
                        return;
                    }
                    SimpleString routingName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    SimpleString address = props.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
                    if (!props.containsProperty(ManagementHelper.HDR_BINDING_ID)) {
                        throw ActiveMQMessageBundle.BUNDLE.bindingIdNotSpecified();
                    }
                    long id = props.getLongProperty(ManagementHelper.HDR_BINDING_ID);
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug("PostOffice notification / BINDING_ADDED: HDR_DISANCE not specified, giving up propagation on notifications");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    QueueInfo info = new QueueInfo(routingName, clusterName, address, filterString, id, distance);
                    this.queueInfos.put(clusterName, info);
                    if (distance >= 1 || (binding = this.addressManager.getBinding(routingName)) == null) break;
                    Queue queue = (Queue)binding.getBindable();
                    AddressSettings addressSettings = this.addressSettingsRepository.getMatch(binding.getAddress().toString());
                    long redistributionDelay = addressSettings.getRedistributionDelay();
                    if (redistributionDelay == -1L) break;
                    try {
                        Bindings bindings = this.getBindingsForAddress(address);
                        for (Binding bind : bindings.getBindings()) {
                            RemoteQueueBinding remoteBinding;
                            if (!bind.isConnected() || !(bind instanceof RemoteQueueBinding) || (remoteBinding = (RemoteQueueBinding)bind).consumerCount() <= 0) continue;
                            queue.addRedistributor(redistributionDelay);
                        }
                    }
                    catch (Exception exception) {}
                    break;
                }
                case BINDING_REMOVED: {
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                        logger.debug("PostOffice notification / BINDING_REMOVED: HDR_CLUSTER_NAME not specified, giving up propagation on notifications");
                        return;
                    }
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    QueueInfo info = this.queueInfos.remove(clusterName);
                    if (info != null) break;
                    logger.debug("PostOffice notification / BINDING_REMOVED: Cannot find queue info for clusterName {}", (Object)clusterName);
                    return;
                }
                case CONSUMER_CREATED: {
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                        logger.debug("PostOffice notification / CONSUMER_CREATED: No clusterName defined");
                        return;
                    }
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    QueueInfo info = this.queueInfos.get(clusterName);
                    if (info == null) {
                        logger.debug("PostOffice notification / CONSUMER_CREATED: Could not find queue created on clusterName = {}", (Object)clusterName);
                        return;
                    }
                    info.incrementConsumers();
                    if (filterString != null) {
                        List<SimpleString> filterStrings = info.getFilterStrings();
                        if (filterStrings == null) {
                            filterStrings = new ArrayList<SimpleString>();
                            info.setFilterStrings(filterStrings);
                        }
                        filterStrings.add(filterString);
                    }
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug("PostOffice notification / CONSUMER_CREATED: No distance specified");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    if (distance <= 0) break;
                    SimpleString queueName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    if (queueName == null) {
                        logger.debug("PostOffice notification / CONSUMER_CREATED: No queue defined");
                        return;
                    }
                    SimpleString addressName = props.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
                    Binding binding = this.addressManager.getBinding(CompositeAddress.isFullyQualified((SimpleString)addressName) ? addressName : queueName);
                    if (binding == null) break;
                    Queue queue = (Queue)binding.getBindable();
                    AddressSettings addressSettings = this.addressSettingsRepository.getMatch(binding.getAddress().toString());
                    long redistributionDelay = addressSettings.getRedistributionDelay();
                    if (redistributionDelay == -1L) break;
                    queue.addRedistributor(redistributionDelay);
                    break;
                }
                case CONSUMER_CLOSED: {
                    TypedProperties props = notification.getProperties();
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    if (clusterName == null) {
                        logger.debug("PostOffice notification / CONSUMER_CLOSED: No cluster name");
                        return;
                    }
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    QueueInfo info = this.queueInfos.get(clusterName);
                    if (info == null) {
                        return;
                    }
                    info.decrementConsumers();
                    if (filterString != null) {
                        List<SimpleString> filterStrings = info.getFilterStrings();
                        filterStrings.remove(filterString);
                    }
                    if (info.getNumberOfConsumers() > 0) break;
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug("PostOffice notification / CONSUMER_CLOSED: HDR_DISTANCE not defined");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    if (distance != 0) break;
                    SimpleString queueName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    if (queueName == null) {
                        logger.debug("PostOffice notification / CONSUMER_CLOSED: No queue name");
                        return;
                    }
                    Binding binding = this.addressManager.getBinding(queueName);
                    if (binding == null) {
                        logger.debug("PostOffice notification / CONSUMER_CLOSED: Could not find queue {}", (Object)queueName);
                        return;
                    }
                    Queue queue = (Queue)binding.getBindable();
                    AddressSettings addressSettings = this.addressSettingsRepository.getMatch(binding.getAddress().toString());
                    long redistributionDelay = addressSettings.getRedistributionDelay();
                    if (redistributionDelay == -1L) break;
                    queue.addRedistributor(redistributionDelay);
                    break;
                }
            }
        }
    }

    @Override
    public void reloadAddressInfo(AddressInfo addressInfo) throws Exception {
        this.internalAddressInfo(addressInfo, true);
    }

    @Override
    public boolean addAddressInfo(AddressInfo addressInfo) throws Exception {
        return this.internalAddressInfo(addressInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalAddressInfo(AddressInfo addressInfo, boolean reload) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            boolean result;
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeAddAddress(addressInfo, reload));
            }
            if (result = reload ? this.addressManager.reloadAddressInfo(addressInfo) : this.addressManager.addAddressInfo(addressInfo)) {
                if (!reload && this.mirrorControllerSource != null) {
                    this.mirrorControllerSource.addAddress(addressInfo);
                }
                try {
                    long retroactiveMessageCount;
                    this.managementService.registerAddress(addressInfo);
                    if (this.server.hasBrokerAddressPlugins()) {
                        this.server.callBrokerAddressPlugins(plugin -> plugin.afterAddAddress(addressInfo, reload));
                    }
                    if ((retroactiveMessageCount = this.addressSettingsRepository.getMatch(addressInfo.getName().toString()).getRetroactiveMessageCount()) > 0L && !addressInfo.isInternal() && !ResourceNames.isRetroactiveResource((String)this.server.getInternalNamingPrefix(), (SimpleString)addressInfo.getName())) {
                        this.createRetroactiveResources(addressInfo.getName(), retroactiveMessageCount, reload);
                    }
                    if (ResourceNames.isRetroactiveResource((String)this.server.getInternalNamingPrefix(), (SimpleString)addressInfo.getName())) {
                        this.registerRepositoryListenerForRetroactiveAddress(addressInfo.getName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }

    private void registerRepositoryListenerForRetroactiveAddress(SimpleString name) {
        HierarchicalRepositoryChangeListener repositoryChangeListener = () -> {
            Queue internalMulticastQueue;
            String prefix = this.server.getInternalNamingPrefix();
            String delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString();
            String address = ResourceNames.decomposeRetroactiveResourceAddressName((String)prefix, (String)delimiter, (String)name.toString());
            AddressSettings settings = this.addressSettingsRepository.getMatch(address);
            Queue internalAnycastQueue = this.server.locateQueue(ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)SimpleString.of((String)address), (RoutingType)RoutingType.ANYCAST));
            if (internalAnycastQueue != null && internalAnycastQueue.getRingSize() != settings.getRetroactiveMessageCount()) {
                internalAnycastQueue.setRingSize(settings.getRetroactiveMessageCount());
            }
            if ((internalMulticastQueue = this.server.locateQueue(ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)SimpleString.of((String)address), (RoutingType)RoutingType.MULTICAST))) != null && internalMulticastQueue.getRingSize() != settings.getRetroactiveMessageCount()) {
                internalMulticastQueue.setRingSize(settings.getRetroactiveMessageCount());
            }
        };
        this.addressSettingsRepository.registerListener(repositoryChangeListener);
        this.server.getAddressInfo(name).setRepositoryChangeListener(repositoryChangeListener);
    }

    private void createRetroactiveResources(SimpleString retroactiveAddressName, long retroactiveMessageCount, boolean reload) throws Exception {
        String prefix = this.server.getInternalNamingPrefix();
        String delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString();
        SimpleString internalAddressName = ResourceNames.getRetroactiveResourceAddressName((String)prefix, (String)delimiter, (SimpleString)retroactiveAddressName);
        SimpleString internalAnycastQueueName = ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)retroactiveAddressName, (RoutingType)RoutingType.ANYCAST);
        SimpleString internalMulticastQueueName = ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)retroactiveAddressName, (RoutingType)RoutingType.MULTICAST);
        SimpleString internalDivertName = ResourceNames.getRetroactiveResourceDivertName((String)prefix, (String)delimiter, (SimpleString)retroactiveAddressName);
        if (!reload) {
            AddressInfo addressInfo = new AddressInfo(internalAddressName).addRoutingType(RoutingType.MULTICAST).addRoutingType(RoutingType.ANYCAST).setInternal(false);
            this.addAddressInfo(addressInfo);
            this.server.createQueue(QueueConfiguration.of((SimpleString)internalMulticastQueueName).setAddress(internalAddressName).setRoutingType(RoutingType.MULTICAST).setMaxConsumers(Integer.valueOf(0)).setRingSize(Long.valueOf(retroactiveMessageCount)));
            this.server.createQueue(QueueConfiguration.of((SimpleString)internalAnycastQueueName).setAddress(internalAddressName).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(0)).setRingSize(Long.valueOf(retroactiveMessageCount)));
        }
        this.server.deployDivert(new DivertConfiguration().setName(internalDivertName.toString()).setAddress(retroactiveAddressName.toString()).setExclusive(false).setForwardingAddress(internalAddressName.toString()).setRoutingType(ComponentConfigurationRoutingType.PASS));
    }

    private void removeRetroactiveResources(SimpleString address) throws Exception {
        SimpleString internalAddressName;
        SimpleString internalMulticastQueueName;
        SimpleString internalAnycastQueueName;
        String delimiter;
        String prefix = this.server.getInternalNamingPrefix();
        SimpleString internalDivertName = ResourceNames.getRetroactiveResourceDivertName((String)prefix, (String)(delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString()), (SimpleString)address);
        if (this.addressManager.getBinding(internalDivertName) != null) {
            this.server.destroyDivert(internalDivertName, true);
        }
        if (this.server.locateQueue(internalAnycastQueueName = ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)address, (RoutingType)RoutingType.ANYCAST)) != null) {
            this.server.destroyQueue(internalAnycastQueueName);
        }
        if (this.server.locateQueue(internalMulticastQueueName = ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)address, (RoutingType)RoutingType.MULTICAST)) != null) {
            this.server.destroyQueue(internalMulticastQueueName);
        }
        if (this.server.getAddressInfo(internalAddressName = ResourceNames.getRetroactiveResourceAddressName((String)prefix, (String)delimiter, (SimpleString)address)) != null) {
            this.server.removeAddressInfo(internalAddressName, null);
        }
    }

    @Override
    @Deprecated
    public QueueBinding updateQueue(SimpleString name, RoutingType routingType, Filter filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, SimpleString user, Boolean configurationManaged) throws Exception {
        return this.updateQueue(name, routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user, configurationManaged, null);
    }

    @Override
    @Deprecated
    public QueueBinding updateQueue(SimpleString name, RoutingType routingType, Filter filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, SimpleString user, Boolean configurationManaged, Long ringSize) throws Exception {
        return this.updateQueue(QueueConfiguration.of((SimpleString)name).setRoutingType(routingType).setFilterString(filter.getFilterString()).setMaxConsumers(maxConsumers).setPurgeOnNoConsumers(purgeOnNoConsumers).setExclusive(exclusive).setGroupRebalance(groupRebalance).setGroupBuckets(groupBuckets).setGroupFirstKey(groupFirstKey).setNonDestructive(nonDestructive).setConsumersBeforeDispatch(consumersBeforeDispatch).setDelayBeforeDispatch(delayBeforeDispatch).setUser(user).setConfigurationManaged(configurationManaged).setRingSize(ringSize));
    }

    @Override
    public QueueBinding updateQueue(QueueConfiguration queueConfiguration) throws Exception {
        return this.updateQueue(queueConfiguration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueBinding updateQueue(QueueConfiguration queueConfiguration, boolean forceUpdate) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            QueueBinding queueBinding;
            block28: {
                queueBinding = (QueueBinding)this.addressManager.getBinding(queueConfiguration.getName());
                if (queueBinding == null) {
                    return null;
                }
                Bindings bindingsOnQueue = this.addressManager.getExistingBindingsForRoutingAddress(queueBinding.getAddress());
                try {
                    SimpleString address;
                    AddressInfo addressInfo;
                    EnumSet<RoutingType> addressRoutingTypes;
                    int consumerCount;
                    Queue queue = queueBinding.getQueue();
                    boolean changed = false;
                    if (queueConfiguration.getMaxConsumers() != null && queueConfiguration.getMaxConsumers() != -1 && (consumerCount = queue.getConsumerCount()) > queueConfiguration.getMaxConsumers()) {
                        throw ActiveMQMessageBundle.BUNDLE.invalidMaxConsumersUpdate(queueConfiguration.getName().toString(), queueConfiguration.getMaxConsumers(), consumerCount);
                    }
                    if (queueConfiguration.getRoutingType() != null && !(addressRoutingTypes = (addressInfo = this.addressManager.getAddressInfo(address = queue.getAddress())).getRoutingTypes()).contains(queueConfiguration.getRoutingType())) {
                        throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeUpdate(queueConfiguration.getName().toString(), queueConfiguration.getRoutingType(), address.toString(), addressRoutingTypes);
                    }
                    if ((forceUpdate || queueConfiguration.getMaxConsumers() != null) && !Objects.equals(queue.getMaxConsumers(), queueConfiguration.getMaxConsumers())) {
                        changed = true;
                        queue.setMaxConsumer(queueConfiguration.getMaxConsumers());
                    }
                    if ((forceUpdate || queueConfiguration.getRoutingType() != null) && !Objects.equals(queue.getRoutingType(), queueConfiguration.getRoutingType())) {
                        changed = true;
                        queue.setRoutingType(queueConfiguration.getRoutingType());
                    }
                    if ((forceUpdate || queueConfiguration.isPurgeOnNoConsumers() != null) && !Objects.equals(queue.isPurgeOnNoConsumers(), queueConfiguration.isPurgeOnNoConsumers())) {
                        changed = true;
                        queue.setPurgeOnNoConsumers(queueConfiguration.isPurgeOnNoConsumers());
                    }
                    if ((forceUpdate || queueConfiguration.isEnabled() != null) && !Objects.equals(queue.isEnabled(), queueConfiguration.isEnabled())) {
                        changed = true;
                        queue.setEnabled(queueConfiguration.isEnabled());
                    }
                    if ((forceUpdate || queueConfiguration.isExclusive() != null) && !Objects.equals(queue.isExclusive(), queueConfiguration.isExclusive())) {
                        changed = true;
                        queue.setExclusive(queueConfiguration.isExclusive());
                    }
                    if ((forceUpdate || queueConfiguration.isGroupRebalance() != null) && !Objects.equals(queue.isGroupRebalance(), queueConfiguration.isGroupRebalance())) {
                        changed = true;
                        queue.setGroupRebalance(queueConfiguration.isGroupRebalance());
                    }
                    if ((forceUpdate || queueConfiguration.isGroupRebalancePauseDispatch() != null) && !Objects.equals(queue.isGroupRebalancePauseDispatch(), queueConfiguration.isGroupRebalancePauseDispatch())) {
                        changed = true;
                        queue.setGroupRebalancePauseDispatch(queueConfiguration.isGroupRebalancePauseDispatch());
                    }
                    if ((forceUpdate || queueConfiguration.getGroupBuckets() != null) && !Objects.equals(queue.getGroupBuckets(), queueConfiguration.getGroupBuckets())) {
                        changed = true;
                        queue.setGroupBuckets(queueConfiguration.getGroupBuckets());
                    }
                    if ((forceUpdate || queueConfiguration.getGroupFirstKey() != null) && !Objects.equals(queueConfiguration.getGroupFirstKey(), queue.getGroupFirstKey())) {
                        changed = true;
                        queue.setGroupFirstKey(queueConfiguration.getGroupFirstKey());
                    }
                    if ((forceUpdate || queueConfiguration.isNonDestructive() != null) && !Objects.equals(queue.isNonDestructive(), queueConfiguration.isNonDestructive())) {
                        changed = true;
                        queue.setNonDestructive(queueConfiguration.isNonDestructive());
                    }
                    if ((forceUpdate || queueConfiguration.getConsumersBeforeDispatch() != null) && !Objects.equals(queueConfiguration.getConsumersBeforeDispatch(), queue.getConsumersBeforeDispatch())) {
                        changed = true;
                        queue.setConsumersBeforeDispatch(queueConfiguration.getConsumersBeforeDispatch());
                    }
                    if ((forceUpdate || queueConfiguration.getDelayBeforeDispatch() != null) && !Objects.equals(queueConfiguration.getDelayBeforeDispatch(), queue.getDelayBeforeDispatch())) {
                        changed = true;
                        queue.setDelayBeforeDispatch(queueConfiguration.getDelayBeforeDispatch());
                    }
                    SimpleString empty = SimpleString.of((String)"");
                    Filter oldFilter = FilterImpl.createFilter(queue.getFilter() == null ? empty : queue.getFilter().getFilterString());
                    Filter newFilter = FilterImpl.createFilter(queueConfiguration.getFilterString() == null ? empty : queueConfiguration.getFilterString());
                    if ((forceUpdate || newFilter != oldFilter) && !Objects.equals(oldFilter, newFilter)) {
                        changed = true;
                        queue.setFilter(newFilter);
                        this.notifyBindingUpdatedForQueue(queueBinding);
                    }
                    if ((forceUpdate || queueConfiguration.isConfigurationManaged() != null) && !Objects.equals(queueConfiguration.isConfigurationManaged(), queue.isConfigurationManaged())) {
                        changed = true;
                        queue.setConfigurationManaged(queueConfiguration.isConfigurationManaged());
                    }
                    if ((forceUpdate || queueConfiguration.getUser() != null) && !Objects.equals(queueConfiguration.getUser(), queue.getUser())) {
                        changed = true;
                        queue.setUser(queueConfiguration.getUser());
                    }
                    if ((forceUpdate || queueConfiguration.getRingSize() != null) && !Objects.equals(queueConfiguration.getRingSize(), queue.getRingSize())) {
                        changed = true;
                        queue.setRingSize(queueConfiguration.getRingSize());
                    }
                    if (!changed) break block28;
                    long txID = this.storageManager.generateID();
                    try {
                        this.storageManager.updateQueueBinding(txID, queueBinding);
                        this.storageManager.commitBindings(txID);
                    }
                    catch (Throwable throwable) {
                        this.storageManager.rollback(txID);
                        logger.warn(throwable.getMessage(), throwable);
                        throw throwable;
                    }
                }
                finally {
                    if (bindingsOnQueue != null) {
                        bindingsOnQueue.updated(queueBinding);
                    }
                }
            }
            return queueBinding;
        }
    }

    public void notifyBindingUpdatedForQueue(QueueBinding binding) throws Exception {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
        Filter filter = binding.getFilter();
        if (filter != null) {
            props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filter.getFilterString());
        }
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
        String uid = UUIDGenerator.getInstance().generateStringUUID();
        logger.debug("ClusterCommunication::Sending notification for updateBinding {} from server {}", (Object)binding, (Object)this.server);
        this.managementService.sendNotification(new Notification(uid, (NotificationType)CoreNotificationType.BINDING_UPDATED, props));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressInfo updateAddressInfo(SimpleString addressName, EnumSet<RoutingType> routingTypes) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeUpdateAddress(addressName, routingTypes));
            }
            AddressInfo address = this.addressManager.updateAddressInfo(addressName, routingTypes);
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.afterUpdateAddress(address));
            }
            return address;
        }
    }

    @Override
    public AddressInfo removeAddressInfo(SimpleString address) throws Exception {
        return this.removeAddressInfo(address, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressInfo removeAddressInfo(SimpleString address, boolean force) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeRemoveAddress(address));
            }
            Collection<Binding> bindingsForAddress = this.getDirectBindings(address);
            if (force) {
                for (Binding binding : bindingsForAddress) {
                    if (binding instanceof LocalQueueBinding) {
                        LocalQueueBinding localQueueBinding = (LocalQueueBinding)binding;
                        localQueueBinding.getQueue().deleteQueue(true);
                        continue;
                    }
                    if (!(binding instanceof RemoteQueueBinding)) continue;
                    this.removeBinding(binding.getUniqueName(), null, true);
                }
            } else if (!bindingsForAddress.isEmpty()) {
                throw ActiveMQMessageBundle.BUNDLE.addressHasBindings(address);
            }
            this.managementService.unregisterAddress(address);
            AddressInfo addressInfo = this.addressManager.removeAddressInfo(address);
            if (this.mirrorControllerSource != null && addressInfo != null) {
                this.mirrorControllerSource.deleteAddress(addressInfo);
            }
            this.removeRetroactiveResources(address);
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.afterRemoveAddress(address, addressInfo));
            }
            return addressInfo;
        }
    }

    @Override
    public AddressInfo getAddressInfo(SimpleString addressName) {
        return this.addressManager.getAddressInfo(addressName);
    }

    @Override
    public List<Queue> listQueuesForAddress(SimpleString address) throws Exception {
        Bindings bindingsForAddress = this.lookupBindingsForAddress(address);
        ArrayList<Queue> queues = new ArrayList<Queue>();
        if (bindingsForAddress != null) {
            for (Binding b : bindingsForAddress.getBindings()) {
                if (!(b instanceof QueueBinding)) continue;
                QueueBinding queueBinding = (QueueBinding)b;
                Queue q = queueBinding.getQueue();
                queues.add(q);
            }
        }
        return queues;
    }

    @Override
    public synchronized void addBinding(Binding binding) throws Exception {
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.beforeAddBinding(binding));
        }
        this.addressManager.addBinding(binding);
        TypedProperties props = new TypedProperties();
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, binding.getType().toInt());
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
        props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
        props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
        props.putLongProperty(ManagementHelper.HDR_BINDING_ID, binding.getID().longValue());
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
        Filter filter = binding.getFilter();
        if (filter != null) {
            props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filter.getFilterString());
        }
        String uid = UUIDGenerator.getInstance().generateStringUUID();
        logger.debug("ClusterCommunication::Sending notification for addBinding {} from server {}", (Object)binding, (Object)this.server);
        this.managementService.sendNotification(new Notification(uid, (NotificationType)CoreNotificationType.BINDING_ADDED, props));
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.afterAddBinding(binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Binding removeBinding(SimpleString uniqueName, Transaction tx, boolean deleteData) throws Exception {
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.beforeRemoveBinding(uniqueName, tx, deleteData));
        }
        try {
            Binding binding = this.addressManager.removeBinding(uniqueName, tx);
            if (binding == null) {
                throw new ActiveMQNonExistentQueueException();
            }
            if (deleteData && this.addressManager.getExistingBindingsForRoutingAddress(binding.getAddress()) == null) {
                this.deleteDuplicateCache(binding.getAddress());
            }
            if (binding.getType() == BindingType.LOCAL_QUEUE) {
                Queue queue = (Queue)binding.getBindable();
                this.managementService.unregisterQueue(uniqueName, binding.getAddress(), queue.getRoutingType());
            } else if (binding.getType() == BindingType.DIVERT) {
                this.managementService.unregisterDivert(uniqueName, binding.getAddress());
            }
            AddressInfo addressInfo = this.getAddressInfo(binding.getAddress());
            if (addressInfo != null) {
                addressInfo.setBindingRemovedTimestamp(System.currentTimeMillis());
            }
            if (binding.getType() != BindingType.DIVERT) {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
                props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
                props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
                props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
                props.putLongProperty(ManagementHelper.HDR_BINDING_ID, binding.getID().longValue());
                if (binding.getFilter() == null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, null);
                } else {
                    props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, binding.getFilter().getFilterString());
                }
                this.managementService.sendNotification(new Notification(null, (NotificationType)CoreNotificationType.BINDING_REMOVED, props));
            }
            binding.close();
            if (this.server.hasBrokerBindingPlugins()) {
                this.server.callBrokerBindingPlugins(plugin -> plugin.afterRemoveBinding(binding, tx, deleteData));
            }
            Binding binding2 = binding;
            return binding2;
        }
        finally {
            this.server.clearAddressCache();
        }
    }

    private void deleteDuplicateCache(SimpleString address) throws Exception {
        DuplicateIDCache cache = (DuplicateIDCache)this.duplicateIDCaches.remove(address);
        if (cache != null) {
            cache.clear();
        }
        if ((cache = (DuplicateIDCache)this.duplicateIDCaches.remove(BRIDGE_CACHE_STR.concat(address))) != null) {
            cache.clear();
        }
    }

    @Override
    public boolean isAddressBound(SimpleString address) throws Exception {
        Collection<Binding> bindings = this.getDirectBindings(address);
        return bindings != null && !bindings.isEmpty();
    }

    @Override
    public Bindings getBindingsForAddress(SimpleString address) throws Exception {
        Bindings bindings = this.addressManager.getExistingBindingsForRoutingAddress(address);
        if (bindings == null) {
            bindings = this.createBindings(address);
        }
        return bindings;
    }

    @Override
    public Bindings lookupBindingsForAddress(SimpleString address) throws Exception {
        return this.addressManager.getExistingBindingsForRoutingAddress(address);
    }

    @Override
    public LocalQueueBinding findLocalBinding(long bindingID) {
        return this.addressManager.findLocalBinding(bindingID);
    }

    @Override
    public synchronized Binding getBinding(SimpleString name) {
        return this.addressManager.getBinding(name);
    }

    @Override
    public Collection<Binding> getMatchingBindings(SimpleString address) throws Exception {
        return this.addressManager.getMatchingBindings(address);
    }

    @Override
    public Collection<Binding> getDirectBindings(SimpleString address) throws Exception {
        return this.addressManager.getDirectBindings(address);
    }

    @Override
    public Stream<Binding> getAllBindings() {
        return this.addressManager.getBindings();
    }

    @Override
    public RoutingStatus route(Message message, boolean direct) throws Exception {
        return this.route(message, (Transaction)null, direct);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct, boolean rejectDuplicates) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct, rejectDuplicates, null);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct, boolean rejectDuplicates, Binding binding) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct, rejectDuplicates, binding);
    }

    @Override
    public RoutingStatus route(Message message, RoutingContext context, boolean direct) throws Exception {
        return this.route(message, context, direct, true, null, false);
    }

    @Override
    public RoutingStatus route(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, Binding bindingMove) throws Exception {
        return this.route(message, context, direct, rejectDuplicates, bindingMove, false);
    }

    private RoutingStatus route(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, Binding bindingMove, boolean sendToDLA) throws Exception {
        RoutingStatus status;
        boolean startedTX;
        if (message.getRefCount() > 0) {
            throw new IllegalStateException("Message cannot be routed more than once");
        }
        SimpleString address = context.getAddress(message);
        AddressSettings settings = this.addressSettingsRepository.getMatch(address.toString());
        if (settings != null) {
            PostOfficeImpl.applyExpiryDelay(message, settings);
        }
        if (context.isDuplicateDetection()) {
            DuplicateCheckResult duplicateCheckResult = this.checkDuplicateID(message, context, rejectDuplicates);
            switch (duplicateCheckResult) {
                case DuplicateNotStartedTX: {
                    return RoutingStatus.DUPLICATED_ID;
                }
                case NoDuplicateStartedTX: {
                    startedTX = true;
                    break;
                }
                case NoDuplicateNotStartedTX: {
                    startedTX = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)duplicateCheckResult));
                }
            }
        } else {
            startedTX = false;
        }
        if (context.getMirrorSource() == null) {
            message.clearAMQPProperties();
        }
        message.clearInternalProperties();
        AddressInfo addressInfo = this.checkAddress(context, address);
        if (bindingMove != null) {
            context.clear();
            context.setReusable(false);
            bindingMove.route(message, context);
            if (addressInfo != null) {
                addressInfo.incrementRoutedMessageCount();
            }
            status = RoutingStatus.OK;
        } else {
            Bindings bindings = this.simpleRoute(address, context, message, addressInfo);
            if (logger.isDebugEnabled()) {
                if (bindings != null) {
                    logger.debug("PostOffice::simpleRoute returned bindings with size = {}", (Object)bindings.getBindings().size());
                } else {
                    logger.debug("PostOffice::simpleRoute null as bindings");
                }
            }
            if (bindings == null) {
                context.setReusable(false);
                context.clear();
                if (addressInfo != null) {
                    addressInfo.incrementUnRoutedMessageCount();
                }
                logger.debug("Couldn't find any bindings for address={} on message={}", (Object)address, (Object)message);
                status = RoutingStatus.NO_BINDINGS;
            } else {
                status = RoutingStatus.OK;
            }
        }
        if (this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.beforeMessageRoute(message, context, direct, rejectDuplicates));
        }
        logger.trace("Message after routed={}\n{}", (Object)message, (Object)context);
        try {
            RoutingStatus finalStatus;
            if (status == RoutingStatus.NO_BINDINGS) {
                finalStatus = this.maybeSendToDLA(message, context, address, sendToDLA);
            } else {
                finalStatus = status;
                try {
                    if (context.getQueueCount() > 0) {
                        this.processRoute(message, context, direct);
                    } else if (message.isLargeMessage()) {
                        ((LargeServerMessage)message).deleteFile();
                    }
                }
                catch (ActiveMQAddressFullException e) {
                    if (startedTX) {
                        context.getTransaction().rollback();
                    } else if (context.getTransaction() != null) {
                        context.getTransaction().markAsRollbackOnly((ActiveMQException)((Object)e));
                    }
                    throw e;
                }
            }
            if (startedTX) {
                context.getTransaction().commit();
            }
            if (this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.afterMessageRoute(message, context, direct, rejectDuplicates, finalStatus));
            }
            return finalStatus;
        }
        catch (Exception e) {
            if (this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.onMessageRouteException(message, context, direct, rejectDuplicates, e));
            }
            throw e;
        }
    }

    private AddressInfo checkAddress(RoutingContext context, SimpleString address) throws Exception {
        AddressInfo addressInfo = this.addressManager.getAddressInfo(address);
        if (addressInfo == null && context.getServerSession() != null) {
            AutoCreateResult autoCreateResult = context.getServerSession().checkAutoCreate(QueueConfiguration.of((SimpleString)address).setRoutingType(context.getRoutingType()));
            if (autoCreateResult == AutoCreateResult.NOT_FOUND) {
                ActiveMQAddressDoesNotExistException ex = ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(address);
                if (context.getTransaction() != null) {
                    context.getTransaction().markAsRollbackOnly((ActiveMQException)ex);
                }
                throw ex;
            }
            addressInfo = this.addressManager.getAddressInfo(address);
        }
        return addressInfo;
    }

    Bindings simpleRoute(SimpleString address, RoutingContext context, Message message, AddressInfo addressInfo) throws Exception {
        Bindings bindings = this.addressManager.getBindingsForRoutingAddress(address);
        if (!(bindings != null && bindings.hasLocalBinding() || context.getServerSession() == null)) {
            AutoCreateResult autoCreateResult = context.getServerSession().checkAutoCreate(QueueConfiguration.of((SimpleString)address).setRoutingType(context.getRoutingType()));
            if (autoCreateResult == AutoCreateResult.NOT_FOUND) {
                ActiveMQAddressDoesNotExistException e = ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(address);
                Transaction tx = context.getTransaction();
                if (tx != null) {
                    tx.markAsRollbackOnly((ActiveMQException)e);
                }
                throw e;
            }
            bindings = this.addressManager.getBindingsForRoutingAddress(address);
        }
        if (bindings != null) {
            bindings.route(message, context);
            if (addressInfo != null) {
                addressInfo.incrementRoutedMessageCount();
            }
        }
        return bindings;
    }

    private RoutingStatus maybeSendToDLA(Message message, RoutingContext context, SimpleString address, boolean sendToDLAHint) throws Exception {
        RoutingStatus status;
        boolean sendToDLA;
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(address.toString());
        if (sendToDLAHint) {
            sendToDLA = false;
        } else {
            boolean bl = sendToDLA = addressSettings != null ? addressSettings.isSendToDLAOnNoRoute() : false;
        }
        if (sendToDLA) {
            SimpleString dlaAddress = addressSettings != null ? addressSettings.getDeadLetterAddress() : null;
            logger.debug("sending message to dla address = {}, message={}", (Object)dlaAddress, (Object)message);
            if (dlaAddress == null) {
                status = RoutingStatus.NO_BINDINGS;
                ActiveMQServerLogger.LOGGER.noDLA(address);
            } else {
                message.referenceOriginalMessage(message, null);
                message.setAddress(dlaAddress);
                message.setRoutingType(null);
                message.reencode();
                this.route(message, new RoutingContextImpl(context.getTransaction()), false, true, null, true);
                status = RoutingStatus.NO_BINDINGS_DLA;
            }
        } else {
            status = RoutingStatus.NO_BINDINGS;
            logger.debug("Message {} is not going anywhere as it didn't have a binding on address:{}", (Object)message, (Object)address);
            if (message.isLargeMessage()) {
                ((LargeServerMessage)message).deleteFile();
            }
        }
        return status;
    }

    protected static void applyExpiryDelay(Message message, AddressSettings settings) {
        long expirationOverride = settings.getExpiryDelay();
        if (settings.isNoExpiry().booleanValue()) {
            if (message.getExpiration() != 0L) {
                message.setExpiration(0L);
                message.reencode();
            }
        } else if (expirationOverride >= 0L) {
            if (message.getExpiration() == 0L) {
                PostOfficeImpl.setExpiration(message, expirationOverride);
            }
        } else {
            long minExpiration = settings.getMinExpiryDelay();
            long maxExpiration = settings.getMaxExpiryDelay();
            if (message.getExpiration() == 0L) {
                if (maxExpiration != -1L) {
                    PostOfficeImpl.setExpiration(message, maxExpiration);
                } else if (minExpiration != -1L) {
                    PostOfficeImpl.setExpiration(message, minExpiration);
                }
            } else if (maxExpiration != -1L && message.getExpiration() > System.currentTimeMillis() + maxExpiration) {
                PostOfficeImpl.setExpiration(message, maxExpiration);
            } else if (minExpiration != -1L && message.getExpiration() < System.currentTimeMillis() + minExpiration) {
                PostOfficeImpl.setExpiration(message, minExpiration);
            }
        }
    }

    private static void setExpiration(Message m, long expiration) {
        m.setExpiration(System.currentTimeMillis() + expiration);
        m.reencode();
    }

    @Override
    public MessageReference reload(Message message, Queue queue, Transaction tx) throws Exception {
        Long scheduledDeliveryTime;
        message.setOwner((Object)this.pagingManager.getPageStore(message.getAddressSimpleString()));
        MessageReference reference = MessageReference.Factory.createReference(message, queue);
        if (message.hasScheduledDeliveryTime() && (scheduledDeliveryTime = message.getScheduledDeliveryTime()) != null) {
            reference.setScheduledDeliveryTime(scheduledDeliveryTime);
        }
        queue.refUp(reference);
        queue.durableUp(message);
        if (tx == null) {
            queue.reload(reference);
        } else {
            ArrayList<MessageReference> refs = new ArrayList<MessageReference>(1);
            refs.add(reference);
            tx.addOperation(new AddOperation(refs));
        }
        return reference;
    }

    @Override
    public Pair<RoutingContext, Message> redistribute(Message message, Queue originatingQueue) throws Exception {
        Bindings bindings = this.addressManager.getBindingsForRoutingAddress(message.getAddressSimpleString());
        if (bindings != null && bindings.allowRedistribute()) {
            RoutingContextImpl context;
            Message redistributedMessage;
            if (logger.isDebugEnabled()) {
                logger.debug("Redistributing message {}, originatingQueue={}, bindings={}", new Object[]{message, originatingQueue.getName(), bindings});
            }
            if ((redistributedMessage = bindings.redistribute(message, originatingQueue, context = new RoutingContextImpl(null))) != null) {
                return new Pair((Object)context, (Object)redistributedMessage);
            }
            logger.debug("Redistribution of message {} did not happen because bindings.redistribute returned null", (Object)message);
        } else {
            logger.debug("not able to redistribute message={} towards bindings={}", (Object)message, (Object)bindings);
        }
        return null;
    }

    private int resolveIdCacheSize(SimpleString address) {
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(address.toString());
        return addressSettings.getIDCacheSize() == null ? this.idCacheSize : addressSettings.getIDCacheSize();
    }

    @Override
    public DuplicateIDCache getDuplicateIDCache(SimpleString address) {
        int resolvedIdCacheSize = this.resolveIdCacheSize(address);
        return this.getDuplicateIDCache(address, resolvedIdCacheSize, false);
    }

    @Override
    public DuplicateIDCache getDuplicateIDCache(SimpleString address, int cacheSizeToUse) {
        return this.getDuplicateIDCache(address, cacheSizeToUse, true);
    }

    private DuplicateIDCache getDuplicateIDCache(SimpleString address, int cacheSizeToUse, boolean allowRegistration) {
        DuplicateIDCache cache = (DuplicateIDCache)this.duplicateIDCaches.get(address);
        if (cache == null) {
            if (this.persistIDCache) {
                if (allowRegistration) {
                    this.registerCacheSize(address, cacheSizeToUse);
                }
                cache = DuplicateIDCaches.persistent(address, cacheSizeToUse, this.storageManager);
            } else {
                cache = DuplicateIDCaches.inMemory(address, cacheSizeToUse);
            }
            DuplicateIDCache oldCache = this.duplicateIDCaches.putIfAbsent(address, cache);
            if (oldCache != null) {
                cache = oldCache;
            }
        }
        return cache;
    }

    private void registerCacheSize(SimpleString address, int cacheSizeToUse) {
        AbstractPersistedAddressSetting recordedSetting = this.storageManager.recoverAddressSettings(address);
        if (recordedSetting == null || recordedSetting.getSetting().getIDCacheSize() == null || recordedSetting.getSetting().getIDCacheSize() != cacheSizeToUse) {
            AddressSettings settings = recordedSetting != null ? recordedSetting.getSetting() : new AddressSettings();
            settings.setIDCacheSize(cacheSizeToUse);
            this.server.getAddressSettingsRepository().addMatch(address.toString(), settings);
            try {
                this.storageManager.storeAddressSetting(new PersistedAddressSettingJSON(address, settings, settings.toJSON()));
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRegisteringDuplicateCacheSize(String.valueOf(address), e);
            }
        }
    }

    public ConcurrentMap<SimpleString, DuplicateIDCache> getDuplicateIDCaches() {
        return this.duplicateIDCaches;
    }

    @Override
    public Object getNotificationLock() {
        return this.notificationLock;
    }

    @Override
    public Set<SimpleString> getAddresses() {
        return this.addressManager.getAddresses();
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, RoutingType routingType) throws Exception {
        return this.addressManager.getMatchingQueue(address, routingType);
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, SimpleString queueName, RoutingType routingType) throws Exception {
        return this.addressManager.getMatchingQueue(address, queueName, routingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueueInfoToQueue(SimpleString queueName, SimpleString address) throws Exception {
        Binding binding = this.addressManager.getBinding(queueName);
        if (binding == null) {
            throw new IllegalStateException("Cannot find queue " + String.valueOf(queueName));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("PostOffice.sendQueueInfoToQueue on server={}, queueName={} and address={}", new Object[]{this.server, queueName, address});
        }
        Queue queue = (Queue)binding.getBindable();
        Object object = this.notificationLock;
        synchronized (object) {
            CoreMessage message = new CoreMessage(this.storageManager.generateID(), 50);
            message.setAddress(queueName);
            message.putBooleanProperty(HDR_RESET_QUEUE_DATA, true);
            this.routeQueueInfo((Message)message, queue, false);
            for (QueueInfo info : this.queueInfos.values()) {
                logger.trace("QueueInfo on sendQueueInfoToQueue = {}", (Object)info);
                if (!info.matchesAddress(address)) continue;
                message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.BINDING_ADDED, queueName);
                message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                message.putLongProperty(ManagementHelper.HDR_BINDING_ID, info.getID());
                message.putStringProperty(ManagementHelper.HDR_FILTERSTRING, info.getFilterString());
                message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                this.routeQueueInfo((Message)message, queue, true);
                int consumersWithFilters = info.getFilterStrings() != null ? info.getFilterStrings().size() : 0;
                for (int i = 0; i < info.getNumberOfConsumers() - consumersWithFilters; ++i) {
                    message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.CONSUMER_CREATED, queueName);
                    message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                    message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                    message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                    message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                    this.routeQueueInfo((Message)message, queue, true);
                }
                if (info.getFilterStrings() == null) continue;
                for (SimpleString filterString : info.getFilterStrings()) {
                    message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.CONSUMER_CREATED, queueName);
                    message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                    message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                    message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                    message.putStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
                    message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                    this.routeQueueInfo((Message)message, queue, true);
                }
            }
            CoreMessage completeMessage = new CoreMessage(this.storageManager.generateID(), 50);
            completeMessage.setAddress(queueName);
            completeMessage.putBooleanProperty(HDR_RESET_QUEUE_DATA_COMPLETE, true);
            this.routeQueueInfo((Message)completeMessage, queue, false);
        }
    }

    public String toString() {
        return "PostOfficeImpl [server=" + String.valueOf(this.server) + "]";
    }

    private void routeQueueInfo(Message message, Queue queue, boolean applyFilters) throws Exception {
        if (!applyFilters || queue.getFilter() == null || queue.getFilter().match(message)) {
            RoutingContextImpl context = new RoutingContextImpl(null);
            queue.route(message, context);
            this.processRoute(message, context, false);
        }
    }

    @Override
    public void processRoute(Message message, RoutingContext context, final boolean direct) throws Exception {
        final ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        Transaction tx = context.getTransaction();
        boolean containsDurables = false;
        Long deliveryTime = message.hasScheduledDeliveryTime() ? message.getScheduledDeliveryTime() : null;
        SimpleString messageAddress = message.getAddressSimpleString();
        PagingStore owningStore = this.pagingManager.getPageStore(messageAddress);
        message.setOwner((Object)owningStore);
        for (Map.Entry<SimpleString, RouteContextList> entry : context.getContexListing().entrySet()) {
            List<Queue> durableQueues;
            PagingStore store = entry.getKey().equals((Object)messageAddress) ? owningStore : this.pagingManager.getPageStore(entry.getKey());
            if (store != null && this.storageManager.addToPage(store, message, context.getTransaction(), entry.getValue())) {
                this.schedulePageDelivery(tx, entry);
                continue;
            }
            List<Queue> nonDurableQueues = entry.getValue().getNonDurableQueues();
            if (!nonDurableQueues.isEmpty()) {
                refs.ensureCapacity(nonDurableQueues.size());
                nonDurableQueues.forEach(queue -> {
                    MessageReference reference = MessageReference.Factory.createReference(message, queue);
                    if (deliveryTime != null) {
                        reference.setScheduledDeliveryTime(deliveryTime);
                    }
                    refs.add(reference);
                    queue.refUp(reference);
                });
            }
            if ((durableQueues = entry.getValue().getDurableQueues()).isEmpty()) continue;
            this.processRouteToDurableQueues(message, context, deliveryTime, tx, durableQueues, refs);
            containsDurables = true;
        }
        if (this.mirrorControllerSource != null && !context.isMirrorDisabled()) {
            this.mirrorControllerSource.sendMessage(tx, message, context);
        }
        if (tx != null) {
            tx.addOperation(new AddOperation(refs));
        } else if (!containsDurables) {
            PostOfficeImpl.processReferences(refs, direct);
        } else {
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorAddingReferences(errorCode, errorMessage);
                }

                public void done() {
                    PostOfficeImpl.processReferences(refs, direct);
                }
            });
        }
    }

    public static void processReferences(List<MessageReference> refs, boolean direct) {
        refs.forEach(ref -> PostOfficeImpl.processReference(ref, direct));
    }

    public static void processReference(MessageReference ref, boolean direct) {
        ref.getQueue().addTail(ref, direct);
    }

    private void processRouteToDurableQueues(Message message, RoutingContext context, Long deliveryTime, Transaction tx, List<Queue> durableQueues, ArrayList<MessageReference> refs) throws Exception {
        int durableQueuesCount = durableQueues.size();
        refs.ensureCapacity(durableQueuesCount);
        Iterator<Queue> iter = durableQueues.iterator();
        for (int i = 0; i < durableQueuesCount; ++i) {
            Queue queue = iter.next();
            MessageReference reference = MessageReference.Factory.createReference(message, queue);
            if (context.isAlreadyAcked(message, queue)) {
                reference.setAlreadyAcked();
                if (tx != null) {
                    queue.acknowledge(tx, reference);
                }
            }
            if (deliveryTime != null) {
                reference.setScheduledDeliveryTime(deliveryTime);
            }
            refs.add(reference);
            queue.refUp(reference);
            if (!message.isDurable()) continue;
            PostOfficeImpl.storeDurableReference(this.storageManager, message, tx, queue, durableQueuesCount - 1 == i);
            if (deliveryTime == null || deliveryTime <= 0L) continue;
            if (tx != null) {
                this.storageManager.updateScheduledDeliveryTimeTransactional(tx.getID(), reference);
                continue;
            }
            this.storageManager.updateScheduledDeliveryTime(reference);
        }
    }

    public static void storeDurableReference(StorageManager storageManager, Message message, Transaction tx, Queue queue, boolean sync) throws Exception {
        assert (message.isDurable());
        int durableRefCount = queue.durableUp(message);
        if (durableRefCount == 1) {
            if (tx != null) {
                storageManager.storeMessageTransactional(tx.getID(), message);
            } else {
                storageManager.storeMessage(message);
            }
        }
        if (tx != null) {
            storageManager.storeReferenceTransactional(tx.getID(), queue.getID(), message.getMessageID());
            tx.setContainsPersistent();
        } else {
            storageManager.storeReference(queue.getID(), message.getMessageID(), sync);
        }
    }

    private void schedulePageDelivery(Transaction tx, Map.Entry<SimpleString, RouteContextList> entry) {
        if (tx != null) {
            PageDelivery delivery = (PageDelivery)tx.getProperty(7);
            if (delivery == null) {
                delivery = new PageDelivery();
                tx.putProperty(7, delivery);
                tx.addOperation(delivery);
            }
            delivery.addQueues(entry.getValue().getDurableQueues());
            delivery.addQueues(entry.getValue().getNonDurableQueues());
        } else {
            List<Queue> durableQueues = entry.getValue().getDurableQueues();
            List<Queue> nonDurableQueues = entry.getValue().getNonDurableQueues();
            final ArrayList<Queue> queues = new ArrayList<Queue>(durableQueues.size() + nonDurableQueues.size());
            queues.addAll(durableQueues);
            queues.addAll(nonDurableQueues);
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                }

                public void done() {
                    for (Queue queue : queues) {
                        queue.deliverAsync();
                    }
                }
            });
        }
    }

    private DuplicateCheckResult checkDuplicateID(Message message, RoutingContext context, boolean rejectDuplicates) throws Exception {
        byte[] bridgeDup = message.removeExtraBytesProperty(Message.HDR_BRIDGE_DUPLICATE_ID);
        if (bridgeDup != null) {
            return this.checkBridgeDuplicateID(message, context, bridgeDup);
        }
        byte[] duplicateIDBytes = message.getDuplicateIDBytes();
        if (duplicateIDBytes == null) {
            return DuplicateCheckResult.NoDuplicateNotStartedTX;
        }
        return this.checkNotBridgeDuplicateID(message, context, rejectDuplicates, duplicateIDBytes);
    }

    private DuplicateCheckResult checkNotBridgeDuplicateID(Message message, RoutingContext context, boolean rejectDuplicates, byte[] duplicateIDBytes) throws Exception {
        boolean startedTX;
        assert (duplicateIDBytes != null && Arrays.equals(message.getDuplicateIDBytes(), duplicateIDBytes));
        DuplicateIDCache cache = this.getDuplicateIDCache(context.getAddress(message));
        boolean isDuplicate = cache.contains(duplicateIDBytes);
        if (rejectDuplicates && isDuplicate) {
            ActiveMQServerLogger.LOGGER.duplicateMessageDetected(message);
            if (context.getTransaction() != null) {
                String warnMessage = "Duplicate message detected - message will not be routed. Message information:" + String.valueOf(message);
                context.getTransaction().markAsRollbackOnly((ActiveMQException)new ActiveMQDuplicateIdException(warnMessage));
            }
            message.usageDown();
            return DuplicateCheckResult.DuplicateNotStartedTX;
        }
        if (isDuplicate) {
            assert (!rejectDuplicates);
            return DuplicateCheckResult.NoDuplicateNotStartedTX;
        }
        if (context.getTransaction() == null) {
            context.setTransaction(new TransactionImpl(this.storageManager));
            startedTX = true;
        } else {
            startedTX = false;
        }
        cache.addToCache(duplicateIDBytes, context.getTransaction(), startedTX);
        return startedTX ? DuplicateCheckResult.NoDuplicateStartedTX : DuplicateCheckResult.NoDuplicateNotStartedTX;
    }

    private DuplicateCheckResult checkBridgeDuplicateID(Message message, RoutingContext context, byte[] bridgeDupBytes) throws Exception {
        DuplicateIDCache cacheBridge;
        assert (bridgeDupBytes != null);
        boolean startedTX = false;
        if (context.getTransaction() == null) {
            context.setTransaction(new TransactionImpl(this.storageManager));
            startedTX = true;
        }
        if (!(cacheBridge = this.getDuplicateIDCache(BRIDGE_CACHE_STR.concat(context.getAddress(message).toString()))).atomicVerify(bridgeDupBytes, context.getTransaction())) {
            context.getTransaction().rollback();
            message.usageDown();
            return DuplicateCheckResult.DuplicateNotStartedTX;
        }
        return startedTX ? DuplicateCheckResult.NoDuplicateStartedTX : DuplicateCheckResult.NoDuplicateNotStartedTX;
    }

    @Override
    public synchronized void startExpiryScanner() {
        if (this.expiryReaperPeriod > 0L) {
            if (this.expiryReaperRunnable != null) {
                this.expiryReaperRunnable.stop();
            }
            this.expiryReaperRunnable = new ExpiryReaper(this.server.getScheduledPool(), (Executor)this.server.getExecutorFactory().getExecutor(), this.expiryReaperPeriod, TimeUnit.MILLISECONDS, false);
            this.expiryReaperRunnable.start();
        }
    }

    @Override
    public synchronized void startAddressQueueScanner() {
        this.reapAddresses(true);
        if (this.addressQueueReaperPeriod > 0L) {
            if (this.addressQueueReaperRunnable != null) {
                this.addressQueueReaperRunnable.stop();
            }
            this.addressQueueReaperRunnable = new AddressQueueReaper(this.server.getScheduledPool(), (Executor)this.server.getExecutorFactory().getExecutor(), this.addressQueueReaperPeriod, TimeUnit.MILLISECONDS, false);
            this.addressQueueReaperRunnable.start();
        }
    }

    private Message createQueueInfoMessage(NotificationType type, SimpleString queueName) {
        CoreMessage message = new CoreMessage().initBuffer(50).setMessageID(this.storageManager.generateID());
        message.setAddress(queueName);
        message.putStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE, SimpleString.of((String)type.toString()));
        long timestamp = System.currentTimeMillis();
        message.putLongProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP, timestamp);
        message.setTimestamp(timestamp);
        return message;
    }

    private static boolean queueWasUsed(Queue queue, AddressSettings settings) {
        return queue.getMessagesExpired() > 0L || queue.getMessagesAcknowledged() > 0L || queue.getMessagesKilled() > 0L || queue.getConsumerRemovedTimestamp() != -1L || settings.getAutoDeleteQueuesSkipUsageCheck();
    }

    void reapAddresses(boolean initialCheck) {
        this.getLocalQueues().forEach(queue -> {
            AddressSettings settings = this.addressSettingsRepository.getMatch(queue.getAddress().toString());
            if (!queue.isInternalQueue() && queue.isAutoDelete() && QueueManagerImpl.consumerCountCheck(queue) && (initialCheck || QueueManagerImpl.delayCheck(queue, settings)) && QueueManagerImpl.messageCountCheck(queue) && (initialCheck || PostOfficeImpl.queueWasUsed(queue, settings))) {
                boolean validInitialCheck;
                PagingStore queuePagingStore = queue.getPagingStore();
                boolean isPaging = queuePagingStore != null && queuePagingStore.isPaging();
                boolean bl = validInitialCheck = initialCheck && queue.getMessageCount() == 0L && !isPaging;
                if (validInitialCheck || queue.isSwept()) {
                    if (logger.isDebugEnabled()) {
                        if (initialCheck) {
                            logger.debug("Removing queue {} during the reload check", (Object)queue.getName());
                        } else {
                            logger.debug("Removing queue {} after it being swept twice on reaping process", (Object)queue.getName());
                        }
                    }
                    QueueManagerImpl.performAutoDeleteQueue(this.server, queue);
                } else {
                    queue.setSwept(true);
                }
            } else {
                queue.setSwept(false);
            }
        });
        Set<SimpleString> addresses = this.addressManager.getAddresses();
        for (SimpleString address : addresses) {
            AddressInfo addressInfo = this.getAddressInfo(address);
            AddressSettings settings = this.addressSettingsRepository.getMatch(address.toString());
            try {
                if (this.addressManager.checkAutoRemoveAddress(addressInfo, settings, initialCheck)) {
                    if (initialCheck || addressInfo.isSwept()) {
                        this.server.autoRemoveAddressInfo(address, null);
                        continue;
                    }
                    logger.debug("Sweeping address {}", (Object)address);
                    addressInfo.setSwept(true);
                    continue;
                }
                if (addressInfo == null) continue;
                addressInfo.setSwept(false);
            }
            catch (ActiveMQShutdownException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                if (e instanceof ActiveMQAddressDoesNotExistException && this.getAddressInfo(address) == null) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    continue;
                }
                ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedDestination("address", address, e);
            }
        }
    }

    private Stream<Queue> getLocalQueues() {
        return this.addressManager.getBindings().filter(binding -> binding.getType() == BindingType.LOCAL_QUEUE).map(binding -> (Queue)binding.getBindable());
    }

    @Override
    public Bindings createBindings(SimpleString address) {
        GroupingHandler groupingHandler = this.server.getGroupingHandler();
        BindingsImpl bindings = new BindingsImpl(CompositeAddress.extractAddressName((SimpleString)address), groupingHandler, this.storageManager);
        if (groupingHandler != null) {
            groupingHandler.addListener(bindings);
        }
        return bindings;
    }

    @Override
    public AddressManager getAddressManager() {
        return this.addressManager;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    private final class ExpiryReaper
    extends ActiveMQScheduledComponent {
        private Iterator<Queue> iterator;
        private Queue currentQueue;

        ExpiryReaper(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, onDemand);
        }

        public void run() {
            if (this.iterator != null) {
                logger.debug("A previous reaping call has not finished yet, and it is currently working on {}", (Object)this.currentQueue);
                return;
            }
            this.iterator = IterableStream.iterableOf(PostOfficeImpl.this.getLocalQueues()).iterator();
            this.moveNext();
        }

        private void done() {
            this.executor.execute(this::moveNext);
        }

        private void moveNext() {
            if (!this.iterator.hasNext() || !this.isStarted()) {
                this.iterator = null;
                this.currentQueue = null;
                return;
            }
            this.currentQueue = this.iterator.next();
            if (this.currentQueue == null) {
                logger.debug("iterator.next returned null on ExpiryReaper, giving up iteration");
                this.iterator = null;
            } else {
                this.currentQueue.expireReferences(this::done);
            }
        }
    }

    private final class AddressQueueReaper
    extends ActiveMQScheduledComponent {
        AddressQueueReaper(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, onDemand);
        }

        public void run() {
            PostOfficeImpl.this.reapAddresses(false);
        }
    }

    private static enum DuplicateCheckResult {
        DuplicateNotStartedTX,
        NoDuplicateStartedTX,
        NoDuplicateNotStartedTX;

    }

    public static final class AddOperation
    implements TransactionOperation {
        private final List<MessageReference> refs;

        AddOperation(List<MessageReference> refs) {
            this.refs = refs;
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (MessageReference ref : this.refs) {
                if (ref.isAlreadyAcked()) continue;
                ref.getQueue().addTail(ref, false);
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
            for (MessageReference ref : this.refs) {
                if (!ref.isAlreadyAcked()) continue;
                ref.getQueue().referenceHandled(ref);
                ref.getQueue().incrementMesssagesAdded();
            }
        }

        @Override
        public void afterRollback(Transaction tx) {
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
            for (MessageReference ref : this.refs) {
                ref.getQueue().refDown(ref);
                Message message = ref.getMessage();
                if (!message.isDurable() || !ref.getQueue().isDurable()) continue;
                ref.getQueue().durableDown(message);
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return this.refs;
        }

        @Override
        public List<MessageReference> getListOnConsumer(long consumerID) {
            return Collections.emptyList();
        }
    }

    private static class PageDelivery
    extends TransactionOperationAbstract {
        private final Set<Queue> queues = new HashSet<Queue>();

        private PageDelivery() {
        }

        public void addQueues(List<Queue> queueList) {
            this.queues.addAll(queueList);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Queue queue : this.queues) {
                queue.deliverAsync();
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }
    }
}

