/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetCacheEntry;
import oracle.jdbc.driver.ResultSetCacheEntryKey;
import oracle.jdbc.driver.T4CTTIOqcsta;
import oracle.jdbc.driver.T4CTTIkscn;
import oracle.jdbc.driver.T4CTTIqcinv;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.util.RepConversion;

final class ResultSetCache
implements oracle.jdbc.internal.ResultSetCache,
Monitor.WaitableMonitor {
    static final int COMPILE_KEY_SIZE = 16;
    static final int RUNTIME_KEY_SIZE = 16;
    private static final int CACHE_ID_SIZE = 16;
    private static final long STAT_SEND_INTERVAL = 30000L;
    private final byte[] cacheId = new byte[16];
    private final byte[] cacheIdAsNibbles = new byte[32];
    private boolean isCacheIdAsNibblesReady = false;
    private final long cacheLagInMillis;
    private long nextPingTime = 0L;
    private AtomicLong invalidationCount = new AtomicLong(0L);
    private AtomicLong invalidatedQueryCount = new AtomicLong(0L);
    private AtomicLong validQueriesPurged = new AtomicLong(0L);
    private AtomicLong invalidatedBeforeCompletion = new AtomicLong(0L);
    private AtomicInteger cacheHits = new AtomicInteger(0);
    private long lastStatSentAt;
    private T4CTTIOqcsta oqcsta;
    private AtomicBoolean needToSendStats = new AtomicBoolean(false);
    private long registrationId = -1L;
    private ResultSetCacheState state = ResultSetCacheState.INIT;
    private WeakHashMap<OracleConnection, String> cacheRefs = null;
    private static final String DUMMY_VAL = "xyzzy";
    private long visibleSCN;
    private final CacheStorage cacheStorage;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
    private final Condition monitorCondition = this.newMonitorCondition();

    ResultSetCache(long cacheMaxSize, int cacheLag) {
        assert (cacheMaxSize > 0L);
        assert (cacheLag >= 0);
        new Random().nextBytes(this.cacheId);
        this.cacheStorage = new CacheStorage(cacheMaxSize);
        this.cacheLagInMillis = cacheLag;
    }

    void setState(ResultSetCacheState state) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (state == this.state) {
                return;
            }
            this.state = state;
            if (state == ResultSetCacheState.STARTED) {
                this.monitorNotifyAll();
            }
        }
    }

    ResultSetCacheState getState() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            ResultSetCacheState resultSetCacheState = this.state;
            return resultSetCacheState;
        }
    }

    byte[] getCacheId() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] byArray = this.cacheId;
            return byArray;
        }
    }

    byte[] getCacheIdAsNibbles() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (!this.isCacheIdAsNibblesReady) {
                RepConversion.bArray2Nibbles(this.cacheId, this.cacheIdAsNibbles);
                this.isCacheIdAsNibblesReady = true;
            }
            byte[] byArray = this.cacheIdAsNibbles;
            return byArray;
        }
    }

    long getRegistrationId() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            long l = this.registrationId;
            return l;
        }
    }

    void setRegistrationId(long registrationId) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.registrationId = registrationId;
        }
    }

    void setOQCSTA(T4CTTIOqcsta value) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.oqcsta = value;
        }
    }

    T4CTTIOqcsta getOQCSTA() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            T4CTTIOqcsta t4CTTIOqcsta = this.oqcsta;
            return t4CTTIOqcsta;
        }
    }

    void setVisibleSCN(long visibleSCN) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.visibleSCN = visibleSCN;
            this.nextPingTime = System.currentTimeMillis() + this.cacheLagInMillis;
        }
    }

    long getVisibleSCN() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            long l = this.visibleSCN;
            return l;
        }
    }

    void processCommittedInvalidation(T4CTTIqcinv invalidation) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            long queryId = invalidation.kpdqcqid;
            if (queryId == 0L) {
                return;
            }
            this.invalidationCount.incrementAndGet();
            long invalidationScn = invalidation.kpdqcscn.getSCN();
            if (!T4CTTIkscn.isLessThanUnsigned(invalidationScn, this.visibleSCN)) {
                int noOfEntriesInvalidated = this.cacheStorage.removeResultsetCacheEntries(queryId);
                this.invalidatedQueryCount.addAndGet(noOfEntriesInvalidated);
            }
            this.needToSendStats.set(true);
        }
    }

    ResultSetCacheEntry getResultSetCacheEntry(OracleStatement stmt) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            ResultSetCacheEntry value;
            long queryId = stmt.getQueryId();
            ArrayList<Long> localInvalidations = stmt.connection.getResultSetCacheLocalInvalidations();
            if (queryId == 0L || localInvalidations.contains(queryId)) {
                ResultSetCacheEntry resultSetCacheEntry = null;
                return resultSetCacheEntry;
            }
            byte[] compileKey = stmt.getCompileKey();
            if (compileKey == null || compileKey.length == 0) {
                ResultSetCacheEntry resultSetCacheEntry = null;
                return resultSetCacheEntry;
            }
            byte[] runtimeKey = stmt.getRuntimeKey();
            if (runtimeKey == null) {
                ResultSetCacheEntry resultSetCacheEntry = null;
                return resultSetCacheEntry;
            }
            ResultSetCacheEntryKey key = new ResultSetCacheEntryKey(compileKey, runtimeKey);
            if (System.currentTimeMillis() > this.nextPingTime) {
                stmt.connection.pingDatabase();
            }
            if ((value = this.cacheStorage.getResultsetCacheEntry(key, queryId, stmt.connection.userName)) != null && value.userName.equals(stmt.connection.userName)) {
                if (value.isValid()) {
                    this.cacheHits.incrementAndGet();
                    this.needToSendStats.set(true);
                    if (this.lastStatSentAt == 0L) {
                        this.lastStatSentAt = System.currentTimeMillis();
                    }
                }
                ResultSetCacheEntry resultSetCacheEntry = value;
                return resultSetCacheEntry;
            }
            ResultSetCacheEntry resultSetCacheEntry = null;
            return resultSetCacheEntry;
        }
    }

    boolean registerConnection(OracleConnection connection) {
        Monitor.CloseableLock lock = this.acquireCloseableLock();
        try {
            if (this.cacheRefs == null) {
                this.cacheRefs = new WeakHashMap();
            }
            if (this.state == ResultSetCacheState.INIT) {
                this.setState(ResultSetCacheState.STARTING);
                this.cacheRefs.put(connection, DUMMY_VAL);
            } else if (this.state == ResultSetCacheState.STARTING) {
                try {
                    this.monitorWait();
                    this.cacheRefs.put(connection, DUMMY_VAL);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    boolean bl = false;
                    if (lock != null) {
                        lock.close();
                    }
                    return bl;
                }
            } else if (this.state == ResultSetCacheState.CLOSED || this.state == ResultSetCacheState.STARTUP_FAILED) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    boolean deregisterConnection(OracleConnection conn) {
        boolean retVal = false;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.cacheRefs != null && this.cacheRefs.remove(conn) != null && this.cacheRefs.isEmpty()) {
                retVal = true;
            }
        }
        return retVal;
    }

    boolean needToSendStatsResetIfTrue() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (System.currentTimeMillis() - this.lastStatSentAt > 30000L && this.needToSendStats.weakCompareAndSet(true, false)) {
                this.lastStatSentAt = System.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int getCacheLag() {
        return (int)this.cacheLagInMillis;
    }

    @Override
    public long getInvalidationCount() {
        return this.invalidationCount.get();
    }

    @Override
    public long getInvalidatedQueryCount() {
        return this.invalidatedQueryCount.get();
    }

    @Override
    public long getInvalidatedBeforeCompletion() {
        return this.invalidatedBeforeCompletion.get();
    }

    @Override
    public long getValidQueriesPurged() {
        return this.validQueriesPurged.get();
    }

    @Override
    public int getCacheHits() {
        return this.cacheHits.get();
    }

    void updateCurrentCacheSize(long changeInSize) {
        this.cacheStorage.incrementCacheSize(changeInSize);
    }

    @Override
    public long getCurrentCacheSize() {
        return this.cacheStorage.getCacheSize();
    }

    @Override
    public long getMaxCacheSize() {
        return this.cacheStorage.maxSize();
    }

    @Override
    public long getNumberOfCacheEntries() {
        return this.cacheStorage.size();
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public final Condition getMonitorCondition() {
        return this.monitorCondition;
    }

    static enum ResultSetCacheState {
        INIT,
        STARTING,
        STARTED,
        CLOSED,
        STARTUP_FAILED;

    }

    private static class CacheStorage
    extends LinkedHashMap<ResultSetCacheEntryKey, ResultSetCacheEntry>
    implements Monitor {
        private static final int INITIAL_SIZE = 10;
        private static final long serialVersionUID = 1L;
        private long currentCacheSize;
        private final long maxCacheSize;
        private final Map<Long, LinkedList<ResultSetCacheEntry>> queryIdIndex;
        private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

        CacheStorage(long maxCacheSize) {
            super(10);
            this.queryIdIndex = new HashMap<Long, LinkedList<ResultSetCacheEntry>>(10);
            this.maxCacheSize = maxCacheSize;
        }

        ResultSetCacheEntry getResultsetCacheEntry(ResultSetCacheEntryKey key, long queryId, String userName) {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                ResultSetCacheEntry entry = (ResultSetCacheEntry)super.get(key);
                if (entry == null) {
                    entry = new ResultSetCacheEntry(key, queryId);
                    entry.userName = userName;
                    super.put(key, entry);
                    this.currentCacheSize += entry.getSizeInMemory();
                    this.queryIdIndex.computeIfAbsent(queryId, k -> new LinkedList()).add(entry);
                }
                ResultSetCacheEntry resultSetCacheEntry = entry;
                return resultSetCacheEntry;
            }
        }

        int removeResultsetCacheEntries(Long queryId) {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                int invalidateCount = 0;
                LinkedList<ResultSetCacheEntry> cacheEntriesList = this.queryIdIndex.remove(queryId);
                if (cacheEntriesList != null) {
                    for (ResultSetCacheEntry cacheEntry : cacheEntriesList) {
                        if (this.remove(cacheEntry.getResultSetCacheEntryKey()) != null) {
                            this.currentCacheSize -= cacheEntry.getSizeInMemory();
                        }
                        cacheEntry.invalidate();
                        ++invalidateCount;
                    }
                }
                int n = invalidateCount;
                return n;
            }
        }

        void incrementCacheSize(long changeInSize) {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                this.currentCacheSize += changeInSize;
            }
        }

        long getCacheSize() {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                long l = this.currentCacheSize;
                return l;
            }
        }

        long maxSize() {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                long l = this.maxCacheSize;
                return l;
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<ResultSetCacheEntryKey, ResultSetCacheEntry> eldest) {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                boolean hasExceededMaxSize;
                boolean bl = hasExceededMaxSize = this.currentCacheSize >= this.maxCacheSize;
                if (hasExceededMaxSize) {
                    ResultSetCacheEntry eldestValue = eldest.getValue();
                    this.currentCacheSize = -1L * eldestValue.getSizeInMemory();
                    LinkedList<ResultSetCacheEntry> entries = this.queryIdIndex.get(eldestValue.getQueryId());
                    entries.remove(eldestValue);
                }
                boolean bl2 = hasExceededMaxSize;
                return bl2;
            }
        }

        @Override
        public final Monitor.CloseableLock getMonitorLock() {
            return this.monitorLock;
        }
    }
}

