/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

public final class ArrayRingBuffer<T> {
    private static final Object[] EMPTY = new Object[0];
    private long tailSequence;
    private long headSequence;
    private T[] elements;

    public ArrayRingBuffer() {
        this(0, 0L);
    }

    public ArrayRingBuffer(int initialSize) {
        this(initialSize, 0L);
    }

    public ArrayRingBuffer(int initialSize, long headSequence) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("initialSize must be greater than 0");
        }
        if (headSequence < 0L) {
            throw new IllegalArgumentException("headSequence cannot be negative");
        }
        this.elements = ArrayRingBuffer.allocate(initialSize == 0 ? 0 : ArrayRingBuffer.findNextPositivePowerOfTwo(initialSize));
        this.headSequence = headSequence;
        this.tailSequence = headSequence;
    }

    public int size() {
        return this.size(true);
    }

    public int size(boolean count_null_elements) {
        if (count_null_elements) {
            return (int)(this.tailSequence - this.headSequence);
        }
        int size = 0;
        T[] els = this.elements;
        for (long i = this.headSequence; i < this.tailSequence; ++i) {
            T e = els[this.bufferOffset(i)];
            if (e == null) continue;
            ++size;
        }
        return size;
    }

    public long getTailSequence() {
        return this.tailSequence;
    }

    public long getHeadSequence() {
        return this.headSequence;
    }

    public void forEach(ObjLongConsumer<? super T> consumer) {
        int size = this.size();
        T[] elements = this.elements;
        long sequence = this.headSequence;
        int i = 0;
        while (i < size) {
            T e = elements[this.bufferOffset(sequence)];
            if (e != null) {
                consumer.accept(e, sequence);
            }
            ++i;
            ++sequence;
        }
    }

    public int availableCapacityWithoutResizing() {
        return this.elements.length - this.size();
    }

    private void validateIndex(long index) {
        this.validateIndex(index, true);
    }

    private void validateIndex(long index, boolean validateTail) {
        if (index < 0L) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        if (validateTail && index >= this.tailSequence) {
            throw new IllegalArgumentException("index cannot be greater then " + this.tailSequence);
        }
        if (index < this.headSequence) {
            throw new IllegalArgumentException("index cannot be less then " + this.headSequence);
        }
    }

    public boolean contains(long index) {
        return index < this.tailSequence && index >= this.headSequence;
    }

    public void dropTailToHead() {
        this.dropTailTo(this.getHeadSequence());
    }

    public void clear() {
        this.dropHeadUntil(this.getTailSequence());
    }

    public int dropTailTo(long indexInclusive) {
        int clearFrom;
        if (this.size() == 0 || !this.contains(indexInclusive)) {
            return 0;
        }
        int fromIncluded = this.bufferOffset(indexInclusive);
        int toExcluded = this.bufferOffset(this.tailSequence);
        Object[] elements = this.elements;
        int removed = 0;
        if (toExcluded <= fromIncluded) {
            Arrays.fill(elements, fromIncluded, elements.length, null);
            removed += elements.length - fromIncluded;
            clearFrom = 0;
        } else {
            clearFrom = fromIncluded;
        }
        Arrays.fill(elements, clearFrom, toExcluded, null);
        this.tailSequence = indexInclusive;
        return removed += toExcluded - clearFrom;
    }

    public int dropHeadUntil(long indexExclusive) {
        int clearFrom;
        long indexInclusive = indexExclusive - 1L;
        if (this.size() == 0 || !this.contains(indexInclusive)) {
            return 0;
        }
        int fromInclusive = this.bufferOffset(this.headSequence);
        int toExclusive = this.bufferOffset(indexExclusive);
        Object[] elements = this.elements;
        int removed = 0;
        if (toExclusive <= fromInclusive) {
            Arrays.fill(elements, fromInclusive, elements.length, null);
            removed += elements.length - fromInclusive;
            clearFrom = 0;
        } else {
            clearFrom = fromInclusive;
        }
        Arrays.fill(elements, clearFrom, toExclusive, null);
        this.headSequence = ArrayRingBuffer.catchUpHeadPointer(elements, indexExclusive, this.tailSequence);
        return removed += toExclusive - clearFrom;
    }

    private int bufferOffset(long index) {
        return ArrayRingBuffer.bufferOffset(index, this.elements.length);
    }

    private static int bufferOffset(long index, int elementsLength) {
        return (int)(index & (long)(elementsLength - 1));
    }

    public T get(long index) {
        this.validateIndex(index);
        return this.elements[this.bufferOffset(index)];
    }

    private T replace(long index, T e) {
        int offset = this.bufferOffset(index);
        T oldValue = this.elements[offset];
        this.elements[offset] = e;
        return oldValue;
    }

    public T set(long index, T e) {
        Objects.requireNonNull(e);
        this.validateIndex(index, false);
        if (index < this.tailSequence) {
            return this.replace(index, e);
        }
        int requiredCapacity = (int)(index - this.tailSequence) + 1;
        int missingCapacity = requiredCapacity - this.availableCapacityWithoutResizing();
        if (missingCapacity > 0) {
            this.growCapacity(missingCapacity);
        }
        T[] elements = this.elements;
        elements[this.bufferOffset((long)index)] = e;
        if (index >= this.tailSequence) {
            if (this.headSequence == this.tailSequence) {
                this.headSequence = index;
            }
            this.tailSequence = index + 1L;
        }
        return null;
    }

    public void add(T e) {
        Objects.requireNonNull(e);
        if (this.availableCapacityWithoutResizing() == 0) {
            this.growCapacity(1);
        }
        long index = this.tailSequence;
        this.elements[this.bufferOffset((long)index)] = e;
        this.tailSequence = index + 1L;
    }

    public boolean isEmpty() {
        return this.tailSequence == this.headSequence;
    }

    public T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.headSequence);
    }

    public T poll() {
        if (this.isEmpty()) {
            return null;
        }
        T[] elements = this.elements;
        long headSequence = this.headSequence;
        int offset = this.bufferOffset(headSequence);
        T e = elements[offset];
        elements[offset] = null;
        this.headSequence = ArrayRingBuffer.catchUpHeadPointer(elements, ++headSequence, this.tailSequence);
        return e;
    }

    public T remove(long index) {
        if (this.isEmpty() || !this.contains(index)) {
            return null;
        }
        T[] elements = this.elements;
        int offset = this.bufferOffset(index);
        T e = elements[offset];
        elements[offset] = null;
        long headSequence = this.headSequence;
        if (index == headSequence) {
            this.headSequence = ArrayRingBuffer.catchUpHeadPointer(elements, ++headSequence, this.tailSequence);
        }
        return e;
    }

    private static <T> long catchUpHeadPointer(T[] elements, long headSequence, long tailSequence) {
        int innerOffset;
        while (headSequence < tailSequence && elements[innerOffset = ArrayRingBuffer.bufferOffset(headSequence, elements.length)] == null) {
            ++headSequence;
        }
        return headSequence;
    }

    public String toString() {
        return String.format("[%s..%s] (%s elements)", this.headSequence, this.tailSequence, this.size(false));
    }

    private void growCapacity(int delta) {
        int bytesToCopy;
        long headSequence;
        assert (delta > 0);
        T[] oldElements = this.elements;
        int newCapacity = ArrayRingBuffer.findNextPositivePowerOfTwo(oldElements.length + delta);
        if (newCapacity < 0) {
            throw new OutOfMemoryError();
        }
        T[] newElements = ArrayRingBuffer.allocate(newCapacity);
        int size = this.size();
        long oldIndex = headSequence = this.headSequence;
        long newIndex = headSequence;
        for (int remaining = size; remaining > 0; remaining -= bytesToCopy) {
            int fromOldIndex = ArrayRingBuffer.bufferOffset(oldIndex, oldElements.length);
            int fromNewIndex = ArrayRingBuffer.bufferOffset(newIndex, newCapacity);
            int toOldEnd = oldElements.length - fromOldIndex;
            int toNewEnd = newElements.length - fromNewIndex;
            bytesToCopy = Math.min(Math.min(remaining, toOldEnd), toNewEnd);
            System.arraycopy(oldElements, fromOldIndex, newElements, fromNewIndex, bytesToCopy);
            oldIndex += (long)bytesToCopy;
            newIndex += (long)bytesToCopy;
        }
        this.elements = newElements;
    }

    private static int findNextPositivePowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    private static <T> T[] allocate(int capacity) {
        return capacity == 0 ? EMPTY : new Object[capacity];
    }
}

