/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.service;

import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.BinaryServiceInstallerFactory;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceInstaller;

public class FilteredBinaryServiceInstallerProvider
implements BiFunction<CapabilityServiceSupport, BinaryServiceConfiguration, Iterable<ServiceInstaller>> {
    private final Set<? extends BinaryServiceDescriptor<?>> descriptors;

    public FilteredBinaryServiceInstallerProvider(Set<? extends BinaryServiceDescriptor<?>> descriptors) {
        this.descriptors = descriptors;
    }

    @Override
    public Iterable<ServiceInstaller> apply(CapabilityServiceSupport support, BinaryServiceConfiguration configuration) {
        Class<BinaryServiceInstallerFactory> factoryClass = BinaryServiceInstallerFactory.class;
        return ServiceLoader.load(factoryClass, factoryClass.getClassLoader()).stream().map(ServiceLoader.Provider::get).filter(factory -> this.descriptors.contains(factory.getServiceDescriptor())).map(factory -> (ServiceInstaller)factory.apply(support, configuration)).collect(Collectors.toList());
    }
}

