/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import org.infinispan.api.Experimental;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.mutiny.MutinyCache;
import org.infinispan.api.mutiny.MutinyCaches;
import org.infinispan.client.hotrod.HotRod;
import org.infinispan.client.hotrod.HotRodMutinyCache;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;

@Experimental
final class HotRodMutinyCaches
implements MutinyCaches {
    private final HotRod hotrod;

    HotRodMutinyCaches(HotRod hotrod) {
        this.hotrod = hotrod;
    }

    public <K, V> Uni<MutinyCache<K, V>> get(String name) {
        InternalRemoteCache<K, V> cache = this.getCache(name);
        return Uni.createFrom().item(new HotRodMutinyCache<K, V>(this.hotrod, cache));
    }

    public <K, V> Uni<MutinyCache<K, V>> create(String name, CacheConfiguration cacheConfiguration) {
        this.hotrod.cacheManager.getConfiguration().addRemoteCache(name, builder -> builder.configuration(cacheConfiguration.toString()));
        return this.get(name);
    }

    public <K, V> Uni<MutinyCache<K, V>> create(String name, String template) {
        this.hotrod.cacheManager.getConfiguration().addRemoteCache(name, builder -> builder.templateName(template));
        return this.get(name);
    }

    public Uni<Void> remove(String name) {
        this.hotrod.cacheManager.administration().removeCache(name);
        return Uni.createFrom().voidItem();
    }

    public Multi<String> names() {
        return Multi.createFrom().deferred(() -> Multi.createFrom().iterable(this.hotrod.cacheManager.getCacheNames()));
    }

    public Uni<Void> createTemplate(String name, CacheConfiguration cacheConfiguration) {
        throw new UnsupportedOperationException();
    }

    public Uni<Void> removeTemplate(String name) {
        throw new UnsupportedOperationException();
    }

    public Multi<String> templateNames() {
        throw new UnsupportedOperationException();
    }

    private <K, V> InternalRemoteCache<K, V> getCache(String name) {
        return (InternalRemoteCache)this.hotrod.cacheManager.getCache(name);
    }
}

