/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.jmx;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.common.Assert;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.jmx.JmxMetricMetadata;
import org.wildfly.extension.micrometer.metrics.MetricMetadata;
import org.wildfly.extension.micrometer.metrics.WildFlyMetric;
import org.wildfly.extension.micrometer.registry.WildFlyRegistry;

public class JmxMicrometerCollector {
    public static final String JMX_METRICS_PROPERTIES = "jmx-metrics.properties";
    private final MBeanServer mbs;
    private final WildFlyRegistry registry;

    public JmxMicrometerCollector(WildFlyRegistry registry) {
        this.registry = registry;
        this.mbs = ManagementFactory.getPlatformMBeanServer();
    }

    public void init() throws IOException {
        List<JmxMetricMetadata> configs = this.findMetadata();
        ArrayList<JmxMetricMetadata> expandedConfigs = new ArrayList<JmxMetricMetadata>();
        Iterator<JmxMetricMetadata> iterator = configs.iterator();
        while (iterator.hasNext()) {
            JmxMetricMetadata metadata = iterator.next();
            try {
                String[] split = metadata.getMBean().split("/");
                String query = split[0];
                String attribute = split[1];
                Set<ObjectName> objectNames = this.mbs.queryNames(ObjectName.getInstance(query), null);
                for (ObjectName objectName : objectNames) {
                    ArrayList<MetricMetadata.MetricTag> tags = new ArrayList<MetricMetadata.MetricTag>(metadata.getTagsToFill().size());
                    for (String key : metadata.getTagsToFill()) {
                        String value = objectName.getKeyProperty(key);
                        tags.add(new MetricMetadata.MetricTag(key, value));
                    }
                    expandedConfigs.add(new JmxMetricMetadata(metadata.getMetricName(), metadata.getDescription(), metadata.getMeasurementUnit(), metadata.getType(), objectName.getCanonicalName() + "/" + attribute, Collections.emptyList(), tags));
                }
                iterator.remove();
            }
            catch (MalformedObjectNameException e) {
                MicrometerExtensionLogger.MICROMETER_LOGGER.malformedName(e);
            }
        }
        configs.addAll(expandedConfigs);
        for (JmxMetricMetadata config : configs) {
            this.register(config);
        }
    }

    void register(final JmxMetricMetadata metadata) {
        WildFlyMetric metric = new WildFlyMetric(){

            @Override
            public OptionalDouble getValue() {
                try {
                    return JmxMicrometerCollector.getValueFromMBean(JmxMicrometerCollector.this.mbs, metadata.getMBean());
                }
                catch (Exception e) {
                    return OptionalDouble.empty();
                }
            }
        };
        this.registry.addMeter(metric, metadata);
    }

    private List<JmxMetricMetadata> findMetadata() throws IOException {
        try (InputStream propertiesResource = this.getResource();){
            if (propertiesResource == null) {
                List<JmxMetricMetadata> list = Collections.emptyList();
                return list;
            }
            List<JmxMetricMetadata> list = this.loadMetadataFromProperties(propertiesResource);
            return list;
        }
    }

    List<JmxMetricMetadata> loadMetadataFromProperties(InputStream propertiesResource) throws IOException {
        Properties props = new Properties();
        props.load(propertiesResource);
        Map<String, List<MetricProperty>> parsedMetrics = props.entrySet().stream().map(MetricProperty::new).collect(Collectors.groupingBy(MetricProperty::getMetricName));
        return parsedMetrics.entrySet().stream().map(this::metadataOf).sorted(Comparator.comparing(JmxMetricMetadata::getMetricName)).collect(Collectors.toList());
    }

    private InputStream getResource() {
        InputStream is = this.getClass().getResourceAsStream(JMX_METRICS_PROPERTIES);
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(JMX_METRICS_PROPERTIES);
        }
        return is;
    }

    private JmxMetricMetadata metadataOf(Map.Entry<String, List<MetricProperty>> metadataEntry) {
        String name = metadataEntry.getKey();
        HashMap entryProperties = new HashMap();
        metadataEntry.getValue().forEach(prop -> entryProperties.put(prop.propertyKey, prop.propertyValue));
        ArrayList<String> tagsToFill = new ArrayList();
        if (entryProperties.containsKey("tagsToFill")) {
            tagsToFill = Arrays.asList(((String)entryProperties.get("tagsToFill")).split(","));
        }
        MeasurementUnit unit = entryProperties.get("unit") == null ? MeasurementUnit.NONE : MeasurementUnit.valueOf((String)((String)entryProperties.get("unit")).toUpperCase(Locale.ENGLISH));
        return new JmxMetricMetadata(name, (String)entryProperties.get("description"), unit, MetricMetadata.Type.valueOf(((String)entryProperties.get("type")).toUpperCase(Locale.ENGLISH)), (String)entryProperties.get("mbean"), tagsToFill, Collections.emptyList());
    }

    private static OptionalDouble getValueFromMBean(MBeanServer mbs, String mbeanExpression) {
        Assert.checkNotNullParam((String)"mbs", (Object)mbs);
        Assert.checkNotNullParam((String)"mbeanExpression", (Object)mbeanExpression);
        if (!mbeanExpression.contains("/")) {
            throw new IllegalArgumentException(mbeanExpression);
        }
        int slashIndex = mbeanExpression.indexOf(47);
        String mbean = mbeanExpression.substring(0, slashIndex);
        String attName = mbeanExpression.substring(slashIndex + 1);
        String subItem = null;
        if (attName.contains("#")) {
            int hashIndex = attName.indexOf(35);
            subItem = attName.substring(hashIndex + 1);
            attName = attName.substring(0, hashIndex);
        }
        try {
            ObjectName objectName = new ObjectName(mbean);
            Object attribute = mbs.getAttribute(objectName, attName);
            if (attribute instanceof Number) {
                Number num = (Number)attribute;
                return OptionalDouble.of(num.doubleValue());
            }
            if (attribute instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)attribute;
                Number num = (Number)compositeData.get(subItem);
                return OptionalDouble.of(num.doubleValue());
            }
            return OptionalDouble.empty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class MetricProperty {
        String metricName;
        String propertyKey;
        String propertyValue;

        MetricProperty(Map.Entry<Object, Object> keyValue) {
            String key = (String)keyValue.getKey();
            int propertyIdEnd = key.lastIndexOf(46);
            this.metricName = key.substring(0, propertyIdEnd);
            this.propertyKey = key.substring(propertyIdEnd + 1);
            this.propertyValue = (String)keyValue.getValue();
        }

        String getMetricName() {
            return this.metricName;
        }
    }
}

