/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDistanceToFieldProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneGeoPointFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneGeoPointSpatialWithinBoundingBoxPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneGeoPointSpatialWithinCirclePredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneGeoPointSpatialWithinPolygonPredicate;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneGeoPointDistanceSort;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.spi.DefaultStringConverters;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;
import org.hibernate.search.engine.spatial.GeoPoint;

class LuceneGeoPointIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneGeoPointIndexFieldTypeOptionsStep, GeoPoint> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneGeoPointIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, GeoPoint.class, DefaultStringConverters.GEO_POINT);
    }

    public LuceneGeoPointIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexValueFieldType<GeoPoint> toIndexFieldType() {
        boolean resolvedSortable = LuceneGeoPointIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneGeoPointIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneGeoPointIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        boolean resolvedAggregable = LuceneGeoPointIndexFieldTypeOptionsStep.resolveDefault(this.aggregable);
        Indexing indexing = resolvedSearchable ? Indexing.ENABLED : Indexing.DISABLED;
        DocValues docValues = resolvedSortable || resolvedProjectable ? DocValues.ENABLED : DocValues.DISABLED;
        Storage storage = resolvedProjectable ? Storage.ENABLED : Storage.DISABLED;
        LuceneGeoPointFieldCodec codec = new LuceneGeoPointFieldCodec(indexing, docValues, storage, (GeoPoint)this.indexNullAsValue);
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, DocValues.ENABLED.equals((Object)docValues) ? new LuceneExistsPredicate.DocValuesOrNormsBasedFactory() : new LuceneExistsPredicate.DefaultFactory());
            this.builder.queryElementFactory(PredicateTypeKeys.SPATIAL_WITHIN_CIRCLE, new LuceneGeoPointSpatialWithinCirclePredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.SPATIAL_WITHIN_POLYGON, new LuceneGeoPointSpatialWithinPolygonPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.SPATIAL_WITHIN_BOUNDING_BOX, new LuceneGeoPointSpatialWithinBoundingBoxPredicate.Factory());
        }
        if (resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.DISTANCE, new LuceneGeoPointDistanceSort.Factory());
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new LuceneFieldProjection.Factory<GeoPoint, byte[]>(codec));
            this.builder.queryElementFactory(ProjectionTypeKeys.DISTANCE, new LuceneDistanceToFieldProjection.Factory(codec));
        }
        if (resolvedAggregable) {
            this.builder.aggregable(true);
        }
        return this.builder.build();
    }

    @Override
    protected LuceneGeoPointIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

