/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpPresettledReceiverTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testPresettledReceiverAndNonPresettledReceiverOnSameQueue() throws Exception {
        int MSG_COUNT = 2;
        this.sendMessages(this.getQueueName(), 2);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName(), null, false, true);
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)2L, (long)queueView.getMessageCount());
        receiver1.flow(1);
        receiver2.flow(1);
        AmqpMessage message1 = receiver1.receive(5L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver2.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message1);
        Assertions.assertNotNull((Object)message2);
        Assertions.assertTrue((boolean)message1.getWrappedDelivery().remotelySettled());
        message2.accept();
        receiver1.close();
        receiver2.close();
        logger.debug("Message Count after all consumed: {}", (Object)queueView.getMessageCount());
        AmqpReceiver receiver3 = session.createReceiver(this.getQueueName());
        receiver3.flow(1);
        AmqpMessage received = receiver3.receive(5L, TimeUnit.SECONDS);
        if (received != null) {
            logger.debug("Message read: {}", (Object)received.getMessageId());
        }
        Assertions.assertNull((Object)received);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPresettledReceiverReadsAllMessages() throws Exception {
        int MSG_COUNT = 100;
        this.sendMessages(this.getQueueName(), 100);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), null, false, true);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)100L, (long)queueView.getMessageCount());
        receiver.flow(100);
        for (int i = 0; i < 100; ++i) {
            Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        }
        receiver.close();
        logger.debug("Message Count after all consumed: {}", (Object)queueView.getMessageCount());
        receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        if (received != null) {
            logger.debug("Message read: {}", (Object)received.getMessageId());
        }
        Assertions.assertNull((Object)received);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPresettledReceiverReadsAllMessagesInWhenReadInBatches() throws Exception {
        int j;
        int MSG_COUNT = 100;
        this.sendMessages(this.getQueueName(), 100);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), null, false, true);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)100L, (long)queueView.getMessageCount());
        receiver.flow(20);
        for (j = 0; j < 10; ++j) {
            Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        }
        receiver.flow(10);
        for (j = 0; j < 20; ++j) {
            Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        }
        receiver.flow(70);
        for (j = 0; j < 70; ++j) {
            Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        }
        receiver.close();
        logger.debug("Message Count after all consumed: {}", (Object)queueView.getMessageCount());
        receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        if (received != null) {
            logger.debug("Message read: {}", (Object)received.getMessageId());
        }
        Assertions.assertNull((Object)received);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPresettledReceiverWithinBoundsOfActiveTXWithCommit() throws Exception {
        this.doTestPresettledReceiverWithinBoundsOfActiveTX(true);
    }

    @Test
    @Timeout(value=60L)
    public void testPresettledReceiverWithinBoundsOfActiveTXWithRollback() throws Exception {
        this.doTestPresettledReceiverWithinBoundsOfActiveTX(false);
    }

    private void doTestPresettledReceiverWithinBoundsOfActiveTX(boolean commit) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), null, false, true);
        session.begin();
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Assertions.assertTrue((boolean)received.getWrappedDelivery().remotelySettled());
        if (commit) {
            session.commit();
        } else {
            session.rollback();
        }
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        sender.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPresettledReceiverWithinBoundsOfActiveTXWithSendAndRollback() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), null, false, true);
        session.begin();
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Assertions.assertTrue((boolean)received.getWrappedDelivery().remotelySettled());
        message = new AmqpMessage();
        message.setText("Test-Message - Rolled Back");
        sender.send(message);
        session.rollback();
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        sender.close();
        connection.close();
    }
}

