/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class PropertyParseOptimizationTest
extends AmqpClientTestSupport {
    private String noDuplicateAcceptor = new String("tcp://localhost:5680");

    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
        server.getConfiguration().addAcceptorConfiguration("noDuplicate", this.noDuplicateAcceptor + "?protocols=AMQP;useEpoll=false;amqpDuplicateDetection=false");
    }

    @Test
    @Timeout(value=60L)
    public void testSendWithPropertiesAndFilter() throws Exception {
        AmqpMessage message;
        int size = 10240;
        AmqpClient client = this.createAmqpClient(new URI(this.noDuplicateAcceptor));
        AmqpConnection connection = client.createConnection();
        this.addConnection(connection);
        connection.connect();
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        LinkedListIterator iterator = queueView.iterator();
        iterator.close();
        Assertions.assertNotNull((Object)queueView);
        Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
        session.begin();
        for (int m = 0; m < 10; ++m) {
            message = new AmqpMessage();
            message.setDurable(true);
            message.setApplicationProperty("odd", m % 2 == 0);
            byte[] bytes = new byte[size];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = 122;
            }
            message.setBytes(bytes);
            sender.send(message);
        }
        session.commit();
        Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
        while (iterator.hasNext()) {
            MessageReference reference = (MessageReference)iterator.next();
            message = (AMQPMessage)reference.getMessage();
            Assertions.assertNull((Object)AMQPMessageBrokerAccessor.getDecodedApplicationProperties((AMQPMessage)message), (String)"Application properties on AMQP Messages should only be parsed over demand");
        }
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "odd=true");
        receiver.flow(10);
        for (int i = 0; i < 5; ++i) {
            AmqpMessage msgReceived = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)msgReceived);
            Data body = (Data)msgReceived.getWrappedMessage().getBody();
            byte[] bodyArray = body.getValue().getArray();
            for (int bI = 0; bI < size; ++bI) {
                Assertions.assertEquals((byte)122, (byte)bodyArray[bI]);
            }
            msgReceived.accept(true);
        }
        receiver.flow(1);
        Assertions.assertNull((Object)receiver.receiveNoWait());
        Wait.assertEquals((long)5L, () -> ((Queue)queueView).getMessageCount());
        receiver.close();
        connection.close();
    }
}

