/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.journal;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AmqpJournalLoadingTest
extends AmqpClientTestSupport {
    @Test
    public void durableMessageDataNotScannedOnRestartTest() throws Exception {
        this.sendMessages(this.getQueueName(), 1, true);
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertTrue((String)"All messages should arrive", () -> queueView.getMessageCount() == 1L);
        this.server.stop();
        this.server.start();
        Queue afterRestartQueueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertTrue((String)"All messages should arrive", () -> afterRestartQueueView.getMessageCount() == 1L);
        ArrayList messageReference = new ArrayList(1);
        afterRestartQueueView.forEach(next -> {
            AMQPMessage message = (AMQPMessage)next.getMessage();
            Assertions.assertEquals((Object)AMQPMessage.MessageDataScanningStatus.RELOAD_PERSISTENCE, (Object)message.getDataScanningStatus());
            Assertions.assertTrue((boolean)message.isDurable());
            Assertions.assertEquals((Object)AMQPMessage.MessageDataScanningStatus.RELOAD_PERSISTENCE, (Object)message.getDataScanningStatus());
            messageReference.add(message);
        });
        Assertions.assertEquals((int)1, (int)messageReference.size());
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)receive);
        Assertions.assertTrue((boolean)receive.isDurable());
        Assertions.assertEquals((long)1L, (long)afterRestartQueueView.getMessageCount());
        Assertions.assertEquals((Object)AMQPMessage.MessageDataScanningStatus.SCANNED, (Object)((AMQPMessage)messageReference.get(0)).getDataScanningStatus());
        receive.accept();
        receiver.close();
        Wait.assertEquals((long)0L, () -> afterRestartQueueView.getMessageCount());
        connection.close();
    }
}

