/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.cli.commands.queue.CreateQueue;
import org.apache.activemq.artemis.cli.commands.queue.DeleteQueue;
import org.apache.activemq.artemis.cli.commands.queue.PurgeQueue;
import org.apache.activemq.artemis.cli.commands.queue.UpdateQueue;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.cli.DummyServerConsumer;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueCommandTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ByteArrayOutputStream output;
    private ByteArrayOutputStream error;

    @Override
    protected void extraServerConfig(ActiveMQServer server) {
        super.extraServerConfig(server);
        server.getConfiguration().setAddressQueueScanPeriod(100L);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.output = new ByteArrayOutputStream(1024);
        this.error = new ByteArrayOutputStream(1024);
    }

    @Test
    public void testCreateCoreQueueShowsErrorWhenAddressDoesNotExists() throws Exception {
        String queueName = "queue1";
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)command, "AMQ229203");
        Assertions.assertFalse((boolean)this.server.queueQuery(SimpleString.of((String)queueName)).isExists());
    }

    @Test
    public void testCreateCoreQueueAutoCreateAddressDefaultAddress() throws Exception {
        String queueName = UUID.randomUUID().toString();
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)command);
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)queueName)));
        Queue queue = this.server.locateQueue(SimpleString.of((String)queueName));
        Assertions.assertEquals((int)-1, (int)queue.getMaxConsumers());
        Assertions.assertFalse((boolean)queue.isPurgeOnNoConsumers());
        Assertions.assertTrue((boolean)this.server.queueQuery(SimpleString.of((String)queueName)).isExists());
    }

    @Test
    public void testCreateCoreQueueAddressExists() throws Exception {
        String queueName = "queue";
        String address = "address";
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setAutoCreateAddress(false);
        command.setMulticast(true);
        command.setAnycast(false);
        command.setAddress(address);
        this.server.addOrUpdateAddressInfo(new AddressInfo(SimpleString.of((String)address), RoutingType.MULTICAST));
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)command);
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)address)));
        Queue queue = this.server.locateQueue(SimpleString.of((String)queueName));
        Assertions.assertEquals((int)-1, (int)queue.getMaxConsumers());
        Assertions.assertFalse((boolean)queue.isPurgeOnNoConsumers());
        Assertions.assertTrue((boolean)this.server.queueQuery(SimpleString.of((String)queueName)).isExists());
    }

    @Test
    public void testCreateCoreQueueWithFilter() throws Exception {
        String queueName = "queue2";
        String filerString = "color='green'";
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)command);
        Queue queue = this.server.locateQueue(SimpleString.of((String)queueName));
        Assertions.assertNotNull((Object)queue);
        Assertions.assertEquals((Object)SimpleString.of((String)filerString), (Object)queue.getFilter().getFilterString());
    }

    @Test
    public void testCreateQueueAlreadyExists() throws Exception {
        String queueName = "queue2";
        String filerString = "color='green'";
        CreateQueue command = new CreateQueue();
        command.setName(queueName);
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        command.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)command, "AMQ229019");
    }

    @Test
    public void testDeleteCoreQueue() throws Exception {
        SimpleString queueName = SimpleString.of((String)"deleteQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)delete);
        Assertions.assertFalse((boolean)this.server.queueQuery(queueName).isExists());
    }

    @Test
    public void testDeleteQueueDoesNotExist() throws Exception {
        SimpleString queueName = SimpleString.of((String)"deleteQueue");
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)delete, "AMQ229017");
        Assertions.assertFalse((boolean)this.server.queueQuery(queueName).isExists());
    }

    @Test
    public void testDeleteQueueWithConsumersFails() throws Exception {
        SimpleString queueName = SimpleString.of((String)"deleteQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        this.server.locateQueue(queueName).addConsumer((Consumer)new DummyServerConsumer());
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)delete, "AMQ229025");
    }

    @Test
    public void testDeleteQueueWithConsumersFailsAndRemoveConsumersTrue() throws Exception {
        SimpleString queueName = SimpleString.of((String)"deleteQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        this.server.locateQueue(queueName).addConsumer((Consumer)new DummyServerConsumer());
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.setRemoveConsumers(true);
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)command);
    }

    @Test
    public void testAutoDeleteAddress() throws Exception {
        SimpleString queueName = SimpleString.of((String)"deleteQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setFilter("color='green'");
        command.setAutoCreateAddress(true);
        command.setMulticast(true);
        command.setAnycast(false);
        command.execute(new ActionContext());
        Assertions.assertNotNull((Object)this.server.getAddressInfo(queueName));
        this.server.locateQueue(queueName).addConsumer((Consumer)new DummyServerConsumer());
        DeleteQueue delete = new DeleteQueue();
        delete.setName(queueName.toString());
        delete.setRemoveConsumers(true);
        delete.setAutoDeleteAddress(true);
        delete.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)command);
        Wait.assertTrue(() -> this.server.getAddressInfo(queueName) == null, (long)2000L, (long)10L);
    }

    @Test
    public void testUpdateCoreQueue() throws Exception {
        String queueName = "updateQueue";
        SimpleString queueNameString = SimpleString.of((String)"updateQueue");
        String addressName = "address";
        SimpleString addressSimpleString = SimpleString.of((String)"address");
        int oldMaxConsumers = -1;
        RoutingType oldRoutingType = RoutingType.MULTICAST;
        boolean oldPurgeOnNoConsumers = false;
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST));
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueNameString).setAddress(addressSimpleString).setRoutingType(oldRoutingType).setMaxConsumers(Integer.valueOf(-1)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setAutoCreateAddress(Boolean.valueOf(false)));
        boolean newMaxConsumers = true;
        RoutingType newRoutingType = RoutingType.ANYCAST;
        boolean newPurgeOnNoConsumers = true;
        UpdateQueue updateQueue = new UpdateQueue();
        updateQueue.setName("updateQueue");
        updateQueue.setPurgeOnNoConsumers(true);
        updateQueue.setAnycast(true);
        updateQueue.setMulticast(false);
        updateQueue.setMaxConsumers(1);
        updateQueue.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)updateQueue);
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueNameString);
        Assertions.assertEquals((int)1, (int)queueQueryResult.getMaxConsumers(), (String)"maxConsumers");
        Assertions.assertEquals((Object)newRoutingType, (Object)queueQueryResult.getRoutingType(), (String)"routingType");
        Assertions.assertTrue((true == queueQueryResult.isPurgeOnNoConsumers() ? 1 : 0) != 0, (String)"purgeOnNoConsumers");
    }

    @Test
    public void testUpdateCoreQueueCannotChangeRoutingType() throws Exception {
        String queueName = "updateQueue";
        SimpleString queueNameString = SimpleString.of((String)"updateQueue");
        String addressName = "address";
        SimpleString addressSimpleString = SimpleString.of((String)"address");
        int oldMaxConsumers = 10;
        RoutingType oldRoutingType = RoutingType.MULTICAST;
        boolean oldPurgeOnNoConsumers = false;
        EnumSet<RoutingType> supportedRoutingTypes = EnumSet.of(oldRoutingType);
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, EnumSet.copyOf(supportedRoutingTypes));
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueNameString).setAddress(addressSimpleString).setRoutingType(oldRoutingType).setMaxConsumers(Integer.valueOf(10)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setAutoCreateAddress(Boolean.valueOf(false)));
        RoutingType newRoutingType = RoutingType.ANYCAST;
        UpdateQueue updateQueue = new UpdateQueue();
        updateQueue.setName("updateQueue");
        updateQueue.setAnycast(true);
        updateQueue.setMulticast(false);
        updateQueue.setMaxConsumers(-1);
        updateQueue.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)updateQueue, "AMQ229211");
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueNameString);
        Assertions.assertEquals((int)10, (int)queueQueryResult.getMaxConsumers(), (String)"maxConsumers");
        Assertions.assertEquals((Object)oldRoutingType, (Object)queueQueryResult.getRoutingType(), (String)"routingType");
        Assertions.assertTrue((false == queueQueryResult.isPurgeOnNoConsumers() ? 1 : 0) != 0, (String)"purgeOnNoConsumers");
    }

    @Test
    public void testUpdateCoreQueueCannotLowerMaxConsumers() throws Exception {
        String queueName = "updateQueue";
        SimpleString queueNameString = SimpleString.of((String)"updateQueue");
        String addressName = "address";
        SimpleString addressSimpleString = SimpleString.of((String)"address");
        int oldMaxConsumers = 2;
        RoutingType oldRoutingType = RoutingType.MULTICAST;
        boolean oldPurgeOnNoConsumers = false;
        AddressInfo addressInfo = new AddressInfo(addressSimpleString, oldRoutingType);
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueNameString).setAddress(addressSimpleString).setRoutingType(oldRoutingType).setMaxConsumers(Integer.valueOf(2)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setAutoCreateAddress(Boolean.valueOf(false)));
        this.server.locateQueue(queueNameString).addConsumer((Consumer)new DummyServerConsumer());
        this.server.locateQueue(queueNameString).addConsumer((Consumer)new DummyServerConsumer());
        boolean newMaxConsumers = true;
        UpdateQueue updateQueue = new UpdateQueue();
        updateQueue.setName("updateQueue");
        updateQueue.setMaxConsumers(1);
        updateQueue.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)updateQueue, "AMQ229210");
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueNameString);
        Assertions.assertEquals((int)2, (int)queueQueryResult.getMaxConsumers(), (String)"maxConsumers");
    }

    @Test
    public void testUpdateCoreQueueDoesNotExist() throws Exception {
        SimpleString queueName = SimpleString.of((String)"updateQueue");
        UpdateQueue updateQueue = new UpdateQueue();
        updateQueue.setName(queueName.toString());
        updateQueue.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)updateQueue, "AMQ229017: Queue " + queueName + " does not exist");
        Assertions.assertFalse((boolean)this.server.queueQuery(queueName).isExists());
    }

    @Test
    public void testPurgeQueue() throws Exception {
        SimpleString queueName = SimpleString.of((String)"purgeQueue");
        CreateQueue command = new CreateQueue();
        command.setName(queueName.toString());
        command.setAutoCreateAddress(true);
        command.setAnycast(true);
        command.execute(new ActionContext());
        PurgeQueue purge = new PurgeQueue();
        purge.setName(queueName.toString());
        purge.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionPassed((ConnectionAbstract)purge);
    }

    @Test
    public void testPurgeQueueDoesNotExist() throws Exception {
        SimpleString queueName = SimpleString.of((String)"purgeQueue");
        PurgeQueue purge = new PurgeQueue();
        purge.setName(queueName.toString());
        purge.execute(new ActionContext(System.in, new PrintStream(this.output), new PrintStream(this.error)));
        this.checkExecutionFailure((ConnectionAbstract)purge, "AMQ229067: Cannot find resource with name queue." + queueName);
        Assertions.assertFalse((boolean)this.server.queueQuery(queueName).isExists());
    }

    private void checkExecutionPassed(ConnectionAbstract command) throws Exception {
        String fullMessage = this.output.toString();
        logger.debug("output: {}", (Object)fullMessage);
        Assertions.assertTrue((boolean)fullMessage.contains("successfully"), (String)fullMessage);
    }

    private void checkExecutionFailure(ConnectionAbstract command, String message) throws Exception {
        String fullMessage = this.error.toString();
        logger.debug("error: {}", (Object)fullMessage);
        Assertions.assertTrue((boolean)fullMessage.contains(message), (String)fullMessage);
    }
}

