/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageRateTest
extends ActiveMQTestBase {
    private final SimpleString ADDRESS = SimpleString.of((String)"ADDRESS");
    private ServerLocator locator;

    @Test
    public void testProduceRate() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        this.locator.setProducerMaxRate(10);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start >= 1000L ? 1 : 0) != 0, (String)("TotalTime = " + (end - start)));
        session.close();
    }

    @Test
    public void testConsumeRate() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        this.locator.setConsumerMaxRate(10);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        for (int i = 0; i < 12; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 12; ++i) {
            consumer.receive(1000L);
        }
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start >= 1000L ? 1 : 0) != 0, (String)("TotalTime = " + (end - start)));
        session.close();
    }

    @Test
    public void testConsumeRate2() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        for (int i = 0; i < 12; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS, null, 0x100000, 10, false);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 12; ++i) {
            consumer.receive(1000L);
        }
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start >= 1000L ? 1 : 0) != 0, (String)("TotalTime = " + (end - start)));
        session.close();
    }

    @Test
    public void testConsumeRateListener() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        this.locator.setConsumerMaxRate(10);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        for (int i = 0; i < 12; ++i) {
            producer.send((Message)session.createMessage(false));
        }
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        AtomicInteger failures = new AtomicInteger(0);
        CountDownLatch messages = new CountDownLatch(12);
        consumer.setMessageHandler(message -> {
            try {
                message.acknowledge();
                messages.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
                failures.incrementAndGet();
            }
        });
        long start = System.currentTimeMillis();
        session.start();
        Assertions.assertTrue((boolean)messages.await(5L, TimeUnit.SECONDS));
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start >= 1000L ? 1 : 0) != 0, (String)("TotalTime = " + (end - start)));
        session.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
    }
}

