/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jdbc.store.journal;

import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalImpl;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.jdbc.store.journal.FakeEncodingSupportImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JDBCJournalTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JDBCJournalImpl journal;
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService executorService;
    private SQLProvider sqlProvider;
    private DatabaseStorageConfiguration dbConf;
    @Parameter(index=0)
    public boolean useAuthentication;

    @Parameters(name="authentication = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.journal.destroy();
        this.scheduledExecutorService.shutdownNow();
        this.scheduledExecutorService = null;
        this.executorService.shutdown();
        this.executorService = null;
    }

    @Override
    protected String getJDBCUser() {
        if (this.useAuthentication) {
            return System.getProperty("jdbc.user", "testuser");
        }
        return null;
    }

    @Override
    protected String getJDBCPassword() {
        if (this.useAuthentication) {
            return System.getProperty("jdbc.password", "testpassword");
        }
        return null;
    }

    @BeforeEach
    public void setup() throws Exception {
        this.dbConf = this.createDefaultDatabaseStorageConfiguration();
        if (this.useAuthentication) {
            System.setProperty("derby.connection.requireAuthentication", "true");
            System.setProperty("derby.user." + this.getJDBCUser(), this.getJDBCPassword());
            this.dbConf.setJdbcUser(this.getJDBCUser());
            this.dbConf.setJdbcPassword(this.getJDBCPassword());
        }
        this.sqlProvider = JDBCUtils.getSQLProvider((String)this.dbConf.getJdbcDriverClassName(), (String)this.dbConf.getMessageTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.MESSAGE_JOURNAL);
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        this.executorService = Executors.newSingleThreadExecutor();
        this.journal = new JDBCJournalImpl(this.dbConf.getConnectionProvider(), this.sqlProvider, this.scheduledExecutorService, (Executor)this.executorService, (code, message, file) -> {}, 5L);
        this.journal.start();
    }

    @TestTemplate
    public void testRestartEmptyJournal() throws SQLException {
        Assertions.assertTrue((boolean)this.journal.isStarted());
        Assertions.assertTrue((boolean)this.journal.isStarted());
        this.journal.stop();
        this.journal.start();
        Assertions.assertTrue((boolean)this.journal.isStarted());
    }

    @TestTemplate
    public void testConcurrentEmptyJournal() throws SQLException {
        Assertions.assertTrue((boolean)this.journal.isStarted());
        Assertions.assertEquals((int)0, (int)this.journal.getNumberOfRecords());
        JDBCJournalImpl secondJournal = new JDBCJournalImpl(this.dbConf.getConnectionProvider(), this.sqlProvider, this.scheduledExecutorService, (Executor)this.executorService, (code, message, file) -> Assertions.fail((String)message), 5L);
        secondJournal.start();
        try {
            Assertions.assertTrue((boolean)secondJournal.isStarted());
        }
        finally {
            secondJournal.stop();
        }
    }

    @TestTemplate
    public void testInsertRecords() throws Exception {
        int noRecords = 10;
        for (int i = 0; i < noRecords; ++i) {
            this.journal.appendAddRecord((long)i, (byte)1, new byte[0], true);
        }
        Assertions.assertEquals((int)noRecords, (int)this.journal.getNumberOfRecords());
    }

    @TestTemplate
    public void testCleanupTxRecords() throws Exception {
        this.journal.appendDeleteRecordTransactional(1L, 1L);
        this.journal.appendCommitRecord(1L, true);
        Assertions.assertEquals((int)0, (int)this.journal.getNumberOfRecords());
    }

    @TestTemplate
    public void testCleanupTxRecords4TransactionalRecords() throws Exception {
        this.journal.appendAddRecordTransactional(152L, 154L, (byte)13, new byte[0]);
        this.journal.appendCommitRecord(152L, true);
        Assertions.assertEquals((int)2, (int)this.journal.getNumberOfRecords());
        this.journal.appendDeleteRecordTransactional(236L, 154L);
        this.journal.appendCommitRecord(236L, true);
        Assertions.assertEquals((int)0, (int)this.journal.getNumberOfRecords());
    }

    @TestTemplate
    public void testCallbacks() throws Exception {
        int noRecords = 10;
        final CountDownLatch done = new CountDownLatch(10);
        IOCompletion completion = new IOCompletion(){

            public void storeLineUp() {
            }

            public void done() {
                done.countDown();
            }

            public void onError(int errorCode, String errorMessage) {
            }
        };
        for (int i = 0; i < 10; ++i) {
            this.journal.appendAddRecord(1L, (byte)1, (EncodingSupport)new FakeEncodingSupportImpl(new byte[0]), true, completion);
        }
        this.journal.sync();
        done.await(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)done.getCount(), (long)0L);
    }

    @TestTemplate
    public void testReadJournal() throws Exception {
        int noRecords = 100;
        for (int i = 0; i < noRecords; ++i) {
            this.journal.appendAddRecord((long)i, (byte)i, new byte[i], true);
        }
        int noTx = 10;
        int noTxRecords = 100;
        for (int i = 1000; i < 1000 + noTx; ++i) {
            for (int j = 0; j < noTxRecords; ++j) {
                this.journal.appendAddRecordTransactional((long)i, Long.parseLong("" + i + j), (byte)1, new byte[0]);
            }
            this.journal.appendPrepareRecord((long)i, new byte[0], true);
            this.journal.appendCommitRecord((long)i, true);
        }
        Thread.sleep(2000L);
        ArrayList recordInfos = new ArrayList();
        ArrayList txInfos = new ArrayList();
        this.journal.load(recordInfos, txInfos, null);
        Assertions.assertEquals((int)(noRecords + noTxRecords * noTx), (int)recordInfos.size());
    }
}

