/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.SequentialFileFactoryTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NIONonBufferedSequentialFileFactoryTest
extends SequentialFileFactoryTestBase {
    @Override
    protected SequentialFileFactory createFactory(String folder) {
        return new NIOSequentialFileFactory(new File(folder), false, 1);
    }

    @Test
    public void writeHeapBufferNotFromBeginningAndReadWithDirectBuffer() throws Exception {
        this.writeHeapBufferNotFromBeginningAndRead(false);
    }

    @Test
    public void writeHeapBufferNotFromBeginningAndReadWithHeapBuffer() throws Exception {
        this.writeHeapBufferNotFromBeginningAndRead(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeapBufferNotFromBeginningAndRead(boolean useHeapByteBufferToRead) throws Exception {
        SequentialFile file = this.factory.createSequentialFile("write.amq");
        file.open();
        Assertions.assertEquals((long)0L, (long)file.size());
        Assertions.assertEquals((long)0L, (long)file.position());
        try {
            String data = "writeDirectArray";
            byte[] bytes = "writeDirectArray".getBytes(StandardCharsets.UTF_8);
            file.position((long)this.factory.calculateBlockSize(bytes.length));
            file.writeDirect(ByteBuffer.wrap(bytes), false);
            ByteBuffer readBuffer = !useHeapByteBufferToRead ? this.factory.newBuffer(bytes.length) : ByteBuffer.allocate(bytes.length);
            try {
                file.position((long)this.factory.calculateBlockSize(bytes.length));
                Assertions.assertEquals((int)this.factory.calculateBlockSize(bytes.length), (int)file.read(readBuffer));
                Assertions.assertEquals((Object)"writeDirectArray", (Object)StandardCharsets.UTF_8.decode(readBuffer).toString());
            }
            finally {
                if (!useHeapByteBufferToRead) {
                    this.factory.releaseBuffer(readBuffer);
                }
            }
        }
        finally {
            file.close();
            file.delete();
        }
    }

    @Test
    public void writeHeapBufferAndReadWithDirectBuffer() throws Exception {
        this.writeHeapBufferAndRead(false);
    }

    @Test
    public void writeHeapBufferAndReadWithHeapBuffer() throws Exception {
        this.writeHeapBufferAndRead(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeapBufferAndRead(boolean useHeapByteBufferToRead) throws Exception {
        SequentialFile file = this.factory.createSequentialFile("write.amq");
        file.open();
        Assertions.assertEquals((long)0L, (long)file.size());
        Assertions.assertEquals((long)0L, (long)file.position());
        try {
            String data = "writeDirectArray";
            byte[] bytes = "writeDirectArray".getBytes(StandardCharsets.UTF_8);
            file.writeDirect(ByteBuffer.wrap(bytes), false);
            ByteBuffer readBuffer = !useHeapByteBufferToRead ? this.factory.newBuffer(bytes.length) : ByteBuffer.allocate(bytes.length);
            try {
                file.position(0L);
                Assertions.assertEquals((int)this.factory.calculateBlockSize(bytes.length), (int)file.read(readBuffer));
                Assertions.assertEquals((Object)"writeDirectArray", (Object)StandardCharsets.UTF_8.decode(readBuffer).toString());
            }
            finally {
                if (!useHeapByteBufferToRead) {
                    this.factory.releaseBuffer(readBuffer);
                }
            }
        }
        finally {
            file.close();
            file.delete();
        }
    }

    @Test
    public void writeHeapAndDirectBufferAndReadWithDirectBuffer() throws Exception {
        this.writeHeapAndDirectBufferAndRead(false);
    }

    @Test
    public void writeHeapAndDirectBufferAndReadWithHeapBuffer() throws Exception {
        this.writeHeapAndDirectBufferAndRead(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeapAndDirectBufferAndRead(boolean useHeapByteBufferToRead) throws Exception {
        SequentialFile file = this.factory.createSequentialFile("write.amq");
        file.open();
        Assertions.assertEquals((long)0L, (long)file.size());
        Assertions.assertEquals((long)0L, (long)file.position());
        try {
            String data = "writeDirectArray";
            byte[] bytes = "writeDirectArray".getBytes(StandardCharsets.UTF_8);
            file.writeDirect(ByteBuffer.wrap(bytes), false);
            ByteBuffer byteBuffer = this.factory.newBuffer(bytes.length);
            byteBuffer.put(bytes);
            byteBuffer.flip();
            file.writeDirect(byteBuffer, false);
            ByteBuffer readBuffer = !useHeapByteBufferToRead ? this.factory.newBuffer(bytes.length) : ByteBuffer.allocate(bytes.length);
            try {
                file.position(0L);
                Assertions.assertEquals((int)this.factory.calculateBlockSize(bytes.length), (int)file.read(readBuffer));
                Assertions.assertEquals((Object)"writeDirectArray", (Object)StandardCharsets.UTF_8.decode(readBuffer).toString());
                readBuffer.flip();
                Assertions.assertEquals((int)this.factory.calculateBlockSize(bytes.length), (int)file.read(readBuffer));
                Assertions.assertEquals((Object)"writeDirectArray", (Object)StandardCharsets.UTF_8.decode(readBuffer).toString());
            }
            finally {
                if (!useHeapByteBufferToRead) {
                    this.factory.releaseBuffer(readBuffer);
                }
            }
        }
        finally {
            file.close();
            file.delete();
        }
    }
}

