/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JmsConsumerResetActiveListenerTest
extends BasicOpenWireTest {
    @Test
    public void testSetListenerFromListener() throws Exception {
        Session session = this.connection.createSession(false, 2);
        Queue dest = session.createQueue(this.queueName);
        final MessageConsumer consumer = session.createConsumer((Destination)dest);
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicBoolean first = new AtomicBoolean(true);
        final Vector results = new Vector();
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                if (first.compareAndSet(true, false)) {
                    try {
                        consumer.setMessageListener((MessageListener)this);
                        results.add(message);
                    }
                    catch (JMSException e) {
                        results.add(e);
                    }
                } else {
                    results.add(message);
                }
                latch.countDown();
            }
        });
        this.connection.start();
        MessageProducer producer = session.createProducer((Destination)dest);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("First"));
        producer.send((Message)session.createTextMessage("Second"));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS), (String)"we did not timeout");
        Assertions.assertEquals((int)2, (int)results.size(), (String)"we have a result");
        Object result = results.get(0);
        Assertions.assertTrue((boolean)(result instanceof TextMessage));
        Assertions.assertEquals((Object)"First", (Object)((TextMessage)result).getText(), (String)"result is first");
        result = results.get(1);
        Assertions.assertTrue((boolean)(result instanceof TextMessage));
        Assertions.assertEquals((Object)"Second", (Object)((TextMessage)result).getText(), (String)"result is first");
    }

    @Test
    public void testNewConsumerSetListenerFromListener() throws Exception {
        final Session session = this.connection.createSession(false, 2);
        Queue dest = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        CountDownLatch latch = new CountDownLatch(2);
        final AtomicBoolean first = new AtomicBoolean(true);
        Vector results = new Vector();
        consumer.setMessageListener(new MessageListener(){
            final /* synthetic */ Destination val$dest;
            final /* synthetic */ Vector val$results;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$dest = destination;
                this.val$results = vector;
                this.val$latch = countDownLatch;
            }

            public void onMessage(Message message) {
                if (first.compareAndSet(true, false)) {
                    try {
                        MessageConsumer anotherConsumer = session.createConsumer(this.val$dest);
                        anotherConsumer.setMessageListener((MessageListener)this);
                        this.val$results.add(message);
                    }
                    catch (JMSException e) {
                        this.val$results.add(e);
                    }
                } else {
                    this.val$results.add(message);
                }
                this.val$latch.countDown();
            }
        });
        this.connection.start();
        MessageProducer producer = session.createProducer((Destination)dest);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("First"));
        producer.send((Message)session.createTextMessage("Second"));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS), (String)"we did not timeout");
        Assertions.assertEquals((int)2, (int)results.size(), (String)"we have a result");
        Object result = results.get(0);
        Assertions.assertTrue((boolean)(result instanceof TextMessage));
        Assertions.assertEquals((Object)"First", (Object)((TextMessage)result).getText(), (String)"result is first");
        result = results.get(1);
        Assertions.assertTrue((boolean)(result instanceof TextMessage));
        Assertions.assertEquals((Object)"Second", (Object)((TextMessage)result).getText(), (String)"result is first");
    }
}

