/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesExpiredPagingTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ADDRESS = "MessagesExpiredPagingTest";
    private static final int NUMBER_OF_QUEUES = 10;
    private AtomicBoolean running = new AtomicBoolean(true);
    ActiveMQServer server;
    protected static final int PAGE_MAX = 102400;
    protected static final int PAGE_SIZE = 10240;
    Queue[] queues = new Queue[10];
    ExecutorService expiresExecutor;

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.running.set(false);
        this.expiresExecutor.shutdown();
        Assertions.assertTrue((boolean)this.expiresExecutor.awaitTermination(10L, TimeUnit.SECONDS));
        super.tearDown();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.expiresExecutor = Executors.newFixedThreadPool(10);
        Configuration config = this.createDefaultConfig(0, true).setJournalSyncNonTransactional(false);
        config.setMessageExpiryScanPeriod(-1L);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.getAddressSettingsRepository().clear();
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(102400L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(ADDRESS).addRoutingType(RoutingType.MULTICAST));
        for (int i = 0; i < 10; ++i) {
            Queue queue;
            this.queues[i] = queue = this.server.createQueue(QueueConfiguration.of((String)("q" + i)).setRoutingType(RoutingType.MULTICAST).setAddress(ADDRESS));
            this.expiresExecutor.execute(() -> {
                Thread.currentThread().setName("Expiry on " + queue.getName() + ".." + Thread.currentThread().getName());
                while (this.running.get()) {
                    try {
                        queue.expireReferences();
                        Thread.sleep(10L);
                    }
                    catch (Throwable e) {
                        logger.warn(e.getMessage(), e);
                    }
                }
            });
        }
    }

    @Test
    public void testSendReceiveCORELarge() throws Exception {
        this.testSendReceive("CORE", 50, 20, 10, 512000);
    }

    @Test
    public void testSendReceiveCORE() throws Exception {
        this.testSendReceive("CORE", 5000, 1000, 100, 0);
    }

    @Test
    public void testSendReceiveAMQP() throws Exception {
        this.testSendReceive("AMQP", 5000, 1000, 100, 0);
    }

    @Test
    public void testSendReceiveAMQPLarge() throws Exception {
        this.testSendReceive("AMQP", 50, 20, 10, 512000);
    }

    @Test
    public void testSendReceiveOpenWire() throws Exception {
        this.testSendReceive("OPENWIRE", 5000, 1000, 100, 0);
    }

    public void testSendReceive(String protocol, int numberOfMessages, int numberOfMessageSecondWave, int pagingInterval, int bodySize) throws Exception {
        int i;
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < bodySize; ++i) {
            buffer.append("*");
        }
        String extraBody = buffer.toString();
        Consumer[] consumers = new Consumer[10];
        for (i = 0; i < 10; ++i) {
            consumers[i] = new Consumer(factory, "q" + i, bodySize);
            consumers[i].start();
        }
        try (Connection connection = factory.createConnection();){
            int i2;
            Session session = connection.createSession(false, 1);
            Topic jmsTopic = session.createTopic(ADDRESS);
            MessageProducer producer = session.createProducer((Destination)jmsTopic);
            for (int i3 = 0; i3 < 10; ++i3) {
                producer.send((Message)session.createTextMessage("hello" + extraBody));
            }
            for (Consumer c : consumers) {
                Wait.assertEquals((int)10, c.consumed::get);
            }
            for (Consumer c : consumers) {
                c.consumedDelta.set(0);
            }
            producer.setTimeToLive(10L);
            for (i2 = 0; i2 < numberOfMessages; ++i2) {
                if (i2 > 0 && i2 % pagingInterval == 0) {
                    Consumer[] consumerArray = consumers;
                    int n = consumerArray.length;
                    for (int c = 0; c < n; ++c) {
                        Consumer c2 = consumerArray[c];
                        producer.setTimeToLive(TimeUnit.HOURS.toMillis(1L));
                        producer.send((Message)session.createTextMessage("hello" + extraBody));
                        Wait.assertTrue(() -> c.consumedDelta.get() > 0);
                        producer.setTimeToLive(10L);
                        c2.consumedDelta.set(0);
                    }
                    this.queues[0].getPagingStore().forceAnotherPage();
                }
                producer.send((Message)session.createTextMessage("hello" + extraBody));
            }
            producer.setTimeToLive(300L);
            for (i2 = 0; i2 < numberOfMessageSecondWave; ++i2) {
                if (i2 > 0 && i2 % pagingInterval == 0) {
                    this.queues[0].getPagingStore().forceAnotherPage();
                }
                producer.send((Message)session.createTextMessage("hello" + extraBody));
            }
            producer.setTimeToLive(TimeUnit.HOURS.toMillis(1L));
            producer.send((Message)session.createTextMessage("hello again" + extraBody));
            for (Consumer c : consumers) {
                Wait.assertTrue(() -> c.consumedDelta.get() > 0);
            }
            this.running.set(false);
            for (Consumer c : consumers) {
                c.join(5000L);
                Assertions.assertFalse((boolean)c.isAlive());
                Assertions.assertEquals((int)0, (int)c.errors.get());
            }
        }
    }

    private class Consumer
    extends Thread {
        final ConnectionFactory factory;
        final int minimalSize;
        AtomicInteger consumedDelta = new AtomicInteger(0);
        AtomicInteger consumed = new AtomicInteger(0);
        AtomicInteger errors = new AtomicInteger(0);
        final String queueName;

        Consumer(ConnectionFactory factory, String queueName, int minimalSize) {
            this.factory = factory;
            this.queueName = queueName;
            this.minimalSize = minimalSize;
        }

        @Override
        public void run() {
            try {
                int rec = 0;
                try (Connection connection = this.factory.createConnection();){
                    Session session = connection.createSession(false, 1);
                    jakarta.jms.Queue jmsQueue = session.createQueue("MessagesExpiredPagingTest::" + this.queueName);
                    MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
                    connection.start();
                    while (MessagesExpiredPagingTest.this.running.get()) {
                        TextMessage message = (TextMessage)consumer.receive(500L);
                        if (message != null) {
                            Assertions.assertTrue((message.getText().length() > this.minimalSize ? (byte)1 : 0) != 0);
                            this.consumed.incrementAndGet();
                            this.consumedDelta.incrementAndGet();
                            Thread.sleep(2L);
                        }
                        if (rec++ <= 10) continue;
                        rec = 0;
                        consumer.close();
                        consumer = session.createConsumer((Destination)jmsQueue);
                    }
                }
            }
            catch (Throwable e) {
                this.errors.incrementAndGet();
            }
        }
    }
}

