/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.tests.integration.plugin.MetricsPluginTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMetricsTest
extends ActiveMQTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testLoggingMetrics() throws Exception {
        String idName = "log4j2.events";
        Tag brokerTag = Tag.of((String)"broker", (String)"localhost");
        String levelName = "level";
        int start = 0;
        String message = "";
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig().setMetricsConfiguration(new MetricsConfiguration().setPlugin(new SimpleMetricsPlugin().init(null)).setLogging(true)));
        server.start();
        Configurator.setLevel(MethodHandles.lookup().lookupClass(), (Level)Level.TRACE);
        Logger logger2 = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Meter.Id trace = new Meter.Id("log4j2.events", Tags.of((Tag[])new Tag[]{brokerTag, Tag.of((String)"level", (String)"trace")}), null, null, null);
        Assertions.assertTrue((boolean)MetricsPluginTest.getMetrics(server).containsKey(trace));
        start = MetricsPluginTest.getMetrics(server).get(trace).intValue();
        logger2.trace(message);
        logger2.trace(message);
        logger2.trace(message);
        Assertions.assertEquals((int)3, (int)(MetricsPluginTest.getMetrics(server).get(trace).intValue() - start));
        Meter.Id debug = new Meter.Id("log4j2.events", Tags.of((Tag[])new Tag[]{brokerTag, Tag.of((String)"level", (String)"debug")}), null, null, null);
        Assertions.assertTrue((boolean)MetricsPluginTest.getMetrics(server).containsKey(debug));
        start = MetricsPluginTest.getMetrics(server).get(debug).intValue();
        logger2.debug(message);
        logger2.debug(message);
        logger2.debug(message);
        Assertions.assertEquals((int)3, (int)(MetricsPluginTest.getMetrics(server).get(debug).intValue() - start));
        Meter.Id info = new Meter.Id("log4j2.events", Tags.of((Tag[])new Tag[]{brokerTag, Tag.of((String)"level", (String)"info")}), null, null, null);
        Assertions.assertTrue((boolean)MetricsPluginTest.getMetrics(server).containsKey(info));
        start = MetricsPluginTest.getMetrics(server).get(info).intValue();
        logger2.info(message);
        logger2.info(message);
        logger2.info(message);
        Assertions.assertEquals((int)3, (int)(MetricsPluginTest.getMetrics(server).get(info).intValue() - start));
        Meter.Id warn = new Meter.Id("log4j2.events", Tags.of((Tag[])new Tag[]{brokerTag, Tag.of((String)"level", (String)"warn")}), null, null, null);
        Assertions.assertTrue((boolean)MetricsPluginTest.getMetrics(server).containsKey(warn));
        start = MetricsPluginTest.getMetrics(server).get(warn).intValue();
        logger2.warn(message);
        logger2.warn(message);
        logger2.warn(message);
        Assertions.assertEquals((int)3, (int)(MetricsPluginTest.getMetrics(server).get(warn).intValue() - start));
        Meter.Id error = new Meter.Id("log4j2.events", Tags.of((Tag[])new Tag[]{brokerTag, Tag.of((String)"level", (String)"error")}), null, null, null);
        Assertions.assertTrue((boolean)MetricsPluginTest.getMetrics(server).containsKey(error));
        start = MetricsPluginTest.getMetrics(server).get(error).intValue();
        logger2.error(message);
        logger2.error(message);
        logger2.error(message);
        Assertions.assertEquals((int)3, (int)(MetricsPluginTest.getMetrics(server).get(error).intValue() - start));
    }
}

