/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.WildcardAddressManager;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildcardAddressManagerUnitTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testUnitOnWildCardFailingScenario() throws Exception {
        int errors = 0;
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addBinding((Binding)new BindingFake("Topic1", "Topic1"));
        ad.addBinding((Binding)new BindingFake("Topic1", "one"));
        ad.addBinding((Binding)new BindingFake("*", "two"));
        ad.removeBinding(SimpleString.of((String)"one"), null);
        try {
            ad.removeBinding(SimpleString.of((String)"two"), null);
        }
        catch (Throwable e) {
            ++errors;
            e.printStackTrace();
        }
        try {
            ad.addBinding((Binding)new BindingFake("Topic1", "three"));
        }
        catch (Throwable e) {
            ++errors;
            e.printStackTrace();
        }
        Assertions.assertEquals((int)0, (int)errors, (String)"Exception happened during the process");
    }

    @Test
    public void testUnitOnWildCardFailingScenarioFQQN() throws Exception {
        int errors = 0;
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addBinding((Binding)new BindingFake("Topic1", "Topic1"));
        ad.addBinding((Binding)new BindingFake("Topic1", "one"));
        ad.addBinding((Binding)new BindingFake("*", "two"));
        ad.removeBinding(SimpleString.of((String)"Topic1::one"), null);
        try {
            ad.removeBinding(SimpleString.of((String)"*::two"), null);
        }
        catch (Throwable e) {
            ++errors;
            e.printStackTrace();
        }
        try {
            ad.addBinding((Binding)new BindingFake("Topic1", "three"));
        }
        catch (Throwable e) {
            ++errors;
            e.printStackTrace();
        }
        Assertions.assertEquals((int)0, (int)errors, (String)"Exception happened during the process");
    }

    @Test
    public void testWildCardAddressRemoval() throws Exception {
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Queue1.#"), RoutingType.ANYCAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic1.#"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("Topic1.#", "two"));
        ad.addBinding((Binding)new BindingFake("Queue1.#", "one"));
        Assertions.assertEquals((int)1, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"Topic1.topic")).getBindings().size());
        ad.removeAddressInfo(SimpleString.of((String)"Topic1.#"));
        Assertions.assertNull((Object)ad.getAddressInfo(SimpleString.of((String)"Topic1.#")));
    }

    @Test
    public void testWildCardAddRemoveBinding() throws Exception {
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        SimpleString address = SimpleString.of((String)"Queue1.1");
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Queue1.#"), RoutingType.ANYCAST));
        BindingFake bindingFake = new BindingFake("Queue1.#", "one");
        Assertions.assertTrue((boolean)ad.addBinding((Binding)bindingFake));
        Assertions.assertEquals((int)1, (int)ad.getBindingsForRoutingAddress(address).getBindings().size());
        ad.removeBinding(bindingFake.getUniqueName(), null);
        Assertions.assertNull((Object)ad.getExistingBindingsForRoutingAddress(address));
    }

    @Test
    public void testWildCardAddAlreadyExistingBindingShouldThrowException() throws Exception {
        Assertions.assertThrows(ActiveMQQueueExistsException.class, () -> {
            WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
            ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Queue1.#"), RoutingType.ANYCAST));
            ad.addBinding((Binding)new BindingFake("Queue1.#", "one"));
            ad.addBinding((Binding)new BindingFake("Queue1.#", "one"));
        });
    }

    @Test
    public void testWildCardAddressRemovalDifferentWildcard() throws Exception {
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic1.>"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic1.test"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("Topic1.>", "one"));
        Assertions.assertEquals((int)1, (int)ad.getExistingBindingsForRoutingAddress(SimpleString.of((String)"Topic1.>")).getBindings().size());
        Assertions.assertEquals((int)1, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"Topic1.test")).getBindings().size());
        Assertions.assertEquals((int)0, (int)ad.getDirectBindings(SimpleString.of((String)"Topic1.test")).size());
        Assertions.assertEquals((int)1, (int)ad.getDirectBindings(SimpleString.of((String)"Topic1.>")).size());
        ad.removeAddressInfo(SimpleString.of((String)"Topic1.test"));
        Assertions.assertEquals((int)1, (int)ad.getAddresses().size());
        Assertions.assertEquals((long)1L, (long)ad.getBindings().count());
        ad.removeBinding(SimpleString.of((String)"one"), null);
        ad.removeAddressInfo(SimpleString.of((String)"Topic1.>"));
        Assertions.assertEquals((int)0, (int)ad.getAddresses().size());
        Assertions.assertEquals((long)0L, (long)ad.getBindings().count());
        Assertions.assertEquals((int)0, (int)ad.getDirectBindings(SimpleString.of((String)"Topic1.>")).size());
    }

    @Test
    public void testWildCardAddressDirectBindings() throws Exception {
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic1.>"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic1.test"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic1.test.test1"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic1.test.test2"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic2.>"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"Topic2.test"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("Topic1.>", "one"));
        ad.addBinding((Binding)new BindingFake("Topic1.test", "two"));
        ad.addBinding((Binding)new BindingFake("Topic2.test", "three"));
        Assertions.assertEquals((int)1, (int)ad.getExistingBindingsForRoutingAddress(SimpleString.of((String)"Topic1.>")).getBindings().size());
        Assertions.assertEquals((int)2, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"Topic1.test")).getBindings().size());
        Assertions.assertEquals((int)1, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"Topic1.test.test1")).getBindings().size());
        Assertions.assertEquals((int)1, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"Topic1.test.test2")).getBindings().size());
        Assertions.assertEquals((int)1, (int)ad.getDirectBindings(SimpleString.of((String)"Topic1.>")).size());
        Assertions.assertEquals((int)1, (int)ad.getDirectBindings(SimpleString.of((String)"Topic1.test")).size());
        Assertions.assertEquals((int)0, (int)ad.getDirectBindings(SimpleString.of((String)"Topic1.test1")).size());
        Assertions.assertEquals((int)0, (int)ad.getDirectBindings(SimpleString.of((String)"Topic1.test2")).size());
        Assertions.assertEquals((int)0, (int)ad.getDirectBindings(SimpleString.of((String)"Topic2.>")).size());
        Assertions.assertEquals((int)1, (int)ad.getDirectBindings(SimpleString.of((String)"Topic2.test")).size());
    }

    @Test
    public void testSingleWordWildCardAddressBindingsForRouting() throws Exception {
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"news.*"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"news.*.sport"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("news.*", "one"));
        ad.addBinding((Binding)new BindingFake("news.*.sport", "two"));
        Collection bindings = ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe")).getBindings();
        Assertions.assertEquals((int)1, (int)bindings.size());
        Assertions.assertEquals((Object)"one", (Object)((Binding)bindings.iterator().next()).getUniqueName().toString());
        bindings = ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.usa")).getBindings();
        Assertions.assertEquals((int)1, (int)bindings.size());
        Assertions.assertEquals((Object)"one", (Object)((Binding)bindings.iterator().next()).getUniqueName().toString());
        bindings = ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe.sport")).getBindings();
        Assertions.assertEquals((int)1, (int)bindings.size());
        Assertions.assertEquals((Object)"two", (Object)((Binding)bindings.iterator().next()).getUniqueName().toString());
        bindings = ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.usa.sport")).getBindings();
        Assertions.assertEquals((int)1, (int)bindings.size());
        Assertions.assertEquals((Object)"two", (Object)((Binding)bindings.iterator().next()).getUniqueName().toString());
        Assertions.assertNull((Object)ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe.fr.sport")));
    }

    @Test
    public void testAnyWordsWildCardAddressBindingsForRouting() throws Exception {
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"news.europe.#"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("news.europe.#", "one"));
        Assertions.assertEquals((int)1, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe")).getBindings().size());
        Assertions.assertEquals((int)1, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe.sport")).getBindings().size());
        Assertions.assertEquals((int)1, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe.politics.fr")).getBindings().size());
        Assertions.assertNull((Object)ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.usa")));
        Assertions.assertNull((Object)ad.getBindingsForRoutingAddress(SimpleString.of((String)"europe")));
    }

    @Test
    public void testAnyWordsMultipleWildCardsAddressBindingsForRouting() throws Exception {
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), null, null);
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"news.#"), RoutingType.MULTICAST));
        ad.addAddressInfo(new AddressInfo(SimpleString.of((String)"news.europe.#"), RoutingType.MULTICAST));
        ad.addBinding((Binding)new BindingFake("news.#", "one"));
        ad.addBinding((Binding)new BindingFake("news.europe.#", "two"));
        Assertions.assertEquals((int)2, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe")).getBindings().size());
        Assertions.assertEquals((int)2, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe.sport")).getBindings().size());
        Assertions.assertEquals((int)2, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.europe.politics.fr")).getBindings().size());
        Collection bindings = ad.getBindingsForRoutingAddress(SimpleString.of((String)"news.usa")).getBindings();
        Assertions.assertEquals((int)1, (int)bindings.size());
        Assertions.assertEquals((Object)"one", (Object)((Binding)bindings.iterator().next()).getUniqueName().toString());
        Assertions.assertNull((Object)ad.getBindingsForRoutingAddress(SimpleString.of((String)"europe")));
    }

    @Test
    public void testNumberOfBindingsThatMatch() throws Exception {
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        ad.addBinding((Binding)new BindingFake("T.>", "1"));
        ad.addBinding((Binding)new BindingFake("T.>", "2"));
        ad.addBinding((Binding)new BindingFake("T.>", "3"));
        Assertions.assertEquals((int)3, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.1")).getBindings().size());
        Assertions.assertEquals((int)3, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.2")).getBindings().size());
        Assertions.assertEquals((int)3, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.3")).getBindings().size());
        Assertions.assertEquals((int)3, (int)ad.getExistingBindingsForRoutingAddress(SimpleString.of((String)"T.>")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.*", "10"));
        Assertions.assertEquals((int)1, (int)ad.getExistingBindingsForRoutingAddress(SimpleString.of((String)"T.*")).getBindings().size());
        Assertions.assertEquals((int)3, (int)ad.getExistingBindingsForRoutingAddress(SimpleString.of((String)"T.>")).getBindings().size());
        Assertions.assertEquals((int)4, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.1")).getBindings().size());
        Assertions.assertEquals((int)4, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.2")).getBindings().size());
        Assertions.assertEquals((int)4, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.3")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.1.>", "11"));
        Assertions.assertEquals((int)1, (int)ad.getExistingBindingsForRoutingAddress(SimpleString.of((String)"T.1.>")).getBindings().size());
        Assertions.assertEquals((int)5, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.1")).getBindings().size());
        Assertions.assertEquals((int)4, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.2")).getBindings().size());
        Assertions.assertEquals((int)4, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.3")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.1.2", "12"));
        Assertions.assertEquals((int)5, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.1.2")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.1.2.3.4", "13"));
        Assertions.assertEquals((int)5, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.1.2.3.4")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.>.4", "14"));
        Assertions.assertEquals((int)6, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.1.2.3.4")).getBindings().size());
        ad.addBinding((Binding)new BindingFake("T.1.A.3.4", "15"));
        Assertions.assertEquals((int)6, (int)ad.getBindingsForRoutingAddress(SimpleString.of((String)"T.1.A.3.4")).getBindings().size());
    }

    @Test
    public void testConcurrentCalls() throws Exception {
        WildcardConfiguration configuration = new WildcardConfiguration();
        configuration.setAnyWords('>');
        WildcardAddressManager ad = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), configuration, null, null);
        SimpleString wildCard = SimpleString.of((String)"Topic1.>");
        ad.addAddressInfo(new AddressInfo(wildCard, RoutingType.MULTICAST));
        AtomicReference oops = new AtomicReference();
        int numSubs = 500;
        int numThreads = 2;
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        int i = 0;
        while (i < numSubs) {
            int id = i++;
            executorService.submit(() -> {
                try {
                    ExecutorService executorService2 = executorService;
                    synchronized (executorService2) {
                        ad.addBinding((Binding)new BindingFake(SimpleString.of((String)"Topic1.>"), SimpleString.of((String)("" + id))));
                    }
                    SimpleString pubAddr = SimpleString.of((String)("Topic1." + id));
                    ad.getBindingsForRoutingAddress(pubAddr);
                    ad.getBindingsForRoutingAddress(pubAddr);
                    ad.getDirectBindings(pubAddr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    oops.set(e);
                }
            });
        }
        executorService.shutdown();
        Assertions.assertTrue((boolean)executorService.awaitTermination(10L, TimeUnit.MINUTES), (String)"finished on time");
        Assertions.assertNull(oops.get(), (String)"no exceptions");
    }

    @Test
    public void testConcurrentCalls2() throws Exception {
        WildcardAddressManager simpleAddressManager = new WildcardAddressManager((BindingsFactory)new BindingFactoryFake(), (StorageManager)new NullStorageManager(), null);
        int threads = 20;
        int adds = 1000;
        int keep = 100;
        String address = "TheAddress";
        SimpleString addressSimpleString = SimpleString.of((String)address);
        simpleAddressManager.addAddressInfo(new AddressInfo(address).addRoutingType(RoutingType.MULTICAST));
        ExecutorService executor = Executors.newFixedThreadPool(21);
        this.runAfter(executor::shutdownNow);
        CountDownLatch latch = new CountDownLatch(20);
        CountDownLatch latch2 = new CountDownLatch(1);
        AtomicInteger errors = new AtomicInteger(0);
        AtomicBoolean running = new AtomicBoolean(true);
        this.runAfter(() -> running.set(false));
        executor.execute(() -> {
            try {
                while (running.get()) {
                    simpleAddressManager.getDirectBindings(addressSimpleString);
                    Thread.sleep(1L);
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                errors.incrementAndGet();
            }
            finally {
                latch2.countDown();
            }
        });
        int thread = 0;
        while (thread < 20) {
            int threadID = thread++;
            executor.execute(() -> {
                try {
                    for (int add = 0; add < 1000; ++add) {
                        simpleAddressManager.addBinding((Binding)new BindingFake(address, "t" + threadID + "_" + add));
                    }
                    for (int remove = 100; remove < 1000; ++remove) {
                        simpleAddressManager.removeBinding(SimpleString.of((String)("t" + threadID + "_" + remove)), null);
                    }
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            });
        }
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
        running.set(false);
        Assertions.assertTrue((boolean)latch2.await(1L, TimeUnit.MINUTES));
        Assertions.assertEquals((int)0, (int)errors.get());
        Collection bindings = simpleAddressManager.getDirectBindings(SimpleString.of((String)address));
        HashSet result = new HashSet();
        bindings.forEach(b -> result.add(b.getUniqueName().toString()));
        Assertions.assertEquals((int)2000, (int)result.size());
        for (int thread2 = 0; thread2 < 20; ++thread2) {
            for (int add = 0; add < 100; ++add) {
                Assertions.assertTrue((boolean)result.contains("t" + thread2 + "_" + add));
            }
        }
    }

    static class BindingFactoryFake
    implements BindingsFactory {
        BindingFactoryFake() {
        }

        public boolean isAddressBound(SimpleString address) throws Exception {
            return false;
        }

        public Bindings createBindings(SimpleString address) {
            return new BindingsFake(address);
        }
    }

    static class BindingFake
    implements Binding {
        final SimpleString address;
        final SimpleString id;

        BindingFake(String addressParameter, String id) {
            this(SimpleString.of((String)addressParameter), SimpleString.of((String)id));
        }

        BindingFake(SimpleString addressParameter, SimpleString id) {
            this.address = addressParameter;
            this.id = id;
        }

        public void unproposed(SimpleString groupID) {
        }

        public SimpleString getAddress() {
            return this.address;
        }

        public Bindable getBindable() {
            return null;
        }

        public BindingType getType() {
            return null;
        }

        public SimpleString getUniqueName() {
            return this.id;
        }

        public SimpleString getRoutingName() {
            return null;
        }

        public SimpleString getClusterName() {
            return null;
        }

        public Filter getFilter() {
            return null;
        }

        public boolean isHighAcceptPriority(Message message) {
            return false;
        }

        public boolean isExclusive() {
            return false;
        }

        public Long getID() {
            return 0L;
        }

        public int getDistance() {
            return 0;
        }

        public void route(Message message, RoutingContext context) throws Exception {
        }

        public void close() throws Exception {
        }

        public String toManagementString() {
            return "FakeBiding Address=" + this.address;
        }

        public boolean isConnected() {
            return true;
        }

        public void routeWithAck(Message message, RoutingContext context) {
        }
    }

    static class BindingsFake
    implements Bindings {
        SimpleString name;
        ConcurrentHashMap<String, Binding> bindings = new ConcurrentHashMap();

        BindingsFake(SimpleString address) {
            this.name = address;
        }

        public boolean hasLocalBinding() {
            return false;
        }

        public Collection<Binding> getBindings() {
            return this.bindings.values();
        }

        public void addBinding(Binding binding) {
            this.bindings.put(String.valueOf(binding.getUniqueName()), binding);
        }

        public Binding removeBindingByUniqueName(SimpleString uniqueName) {
            return this.bindings.remove(String.valueOf(uniqueName));
        }

        public SimpleString getName() {
            return this.name;
        }

        public void setMessageLoadBalancingType(MessageLoadBalancingType messageLoadBalancingType) {
        }

        public Binding getBinding(String name) {
            return this.bindings.get(name);
        }

        public void forEach(BiConsumer<String, Binding> bindingConsumer) {
            this.bindings.forEach(bindingConsumer);
        }

        public int size() {
            return this.bindings.size();
        }

        public MessageLoadBalancingType getMessageLoadBalancingType() {
            return null;
        }

        public void unproposed(SimpleString groupID) {
        }

        public void updated(QueueBinding binding) {
        }

        public Message redistribute(Message message, Queue originatingQueue, RoutingContext context) throws Exception {
            return null;
        }

        public void route(Message message, RoutingContext context) throws Exception {
            logger.debug("routing message: {}", (Object)message);
        }

        public boolean allowRedistribute() {
            return false;
        }
    }
}

