/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client.sasl;

import org.apache.activemq.transport.amqp.client.sasl.AbstractMechanism;
import org.apache.activemq.transport.amqp.client.sasl.Mechanism;

public class PlainMechanism
extends AbstractMechanism {
    public static final String MECH_NAME = "PLAIN";

    @Override
    public int getPriority() {
        return Mechanism.PRIORITY.MEDIUM.getValue();
    }

    @Override
    public String getName() {
        return MECH_NAME;
    }

    @Override
    public byte[] getInitialResponse() {
        String authzid = this.getAuthzid();
        String username = this.getUsername();
        String password = this.getPassword();
        if (authzid == null) {
            authzid = "";
        }
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        byte[] authzidBytes = authzid.getBytes();
        byte[] usernameBytes = username.getBytes();
        byte[] passwordBytes = password.getBytes();
        byte[] data = new byte[authzidBytes.length + 1 + usernameBytes.length + 1 + passwordBytes.length];
        System.arraycopy(authzidBytes, 0, data, 0, authzidBytes.length);
        System.arraycopy(usernameBytes, 0, data, 1 + authzidBytes.length, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, data, 2 + authzidBytes.length + usernameBytes.length, passwordBytes.length);
        return data;
    }

    @Override
    public byte[] getChallengeResponse(byte[] challenge) {
        return EMPTY;
    }

    @Override
    public boolean isApplicable(String username, String password) {
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }
}

