/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.management.BaseHttpInterfaceAddStepHandler;
import org.jboss.as.controller.management.HttpInterfaceCommonPolicy;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.http.server.ConsoleAvailability;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.ExternalManagementRequestExecutor;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.HttpManagementRequestsService;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.HttpShutdownService;
import org.jboss.as.server.mgmt.ManagementWorkerService;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.operations.NativeManagementServices;
import org.jboss.as.server.security.AdvancedSecurityMetaData;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;

public class HttpManagementAddHandler
extends BaseHttpInterfaceAddStepHandler {
    public static final HttpManagementAddHandler INSTANCE = new HttpManagementAddHandler();

    private HttpManagementAddHandler() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        HttpManagementResourceDefinition.addAttributeValidator(context);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && (context.getProcessType() != ProcessType.EMBEDDED_SERVER || context.getRunningMode() != RunningMode.ADMIN_ONLY);
    }

    protected List<ServiceName> installServices(OperationContext context, HttpInterfaceCommonPolicy commonPolicy, ModelNode model) throws OperationFailedException {
        SecurityMetaData securityMetaData;
        CapabilityServiceTarget serviceTarget = context.getCapabilityServiceTarget();
        String socketBindingName = HttpManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asStringOrNull();
        String secureSocketBindingName = HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.resolveModelAttribute(context, model).asStringOrNull();
        if (socketBindingName != null) {
            if (secureSocketBindingName != null) {
                ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSocketAndSecureSocket(socketBindingName, secureSocketBindingName);
            } else {
                ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSocket(socketBindingName);
            }
        } else if (secureSocketBindingName != null) {
            ServerLogger.ROOT_LOGGER.creatingHttpManagementServiceOnSecureSocket(secureSocketBindingName);
        }
        ConsoleMode consoleMode = this.consoleMode(commonPolicy.isConsoleEnabled(), context.getRunningMode() == RunningMode.ADMIN_ONLY);
        ServiceName requestProcessorName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"requests"});
        HttpManagementRequestsService.installService(requestProcessorName, (ServiceTarget)serviceTarget);
        NativeManagementServices.installManagementWorkerService((ServiceTarget)serviceTarget, context.getServiceRegistry(false));
        String httpAuthenticationFactory = commonPolicy.getHttpAuthenticationFactory();
        String sslContext = commonPolicy.getSSLContext();
        if (httpAuthenticationFactory == null) {
            ServerLogger.ROOT_LOGGER.httpManagementInterfaceIsUnsecured();
        }
        CapabilityServiceBuilder builder = serviceTarget.addCapability(UndertowHttpManagementService.EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY);
        Consumer hmConsumer = builder.provides(UndertowHttpManagementService.EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY);
        Supplier lrSupplier = builder.requires(RemotingServices.HTTP_LISTENER_REGISTRY);
        Supplier mcSupplier = builder.requires(Services.JBOSS_SERVER_CONTROLLER);
        Supplier sbSupplier = socketBindingName != null ? builder.requires(SocketBinding.SERVICE_DESCRIPTOR, socketBindingName) : null;
        Supplier ssbSupplier = secureSocketBindingName != null ? builder.requires(SocketBinding.SERVICE_DESCRIPTOR, secureSocketBindingName) : null;
        Supplier sbmSupplier = builder.requires(SocketBindingManager.SERVICE_DESCRIPTOR);
        Supplier caSupplier = builder.requiresCapability("org.wildfly.management.console-availability", ConsoleAvailability.class, new String[0]);
        Supplier rpSupplier = builder.requires(requestProcessorName);
        Supplier xwSupplier = builder.requires(ManagementWorkerService.SERVICE_NAME);
        Supplier eSupplier = builder.requires(ExternalManagementRequestExecutor.SERVICE_NAME);
        Supplier hafSupplier = httpAuthenticationFactory != null ? builder.requiresCapability("org.wildfly.security.http-authentication-factory", HttpAuthenticationFactory.class, new String[]{httpAuthenticationFactory}) : null;
        final Supplier environment = builder.requires(ServerEnvironment.SERVICE_DESCRIPTOR);
        Supplier<String> consoleSlot = new Supplier<String>(){

            @Override
            public String get() {
                return ((ServerEnvironment)environment.get()).getProductConfig().getConsoleSlot();
            }
        };
        Supplier virtualSecurityDomainSupplier = null;
        Supplier virtualMechanismFactorySupplier = null;
        if (VirtualDomainMarkerUtility.isVirtualDomainRequired(context) && (securityMetaData = (SecurityMetaData)context.getAttachment(SecurityMetaData.OPERATION_CONTEXT_ATTACHMENT_KEY)) instanceof AdvancedSecurityMetaData) {
            virtualSecurityDomainSupplier = builder.requires(securityMetaData.getSecurityDomain());
            virtualMechanismFactorySupplier = builder.requires(((AdvancedSecurityMetaData)securityMetaData).getHttpServerAuthenticationMechanismFactory());
        }
        Supplier scSupplier = sslContext != null ? builder.requiresCapability("org.wildfly.security.ssl-context", SSLContext.class, new String[]{sslContext}) : null;
        UndertowHttpManagementService undertowService = new UndertowHttpManagementService(hmConsumer, lrSupplier, mcSupplier, sbSupplier, ssbSupplier, sbmSupplier, null, null, rpSupplier, xwSupplier, eSupplier, hafSupplier, scSupplier, null, null, commonPolicy.getAllowedOrigins(), consoleMode, consoleSlot, commonPolicy.getConstantHeaders(), caSupplier, virtualSecurityDomainSupplier, virtualMechanismFactorySupplier, commonPolicy.getBacklog(), commonPolicy.getNoRequestTimeoutMs(), commonPolicy.getConnectionHighWater(), commonPolicy.getConnectionLowWater());
        builder.setInstance((Service)undertowService);
        builder.install();
        ServiceName shutdownName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"shutdown"});
        CapabilityServiceBuilder sb = serviceTarget.addService(shutdownName);
        Supplier executorSupplier = sb.requires(Services.JBOSS_SERVER_EXECUTOR);
        Supplier processorSupplier = sb.requires(requestProcessorName);
        Supplier registrySupplier = sb.requires(ManagementChannelRegistryService.SERVICE_NAME);
        sb.requires(UndertowHttpManagementService.SERVICE_NAME);
        sb.setInstance((Service)new HttpShutdownService(executorSupplier, processorSupplier, registrySupplier));
        sb.install();
        if (commonPolicy.isHttpUpgradeEnabled()) {
            String hostName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
            NativeManagementServices.installRemotingServicesIfNotInstalled((ServiceTarget)serviceTarget, hostName, context.getServiceRegistry(false));
            String httpConnectorName = socketBindingName != null || secureSocketBindingName == null ? "http-management" : "https-management";
            String saslAuthFactoryName = commonPolicy.getSaslAuthenticationFactory();
            ServiceName saslAuthenticationFactory = saslAuthFactoryName != null ? context.getCapabilityServiceName("org.wildfly.security.sasl-authentication-factory", saslAuthFactoryName, SaslAuthenticationFactory.class) : null;
            RemotingHttpUpgradeService.installServices((OperationContext)context, (String)"http-management", (String)httpConnectorName, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (OptionMap)commonPolicy.getConnectorOptions(), (ServiceName)saslAuthenticationFactory);
            return Arrays.asList(UndertowHttpManagementService.SERVICE_NAME, RemotingHttpUpgradeService.HTTP_UPGRADE_REGISTRY.append(new String[]{httpConnectorName}));
        }
        return Collections.singletonList(UndertowHttpManagementService.SERVICE_NAME);
    }

    private ConsoleMode consoleMode(boolean consoleEnabled, boolean adminOnly) {
        return consoleEnabled ? (adminOnly ? ConsoleMode.ADMIN_ONLY : ConsoleMode.CONSOLE) : ConsoleMode.NO_CONSOLE;
    }
}

