/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class RestrictedLock
implements Lock {
    private final ReentrantLock wrappedLock;
    private final Condition unrestrictedCondition;
    private volatile Mode lockMode = Mode.UNRESTRICTED;

    static RestrictedLock newInstance(ReentrantLock reentrantLock) {
        return new RestrictedLock(reentrantLock);
    }

    private RestrictedLock(ReentrantLock reentrantLock) {
        this.wrappedLock = reentrantLock;
        this.unrestrictedCondition = reentrantLock.newCondition();
    }

    @Override
    public final void lock() {
        this.wrappedLock.lock();
        while (true) {
            try {
                this.awaitRestrictedModeExit();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public final void lockInterruptibly() throws InterruptedException {
        this.wrappedLock.lockInterruptibly();
        this.awaitRestrictedModeExit();
    }

    @Override
    public final boolean tryLock() {
        if (!this.wrappedLock.tryLock()) {
            return false;
        }
        if (this.lockMode == Mode.RESTRICTED) {
            this.wrappedLock.unlock();
            return false;
        }
        return true;
    }

    @Override
    public final boolean tryLock(long l2, TimeUnit timeUnit) throws InterruptedException {
        if (!this.wrappedLock.tryLock(l2, timeUnit)) {
            return false;
        }
        if (this.lockMode == Mode.RESTRICTED) {
            this.wrappedLock.unlock();
            return false;
        }
        return true;
    }

    @Override
    public final void unlock() {
        this.wrappedLock.unlock();
    }

    @Override
    public final Condition newCondition() {
        return this.wrappedLock.newCondition();
    }

    private final void awaitRestrictedModeExit() throws InterruptedException {
        while (this.lockMode == Mode.RESTRICTED) {
            this.unrestrictedCondition.await();
        }
    }

    final void enterRestrictedMode() {
        this.wrappedLock.lock();
        try {
            this.lockMode = Mode.RESTRICTED;
        }
        finally {
            this.wrappedLock.unlock();
        }
    }

    final void exitRestrictedMode() {
        this.wrappedLock.lock();
        try {
            this.lockMode = Mode.UNRESTRICTED;
            this.unrestrictedCondition.signalAll();
        }
        finally {
            this.wrappedLock.unlock();
        }
    }

    final void runUnrestricted(Runnable runnable) {
        this.callUnrestricted(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T, E extends Exception> T callUnrestricted(UnrestrictedCallable<T, E> unrestrictedCallable) throws E {
        this.wrappedLock.lock();
        if (this.lockMode == Mode.RESTRICTED) {
            this.lockMode = Mode.RESTRICTED_EXECUTING;
            T t2 = unrestrictedCallable.call();
            return t2;
            finally {
                if (this.lockMode == Mode.RESTRICTED_EXECUTING) {
                    this.lockMode = Mode.RESTRICTED;
                }
            }
        }
        T t3 = unrestrictedCallable.call();
        return t3;
        finally {
            this.wrappedLock.unlock();
        }
    }

    @FunctionalInterface
    static interface UnrestrictedCallable<T, E extends Exception> {
        public T call() throws E;
    }

    private static enum Mode {
        UNRESTRICTED,
        RESTRICTED,
        RESTRICTED_EXECUTING;

    }
}

