/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.OffsetDST;
import oracle.sql.TRANSDUMP;
import oracle.sql.ZONEIDMAP;

public class TIMEZONETAB
implements Monitor {
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int BYTE_SIZE = 10;
    private final Hashtable zonetab = new Hashtable();
    private static Map<Integer, TIMEZONETAB> instanceCache = new ConcurrentHashMap<Integer, TIMEZONETAB>(5);
    private int instanceCount = 0;
    private int versionNumber = 0;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();

    private TIMEZONETAB(int n2) {
        this.versionNumber = n2;
    }

    public static TIMEZONETAB getInstance(int n2) throws SQLException {
        TIMEZONETAB tIMEZONETAB = instanceCache.computeIfAbsent(n2, TIMEZONETAB::new);
        return tIMEZONETAB.returnInstance();
    }

    private TIMEZONETAB returnInstance() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            ++this.instanceCount;
            instanceCache.put(this.versionNumber, this);
            TIMEZONETAB tIMEZONETAB = this;
            return tIMEZONETAB;
        }
    }

    public void freeInstance() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            --this.instanceCount;
            if (this.instanceCount < 1) {
                instanceCache.remove(this.versionNumber);
            }
        }
    }

    public void addTrans(Connection connection, byte[] byArray, int n2) throws SQLException {
        int n3;
        int n4;
        int[] nArray = new int[BYTE_SIZE];
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        boolean bl = oracleConnection.isConnectionBigTZTC();
        if (n2 == ZONEIDMAP.getID("GMT") || !bl) {
            n4 = byArray[0] & 0xFF;
            n3 = 1;
        } else {
            n4 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | (byArray[3] & 0xFF) << 0;
            n3 = 4;
        }
        OffsetDST[] offsetDSTArray = new OffsetDST[n4];
        int n5 = 0;
        for (int i2 = n3; i2 < n4 * BYTE_SIZE; i2 += BYTE_SIZE) {
            int n6;
            for (n6 = 0; n6 < BYTE_SIZE; ++n6) {
                nArray[n6] = byArray[n6 + i2] & 0xFF;
            }
            n6 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            calendar.set(1, n6);
            calendar.set(2, nArray[2] - 1);
            calendar.set(5, nArray[3]);
            calendar.set(11, nArray[4] - 1);
            calendar.set(12, nArray[5] - 1);
            calendar.set(13, nArray[6] - 1);
            calendar.set(14, 0);
            long l2 = calendar.getTime().getTime();
            int n7 = (nArray[7] - OFFSET_HOUR) * HOUR_MILLISECOND + (nArray[8] - OFFSET_MINUTE) * MINUTE_MILLISECOND;
            byte by = (byte)nArray[9];
            offsetDSTArray[n5++] = new OffsetDST(new Timestamp(l2), n7, by);
        }
        this.zonetab.put(n2 & 0x1FF, offsetDSTArray);
    }

    public byte getLocalOffset(Calendar calendar, int n2, OffsetDST offsetDST) throws SQLException {
        byte by;
        block13: {
            byte by2;
            byte by3;
            boolean bl = false;
            boolean bl2 = false;
            by = 0;
            Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar calendar3 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar calendar4 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            calendar4.set(1, calendar.get(1));
            calendar4.set(2, calendar.get(2));
            calendar4.set(5, calendar.get(5));
            calendar4.set(11, calendar.get(11));
            calendar4.set(12, calendar.get(12));
            calendar4.set(13, calendar.get(13));
            calendar4.set(14, calendar.get(14));
            Calendar calendar5 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            calendar5.set(1, calendar4.get(1));
            calendar5.set(2, calendar4.get(2));
            calendar5.set(5, 1);
            calendar5.set(11, 0);
            calendar5.set(12, 0);
            calendar5.set(13, 0);
            calendar5.set(14, 0);
            OffsetDST[] offsetDSTArray = this.getOffsetDST(n2);
            int n3 = this.findCloseMatch(offsetDSTArray, calendar5.getTimeInMillis());
            while (true) {
                calendar2.setTime(offsetDSTArray[n3].getTimestamp());
                int n4 = offsetDSTArray[n3].getOFFSET();
                calendar2.add(10, n4 / HOUR_MILLISECOND);
                calendar2.add(12, n4 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                by3 = offsetDSTArray[n3].getDSTFLAG();
                if (calendar4.equals(calendar2)) {
                    offsetDST.setOFFSET(offsetDSTArray[n3].getOFFSET());
                    offsetDST.setDSTFLAG(offsetDSTArray[n3].getDSTFLAG());
                    by = 0;
                    if (n3 > 0) {
                        by2 = offsetDSTArray[n3 - 1].getDSTFLAG();
                        if (by3 == 0 && by2 == 1) {
                            by = 1;
                        }
                    }
                    break block13;
                }
                if (calendar4.before(calendar2)) {
                    if (n3 == 0) {
                        offsetDST.setOFFSET(0);
                        offsetDST.setDSTFLAG((byte)0);
                        by = 0;
                        if (by3 == 1) {
                            calendar2.add(10, -1);
                            if (!calendar4.before(calendar2)) {
                                throw new SQLException("Illegal local time.");
                            }
                        }
                        break block13;
                    }
                    if (--n3 < 0) continue;
                    by2 = offsetDSTArray[n3].getDSTFLAG();
                    if (by3 != 1 || by2 != 0) continue;
                    calendar2.add(10, -1);
                    if (calendar4.before(calendar2)) continue;
                    throw new SQLException("Illegal local time.");
                }
                if (n3 == offsetDSTArray.length - 1) break;
                calendar3.setTime(offsetDSTArray[n3 + 1].getTimestamp());
                int n5 = offsetDSTArray[n3 + 1].getOFFSET();
                calendar3.add(10, n5 / HOUR_MILLISECOND);
                calendar3.add(12, n5 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                if (calendar4.before(calendar3)) break;
                ++n3;
            }
            offsetDST.setOFFSET(offsetDSTArray[n3].getOFFSET());
            offsetDST.setDSTFLAG(offsetDSTArray[n3].getDSTFLAG());
            by = 0;
            if (by3 == 0) {
                if (n3 > 0 && (by2 = offsetDSTArray[n3 - 1].getDSTFLAG()) == 1) {
                    calendar2.add(10, 1);
                    if (calendar4.before(calendar2)) {
                        by = 1;
                    }
                }
                if (n3 != offsetDSTArray.length - 1 && (by2 = offsetDSTArray[n3 + 1].getDSTFLAG()) == 1) {
                    calendar3.add(10, -1);
                    if (!calendar4.before(calendar3)) {
                        throw new SQLException("Illegal local time.");
                    }
                }
            }
        }
        return by;
    }

    public int getOffset(Calendar calendar, int n2) throws SQLException {
        OffsetDST[] offsetDSTArray = this.getOffsetDST(n2);
        return this.getOffset(calendar, offsetDSTArray);
    }

    public int getOffset(long l2, int n2) throws SQLException {
        OffsetDST[] offsetDSTArray = this.getOffsetDST(n2);
        int n3 = this.findCloseMatch(offsetDSTArray, l2);
        return offsetDSTArray[n3].getOFFSET();
    }

    public int getOffset(Calendar calendar, OffsetDST[] offsetDSTArray) throws SQLException {
        boolean bl = false;
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        int n2 = this.findCloseMatch(offsetDSTArray, timestamp.getTime());
        return offsetDSTArray[n2].getOFFSET();
    }

    public boolean isDST(Calendar calendar, OffsetDST[] offsetDSTArray) throws SQLException {
        boolean bl = false;
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        int n2 = this.findCloseMatch(offsetDSTArray, timestamp.getTime());
        return offsetDSTArray[n2].getDSTFLAG() == 1;
    }

    public OffsetDST[] getOffsetDST(int n2) {
        OffsetDST[] offsetDSTArray = (OffsetDST[])this.zonetab.get(n2 & 0x1FF);
        return offsetDSTArray;
    }

    final int findCloseMatch(OffsetDST[] offsetDSTArray, long l2) {
        int n2;
        int n3 = offsetDSTArray.length;
        int n4 = 0;
        int n5 = n2 = n3 / 2;
        if (l2 < offsetDSTArray[n4].getTime()) {
            int n6;
            for (n6 = 0; n6 < offsetDSTArray.length && offsetDSTArray[n6].getDSTFLAG() == 1; ++n6) {
            }
            return n6 < offsetDSTArray.length ? n6 : 0;
        }
        while (n2 > 0) {
            if (l2 > offsetDSTArray[n2].getTime()) {
                n4 = n2;
            } else if (l2 < offsetDSTArray[n2].getTime()) {
                n3 = n2;
            } else if (n2 == n4) break;
            n2 = n4 + (n3 - n4) / 2;
            if (n5 == n2) break;
            n5 = n2;
        }
        return n2;
    }

    public void displayTable(int n2) {
        OffsetDST[] offsetDSTArray = this.getOffsetDST(n2);
        if (offsetDSTArray == null) {
            return;
        }
        for (OffsetDST offsetDST : offsetDSTArray) {
            System.out.print(offsetDST.getTimestamp().toString());
            System.out.print("    " + offsetDST.getOFFSET());
            System.out.println("    " + offsetDST.getDSTFLAG());
        }
    }

    public boolean checkID(int n2) {
        return this.zonetab.get(n2 & 0x1FF) == null;
    }

    public void updateTable(Connection connection, int n2) throws SQLException, NullPointerException {
        byte[] byArray = TRANSDUMP.getTransitions(connection, n2);
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.addTrans(connection, byArray, n2);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

