/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonServerOptions;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.SCRAMServerSASL;
import org.apache.activemq.artemis.spi.core.security.scram.SCRAM;
import org.apache.activemq.artemis.spi.core.security.scram.ScramUtils;
import org.apache.activemq.artemis.spi.core.security.scram.UserData;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.integration.amqp.connect.MockServer;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AMQPConnectSaslTest
extends AmqpClientTestSupport {
    private static final int BROKER_PORT_NUM = 5673;
    private static final String SERVER_KEYSTORE_NAME = "server-keystore.jks";
    private static final String SERVER_KEYSTORE_PASSWORD = "securepass";
    private static final String CLIENT_KEYSTORE_NAME = "client-keystore.jks";
    private static final String CLIENT_KEYSTORE_PASSWORD = "securepass";
    private static final String SERVER_TRUSTSTORE_NAME = "server-ca-truststore.jks";
    private static final String SERVER_TRUSTSTORE_PASSWORD = "securepass";
    private static final String CLIENT_TRUSTSTORE_NAME = "client-ca-truststore.jks";
    private static final String CLIENT_TRUSTSTORE_PASSWORD = "securepass";
    private static final String USER = "MY_USER";
    private static final String PASSWD = "PASSWD_VALUE";
    private static final String PLAIN = "PLAIN";
    private static final String ANONYMOUS = "ANONYMOUS";
    private static final String EXTERNAL = "EXTERNAL";
    private Vertx vertx;
    private MockServer mockServer;

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5673, false);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.vertx = Vertx.vertx();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            if (this.mockServer != null) {
                this.mockServer.close();
            }
            CountDownLatch closeLatch = new CountDownLatch(1);
            this.vertx.close(x -> closeLatch.countDown());
            AMQPConnectSaslTest.assertTrue((String)"Vert.x instant not closed in alotted time", (boolean)closeLatch.await(5L, TimeUnit.SECONDS));
        }
    }

    @Test(timeout=20000L)
    public void testConnectsWithAnonymous() throws Exception {
        CountDownLatch serverConnectionOpen = new CountDownLatch(1);
        TestAuthenticator authenticator = new TestAuthenticator(true, PLAIN, ANONYMOUS);
        this.mockServer = new MockServer(this.vertx, () -> authenticator, (Handler<ProtonConnection>)((Handler)serverConnection -> serverConnection.openHandler(serverSender -> {
            serverConnectionOpen.countDown();
            serverConnection.closeHandler(x -> serverConnection.close());
            serverConnection.open();
        })));
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("testSimpleConnect", "tcp://localhost:" + this.mockServer.actualPort());
        amqpConnection.setReconnectAttempts(0);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        boolean awaitConnectionOpen = serverConnectionOpen.await(10L, TimeUnit.SECONDS);
        AMQPConnectSaslTest.assertTrue((String)"Broker did not open connection in alotted time", (boolean)awaitConnectionOpen);
        AMQPConnectSaslTest.assertEquals((Object)ANONYMOUS, (Object)authenticator.getChosenMech());
        AMQPConnectSaslTest.assertArrayEquals((byte[])new byte[0], (byte[])authenticator.getInitialResponse());
    }

    @Test(timeout=20000L)
    public void testConnectsWithPlain() throws Exception {
        CountDownLatch serverConnectionOpen = new CountDownLatch(1);
        TestAuthenticator authenticator = new TestAuthenticator(true, PLAIN, ANONYMOUS);
        this.mockServer = new MockServer(this.vertx, () -> authenticator, (Handler<ProtonConnection>)((Handler)serverConnection -> serverConnection.openHandler(serverSender -> {
            serverConnectionOpen.countDown();
            serverConnection.closeHandler(x -> serverConnection.close());
            serverConnection.open();
        })));
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("testSimpleConnect", "tcp://localhost:" + this.mockServer.actualPort());
        amqpConnection.setReconnectAttempts(0);
        amqpConnection.setUser(USER);
        amqpConnection.setPassword(PASSWD);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        boolean awaitConnectionOpen = serverConnectionOpen.await(10L, TimeUnit.SECONDS);
        AMQPConnectSaslTest.assertTrue((String)"Broker did not open connection in alotted time", (boolean)awaitConnectionOpen);
        AMQPConnectSaslTest.assertEquals((Object)PLAIN, (Object)authenticator.getChosenMech());
        AMQPConnectSaslTest.assertArrayEquals((byte[])AMQPConnectSaslTest.expectedPlainInitialResponse(USER, PASSWD), (byte[])authenticator.getInitialResponse());
    }

    @Test(timeout=200000L)
    public void testConnectsWithSCRAM() throws Exception {
        CountDownLatch serverConnectionOpen = new CountDownLatch(1);
        SCRAMTestAuthenticator authenticator = new SCRAMTestAuthenticator(SCRAM.SHA512);
        this.mockServer = new MockServer(this.vertx, () -> authenticator, (Handler<ProtonConnection>)((Handler)serverConnection -> serverConnection.openHandler(serverSender -> {
            serverConnectionOpen.countDown();
            serverConnection.closeHandler(x -> serverConnection.close());
            serverConnection.open();
        })));
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("testSScramConnect", "tcp://localhost:" + this.mockServer.actualPort());
        amqpConnection.setReconnectAttempts(0);
        amqpConnection.setUser(USER);
        amqpConnection.setPassword(PASSWD);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        boolean awaitConnectionOpen = serverConnectionOpen.await(10L, TimeUnit.SECONDS);
        AMQPConnectSaslTest.assertTrue((String)"Broker did not open connection in alotted time", (boolean)awaitConnectionOpen);
        AMQPConnectSaslTest.assertEquals((Object)SCRAM.SHA512.getName(), (Object)authenticator.chosenMech);
        AMQPConnectSaslTest.assertTrue((boolean)authenticator.succeeded());
    }

    @Test(timeout=20000L)
    public void testConnectsWithExternal() throws Exception {
        this.doConnectWithExternalTestImpl(true);
    }

    @Test(timeout=20000L)
    public void testExternalIgnoredWhenNoClientCertSupplied() throws Exception {
        this.doConnectWithExternalTestImpl(false);
    }

    private void doConnectWithExternalTestImpl(boolean requireClientCert) throws ExecutionException, InterruptedException, Exception {
        CountDownLatch serverConnectionOpen = new CountDownLatch(1);
        TestAuthenticator authenticator = new TestAuthenticator(true, EXTERNAL, PLAIN);
        String keyStorePath = ((Object)((Object)this)).getClass().getClassLoader().getResource(SERVER_KEYSTORE_NAME).getFile();
        JksOptions jksKeyStoreOptions = new JksOptions().setPath(keyStorePath).setPassword("securepass");
        ProtonServerOptions serverOptions = new ProtonServerOptions();
        serverOptions.setSsl(true);
        serverOptions.setKeyStoreOptions(jksKeyStoreOptions);
        if (requireClientCert) {
            String trustStorePath = ((Object)((Object)this)).getClass().getClassLoader().getResource(CLIENT_TRUSTSTORE_NAME).getFile();
            JksOptions jksTrustStoreOptions = new JksOptions().setPath(trustStorePath).setPassword("securepass");
            serverOptions.setTrustStoreOptions(jksTrustStoreOptions);
            serverOptions.setClientAuth(ClientAuth.REQUIRED);
        }
        this.mockServer = new MockServer(this.vertx, serverOptions, () -> authenticator, (Handler<ProtonConnection>)((Handler)serverConnection -> serverConnection.openHandler(serverSender -> {
            serverConnectionOpen.countDown();
            serverConnection.closeHandler(x -> serverConnection.close());
            serverConnection.open();
        })));
        String amqpServerConnectionURI = "tcp://localhost:" + this.mockServer.actualPort() + "?sslEnabled=true;trustStorePath=" + SERVER_TRUSTSTORE_NAME + ";trustStorePassword=" + "securepass";
        if (requireClientCert) {
            amqpServerConnectionURI = amqpServerConnectionURI + ";keyStorePath=client-keystore.jks;keyStorePassword=securepass";
        }
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("testSimpleConnect", amqpServerConnectionURI);
        amqpConnection.setReconnectAttempts(0);
        amqpConnection.setUser(USER);
        amqpConnection.setPassword(PASSWD);
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        boolean awaitConnectionOpen = serverConnectionOpen.await(10L, TimeUnit.SECONDS);
        AMQPConnectSaslTest.assertTrue((String)"Broker did not open connection in alotted time", (boolean)awaitConnectionOpen);
        if (requireClientCert) {
            AMQPConnectSaslTest.assertEquals((Object)EXTERNAL, (Object)authenticator.getChosenMech());
            AMQPConnectSaslTest.assertArrayEquals((byte[])new byte[0], (byte[])authenticator.getInitialResponse());
        } else {
            AMQPConnectSaslTest.assertEquals((Object)PLAIN, (Object)authenticator.getChosenMech());
            AMQPConnectSaslTest.assertArrayEquals((byte[])AMQPConnectSaslTest.expectedPlainInitialResponse(USER, PASSWD), (byte[])authenticator.getInitialResponse());
        }
    }

    private static byte[] expectedPlainInitialResponse(String username, String password) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        if (username.isEmpty() || password.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least 1 character in user and pass");
        }
        byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[usernameBytes.length + passwordBytes.length + 2];
        System.arraycopy(usernameBytes, 0, data, 1, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, data, 2 + usernameBytes.length, passwordBytes.length);
        return data;
    }

    private static final class TestSCRAMServerSASL
    extends SCRAMServerSASL {
        private Exception e;

        TestSCRAMServerSASL(SCRAM mechanism) throws NoSuchAlgorithmException {
            super(mechanism);
        }

        public void done() {
        }

        protected UserData aquireUserData(String userName) throws LoginException {
            if (!AMQPConnectSaslTest.USER.equals(userName)) {
                throw new LoginException("invalid username");
            }
            byte[] salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            try {
                MessageDigest digest = MessageDigest.getInstance(this.mechanism.getDigest());
                Mac hmac = Mac.getInstance(this.mechanism.getHmac());
                ScramUtils.NewPasswordStringData data = ScramUtils.byteArrayToStringData((ScramUtils.NewPasswordByteArrayData)ScramUtils.newPassword((String)AMQPConnectSaslTest.PASSWD, (byte[])salt, (int)4096, (MessageDigest)digest, (Mac)hmac));
                return new UserData(data.salt, data.iterations, data.serverKey, data.storedKey);
            }
            catch (Exception e) {
                throw new LoginException(e.getMessage());
            }
        }

        protected void failed(Exception e) {
            this.e = e;
        }
    }

    private static final class SCRAMTestAuthenticator
    implements ProtonSaslAuthenticator {
        private final SCRAM mech;
        private Sasl sasl;
        private TestSCRAMServerSASL serverSASL;
        private String chosenMech;

        SCRAMTestAuthenticator(SCRAM mech) {
            this.mech = mech;
        }

        public void init(NetSocket socket, ProtonConnection protonConnection, Transport transport) {
            this.sasl = transport.sasl();
            this.sasl.server();
            this.sasl.allowSkip(false);
            this.sasl.setMechanisms(new String[]{this.mech.getName(), AMQPConnectSaslTest.PLAIN, AMQPConnectSaslTest.ANONYMOUS});
            try {
                this.serverSASL = new TestSCRAMServerSASL(this.mech);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void process(Handler<Boolean> completionHandler) {
            boolean ended;
            String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
            int pending = this.sasl.pending();
            if (remoteMechanisms.length == 0 || pending == 0) {
                completionHandler.handle((Object)false);
                return;
            }
            this.chosenMech = remoteMechanisms[0];
            byte[] msg = new byte[pending];
            this.sasl.recv(msg, 0, msg.length);
            byte[] result = this.serverSASL.processSASL(msg);
            if (result != null) {
                this.sasl.send(result, 0, result.length);
            }
            if (ended = this.serverSASL.isEnded()) {
                if (this.succeeded()) {
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                } else {
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
                }
                completionHandler.handle((Object)true);
            } else {
                completionHandler.handle((Object)false);
            }
        }

        public boolean succeeded() {
            SASLResult result = this.serverSASL.result();
            return result != null && result.isSuccess() && this.serverSASL.e == null;
        }
    }

    private static final class TestAuthenticator
    implements ProtonSaslAuthenticator {
        private Sasl sasl;
        private final boolean succeed;
        private final String[] offeredMechs;
        String chosenMech = null;
        byte[] initialResponse = null;
        boolean done = false;

        TestAuthenticator(boolean succeed, String ... offeredMechs) {
            if (offeredMechs.length == 0) {
                throw new IllegalArgumentException("Must provide at least 1 mechanism to offer");
            }
            this.offeredMechs = offeredMechs;
            this.succeed = succeed;
        }

        public void init(NetSocket socket, ProtonConnection protonConnection, Transport transport) {
            this.sasl = transport.sasl();
            this.sasl.server();
            this.sasl.allowSkip(false);
            this.sasl.setMechanisms(this.offeredMechs);
        }

        public void process(Handler<Boolean> processComplete) {
            String[] remoteMechanisms;
            if (!this.done && (remoteMechanisms = this.sasl.getRemoteMechanisms()).length > 0) {
                this.chosenMech = remoteMechanisms[0];
                this.initialResponse = new byte[this.sasl.pending()];
                this.sasl.recv(this.initialResponse, 0, this.initialResponse.length);
                if (this.succeed) {
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                } else {
                    this.sasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
                }
                this.done = true;
            }
            processComplete.handle((Object)this.done);
        }

        public boolean succeeded() {
            return this.succeed;
        }

        public String getChosenMech() {
            return this.chosenMech;
        }

        public byte[] getInitialResponse() {
            return this.initialResponse;
        }
    }
}

