/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class AutoDeleteCreatedQueueTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString queueA = new SimpleString("queueA");
    public final SimpleString queueConfigurationManaged = new SimpleString("queueConfigurationManaged");
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.getConfiguration().setAddressQueueScanPeriod(500L);
        this.server.getConfiguration().setMessageExpiryScanPeriod(500L);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testAutoDeleteCreatedQueueOnLastConsumerClose() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteCreatedQueues(Boolean.valueOf(true)));
        this.server.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(false)));
        AutoDeleteCreatedQueueTest.assertNotNull((Object)this.server.locateQueue(this.queueA));
        AutoDeleteCreatedQueueTest.assertTrue((boolean)this.server.locateQueue(this.queueA).isAutoDelete());
        this.cf.createSession().createConsumer(this.queueA).close();
        Wait.assertTrue(() -> this.server.locateQueue(this.queueA) == null);
    }

    @Test
    public void testAutoDeleteCreatedQueueDoesNOTDeleteConfigurationManagedQueuesOnLastConsumerClose() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteCreatedQueues(Boolean.valueOf(true)));
        this.server.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.MULTICAST).setAutoCreated(Boolean.valueOf(false)));
        this.server.createQueue(new QueueConfiguration(this.queueConfigurationManaged).setAddress(this.addressA).setRoutingType(RoutingType.MULTICAST).setAutoCreated(Boolean.valueOf(false)).setConfigurationManaged(Boolean.valueOf(true)));
        AutoDeleteCreatedQueueTest.assertNotNull((Object)this.server.locateQueue(this.queueA));
        AutoDeleteCreatedQueueTest.assertNotNull((Object)this.server.locateQueue(this.queueConfigurationManaged));
        AutoDeleteCreatedQueueTest.assertTrue((boolean)this.server.locateQueue(this.queueA).isAutoDelete());
        AutoDeleteCreatedQueueTest.assertFalse((boolean)this.server.locateQueue(this.queueConfigurationManaged).isAutoDelete());
        this.cf.createSession().createConsumer(this.queueA).close();
        this.cf.createSession().createConsumer(this.queueConfigurationManaged).close();
        Wait.assertTrue(() -> this.server.locateQueue(this.queueA) == null);
        AutoDeleteCreatedQueueTest.assertNotNull((Object)this.server.locateQueue(this.queueConfigurationManaged));
    }
}

