/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class MessageConsumerRollbackTest
extends ActiveMQTestBase {
    ActiveMQServer server;
    ServerLocator locator;
    ClientSessionFactory sf;
    private static final String inQueue = "inqueue";
    private static final String outQueue = "outQueue";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        AddressSettings settings = new AddressSettings().setRedeliveryDelay(100L);
        this.server.getConfiguration().getAddressesSettings().put("#", settings);
        this.server.start();
        this.locator = this.createNettyNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createTransactedSession();
        session.createQueue(new QueueConfiguration(inQueue));
        session.createQueue(new QueueConfiguration(outQueue));
        session.close();
    }

    @Test
    public void testRollbackMultipleConsumers() throws Exception {
        int i;
        int numberOfMessages = 3000;
        int numberOfConsumers = 10;
        ClientSession session = this.sf.createTransactedSession();
        this.sendMessages(numberOfMessages, session);
        AtomicInteger count = new AtomicInteger(0);
        CountDownLatch commitLatch = new CountDownLatch(numberOfMessages);
        LocalConsumer[] consumers = new LocalConsumer[numberOfConsumers];
        for (int i2 = 0; i2 < numberOfConsumers; ++i2) {
            consumers[i2] = new LocalConsumer(count, commitLatch);
            consumers[i2].start();
        }
        commitLatch.await(2L, TimeUnit.MINUTES);
        for (LocalConsumer consumer : consumers) {
            consumer.stop();
        }
        ClientConsumer consumer = session.createConsumer(outQueue);
        session.start();
        HashSet<Integer> values = new HashSet<Integer>();
        for (i = 0; i < numberOfMessages; ++i) {
            ClientMessage msg = consumer.receive(1000L);
            MessageConsumerRollbackTest.assertNotNull((Object)msg);
            int value = msg.getIntProperty("out_msg");
            msg.acknowledge();
            MessageConsumerRollbackTest.assertFalse((String)("msg " + value + " received in duplicate"), (boolean)values.contains(value));
            values.add(value);
        }
        MessageConsumerRollbackTest.assertNull((Object)consumer.receiveImmediate());
        for (i = 0; i < numberOfMessages; ++i) {
            MessageConsumerRollbackTest.assertTrue((boolean)values.contains(i));
        }
        MessageConsumerRollbackTest.assertEquals((long)numberOfMessages, (long)values.size());
        session.close();
    }

    private void sendMessages(int numberOfMessages, ClientSession session) throws Exception {
        ClientProducer producer = session.createProducer(inQueue);
        for (int i = 0; i < numberOfMessages; ++i) {
            ActiveMQTextMessage txt = new ActiveMQTextMessage(session);
            txt.setIntProperty("msg", i);
            txt.setText("Message Number (" + i + ")");
            txt.doBeforeSend();
            producer.send((Message)txt.getCoreMessage());
        }
        session.commit();
    }

    private class LocalConsumer
    implements MessageHandler {
        boolean rollbackFirstMessage = true;
        ServerLocator consumerLocator;
        ClientSessionFactory factoryLocator;
        ClientSession session;
        ClientConsumer consumer;
        ClientProducer producer;
        AtomicInteger counter;
        CountDownLatch commitLatch;

        private LocalConsumer(AtomicInteger counter, CountDownLatch commitLatch) {
            this.counter = counter;
            this.commitLatch = commitLatch;
        }

        public void stop() throws Exception {
            this.session.close();
            this.factoryLocator.close();
            this.consumerLocator.close();
        }

        public void start() throws Exception {
            this.consumerLocator = MessageConsumerRollbackTest.this.createNettyNonHALocator();
            this.factoryLocator = MessageConsumerRollbackTest.this.createSessionFactory(this.consumerLocator);
            this.session = this.factoryLocator.createTransactedSession();
            this.consumer = this.session.createConsumer(MessageConsumerRollbackTest.inQueue);
            this.producer = this.session.createProducer(MessageConsumerRollbackTest.outQueue);
            this.consumer.setMessageHandler((MessageHandler)this);
            this.session.start();
        }

        public void onMessage(ClientMessage message) {
            try {
                message.acknowledge();
                ClientMessage outmsg = this.session.createMessage(true);
                outmsg.putIntProperty("out_msg", message.getIntProperty("msg").intValue());
                this.producer.send((Message)outmsg);
                if (this.rollbackFirstMessage) {
                    this.session.rollback();
                    this.rollbackFirstMessage = false;
                    return;
                }
                if (this.counter.incrementAndGet() % 200 == 0) {
                    this.session.rollback();
                } else {
                    this.commitLatch.countDown();
                    this.session.commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.session.rollback();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }
    }
}

