/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RetroactiveAddressTest
extends ActiveMQTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(2);
    protected ActiveMQServer server;
    protected ClientSession session;
    protected ClientSessionFactory sf;
    protected ServerLocator locator;
    String internalNamingPrefix;
    char delimiterChar;
    String delimiter;

    @Parameterized.Parameters(name="delimiterChar={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({Character.valueOf('/')}, {Character.valueOf('.')});
    }

    public RetroactiveAddressTest(char delimiterChar) {
        this.delimiterChar = delimiterChar;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, this.createDefaultInVMConfig());
        this.server.getConfiguration().setInternalNamingPrefix("$.artemis.internal.".replace('.', this.delimiterChar));
        this.server.getConfiguration().getWildcardConfiguration().setDelimiter(this.delimiterChar);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
        this.internalNamingPrefix = this.server.getConfiguration().getInternalNamingPrefix();
        this.delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString();
    }

    @Test
    public void testRetroactiveResourceCreationWithExactMatch() throws Exception {
        this.internalTestRetroactiveResourceCreation("myAddress", "myAddress");
    }

    @Test
    public void testRetroactiveResourceCreationWithWildcardMatch() throws Exception {
        this.internalTestRetroactiveResourceCreation("myAddress", "#");
    }

    private void internalTestRetroactiveResourceCreation(String address, String match) throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)address);
        SimpleString divertAddress = ResourceNames.getRetroactiveResourceAddressName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName);
        SimpleString divertMulticastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        SimpleString divertAnycastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.ANYCAST);
        SimpleString divert = ResourceNames.getRetroactiveResourceDivertName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName);
        this.server.getAddressSettingsRepository().addMatch(match, (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        RetroactiveAddressTest.assertNotNull((Object)this.server.getAddressInfo(divertAddress));
        RetroactiveAddressTest.assertNotNull((Object)this.server.locateQueue(divertMulticastQueue));
        RetroactiveAddressTest.assertEquals((Object)RoutingType.MULTICAST, (Object)this.server.locateQueue(divertMulticastQueue).getRoutingType());
        RetroactiveAddressTest.assertNotNull((Object)this.server.locateQueue(divertAnycastQueue));
        RetroactiveAddressTest.assertEquals((Object)RoutingType.ANYCAST, (Object)this.server.locateQueue(divertAnycastQueue).getRoutingType());
        RetroactiveAddressTest.assertNotNull((Object)this.server.getPostOffice().getBinding(divert));
    }

    @Test
    public void testRetroactiveResourceRemoval() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertAddress = ResourceNames.getRetroactiveResourceAddressName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName);
        SimpleString divertMulticastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        SimpleString divertAnycastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.ANYCAST);
        SimpleString divert = ResourceNames.getRetroactiveResourceDivertName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        RetroactiveAddressTest.assertNotNull((Object)this.server.getAddressInfo(divertAddress));
        RetroactiveAddressTest.assertNotNull((Object)this.server.locateQueue(divertMulticastQueue));
        RetroactiveAddressTest.assertNotNull((Object)this.server.locateQueue(divertAnycastQueue));
        RetroactiveAddressTest.assertNotNull((Object)this.server.getPostOffice().getBinding(divert));
        this.server.removeAddressInfo(addressName, null, true);
        RetroactiveAddressTest.assertNull((Object)this.server.getAddressInfo(divertAddress));
        RetroactiveAddressTest.assertNull((Object)this.server.locateQueue(divertAnycastQueue));
        RetroactiveAddressTest.assertNull((Object)this.server.locateQueue(divertMulticastQueue));
        RetroactiveAddressTest.assertNull((Object)this.server.getPostOffice().getBinding(divert));
    }

    @Test
    public void testRetroactiveAddress() throws Exception {
        int COUNT = 15;
        int LOOPS = 25;
        SimpleString queueName = SimpleString.toSimpleString((String)"simpleQueue");
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(15L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        for (int i = 0; i < 25; ++i) {
            ClientProducer producer = this.session.createProducer(addressName);
            for (int j = 0; j < 15; ++j) {
                ClientMessage message = this.session.createMessage(false);
                message.putIntProperty("xxx", i * 15 + j);
                producer.send((org.apache.activemq.artemis.api.core.Message)message);
            }
            producer.close();
            int finalI = i;
            Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessagesReplaced() == (long)(15 * finalI));
            Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessageCount() == 15L);
            this.session.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
            Wait.assertTrue(() -> this.server.locateQueue(queueName) != null);
            Wait.assertTrue(() -> this.server.locateQueue(queueName).getMessageCount() == 15L);
            ClientConsumer consumer = this.session.createConsumer(queueName);
            for (int j = 0; j < 15; ++j) {
                this.session.start();
                ClientMessage message = consumer.receive(1000L);
                RetroactiveAddressTest.assertNotNull((Object)message);
                message.acknowledge();
                RetroactiveAddressTest.assertEquals((long)(i * 15 + j), (long)message.getIntProperty("xxx").intValue());
            }
            consumer.close();
            this.session.deleteQueue(queueName);
        }
    }

    @Test
    public void testRestart() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        SimpleString queueName1 = SimpleString.toSimpleString((String)"simpleQueue1");
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertMulticastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        ClientProducer producer = this.session.createProducer(addressName);
        ClientMessage message = this.session.createMessage(true);
        message.getBodyBuffer().writeString(data + "1");
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.close();
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getMessageCount() == 1L);
        this.server.stop();
        this.server.start();
        RetroactiveAddressTest.assertNotNull((Object)this.server.locateQueue(divertMulticastQueue));
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getMessageCount() == 1L);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
        producer = this.session.createProducer(addressName);
        message = this.session.createMessage(true);
        message.getBodyBuffer().writeString(data + "2");
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.close();
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getMessageCount() == 2L);
        this.session.createQueue(new QueueConfiguration(queueName1).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server.locateQueue(queueName1) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueName1).getMessageCount() == 2L);
        ClientConsumer consumer = this.session.createConsumer(queueName1);
        this.session.start();
        message = consumer.receive(1000L);
        RetroactiveAddressTest.assertNotNull((Object)message);
        message.acknowledge();
        RetroactiveAddressTest.assertEquals((Object)(data + "1"), (Object)message.getBodyBuffer().readString());
        message = consumer.receive(1000L);
        RetroactiveAddressTest.assertNotNull((Object)message);
        message.acknowledge();
        RetroactiveAddressTest.assertEquals((Object)(data + "2"), (Object)message.getBodyBuffer().readString());
        consumer.close();
        Wait.assertTrue(() -> this.server.locateQueue(queueName1).getMessageCount() == 0L);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getMessageCount() == 2L);
    }

    @Test
    public void testUpdateAfterRestart() throws Exception {
        int COUNT = 10;
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertAnycastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.ANYCAST);
        SimpleString divertMulticastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        Wait.assertTrue(() -> this.server.locateQueue(divertAnycastQueue).getRingSize() == 10L);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getRingSize() == 10L);
        this.server.stop();
        this.server.start();
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(20L));
        Wait.assertTrue(() -> this.server.locateQueue(divertAnycastQueue).getRingSize() == 20L);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getRingSize() == 20L);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        Wait.assertTrue(() -> this.server.locateQueue(divertAnycastQueue).getRingSize() == 10L);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getRingSize() == 10L);
    }

    @Test
    public void testMulticast() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        SimpleString queueName1 = SimpleString.toSimpleString((String)"simpleQueue1");
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        ClientProducer producer = this.session.createProducer(addressName);
        ClientMessage message = this.session.createMessage(false);
        message.getBodyBuffer().writeString(data);
        message.setRoutingType(RoutingType.MULTICAST);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.close();
        Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessageCount() == 1L);
        this.session.createQueue(new QueueConfiguration(queueName1).setAddress(addressName));
        Wait.assertTrue(() -> this.server.locateQueue(queueName1) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueName1).getMessageCount() == 1L);
        ClientConsumer consumer = this.session.createConsumer(queueName1);
        this.session.start();
        message = consumer.receive(1000L);
        RetroactiveAddressTest.assertNotNull((Object)message);
        message.acknowledge();
        RetroactiveAddressTest.assertEquals((Object)data, (Object)message.getBodyBuffer().readString());
        consumer.close();
        Wait.assertTrue(() -> this.server.locateQueue(queueName1).getMessageCount() == 0L);
        Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessageCount() == 1L);
    }

    @Test
    public void testJMSTopicSubscribers() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        int COUNT = 10;
        SimpleString divertQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        Connection c = cf.createConnection();
        Session s = c.createSession();
        Topic t = s.createTopic(addressName.toString());
        MessageProducer producer = s.createProducer((Destination)t);
        for (int i = 0; i < 20; ++i) {
            Message m = s.createMessage();
            m.setIntProperty("test", i);
            producer.send(m);
        }
        producer.close();
        Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessageCount() == 10L);
        MessageConsumer consumer = s.createConsumer((Destination)t);
        c.start();
        for (int i = 0; i < 10; ++i) {
            Message m = consumer.receive(500L);
            RetroactiveAddressTest.assertNotNull((Object)m);
            RetroactiveAddressTest.assertEquals((long)(i + 10), (long)m.getIntProperty("test"));
        }
        RetroactiveAddressTest.assertNull((Object)consumer.receiveNoWait());
    }

    @Test
    public void testUpdateAddressSettings() throws Exception {
        int COUNT = 10;
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertAnycastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.ANYCAST);
        SimpleString divertMulticastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(20L));
        Wait.assertTrue(() -> this.server.locateQueue(divertAnycastQueue).getRingSize() == 20L);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getRingSize() == 20L);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        Wait.assertTrue(() -> this.server.locateQueue(divertAnycastQueue).getRingSize() == 10L);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getRingSize() == 10L);
    }

    @Test
    public void testRoutingTypes() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        SimpleString multicastQueue = SimpleString.toSimpleString((String)"multicastQueue");
        SimpleString anycastQueue = SimpleString.toSimpleString((String)"anycastQueue");
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertMulticastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        SimpleString divertAnycastQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.ANYCAST);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        ClientProducer producer = this.session.createProducer(addressName);
        ClientMessage message = this.session.createMessage(false);
        message.getBodyBuffer().writeString(data + RoutingType.MULTICAST.toString());
        message.setRoutingType(RoutingType.MULTICAST);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getMessageCount() == 1L);
        Wait.assertTrue(() -> this.server.locateQueue(divertAnycastQueue).getMessageCount() == 0L);
        message = this.session.createMessage(false);
        message.getBodyBuffer().writeString(data + RoutingType.ANYCAST.toString());
        message.setRoutingType(RoutingType.ANYCAST);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getMessageCount() == 1L);
        Wait.assertTrue(() -> this.server.locateQueue(divertAnycastQueue).getMessageCount() == 1L);
        producer.close();
        this.session.createQueue(new QueueConfiguration(multicastQueue).setAddress(addressName));
        Wait.assertTrue(() -> this.server.locateQueue(multicastQueue) != null);
        Wait.assertTrue(() -> this.server.locateQueue(multicastQueue).getMessageCount() == 1L);
        this.session.createQueue(new QueueConfiguration(anycastQueue).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server.locateQueue(anycastQueue) != null);
        Wait.assertTrue(() -> this.server.locateQueue(anycastQueue).getMessageCount() == 1L);
        ClientConsumer consumer = this.session.createConsumer(multicastQueue);
        this.session.start();
        message = consumer.receive(1000L);
        RetroactiveAddressTest.assertNotNull((Object)message);
        message.acknowledge();
        RetroactiveAddressTest.assertEquals((Object)(data + RoutingType.MULTICAST.toString()), (Object)message.getBodyBuffer().readString());
        consumer.close();
        Wait.assertTrue(() -> this.server.locateQueue(multicastQueue).getMessageCount() == 0L);
        Wait.assertTrue(() -> this.server.locateQueue(divertMulticastQueue).getMessageCount() == 1L);
        consumer.close();
        consumer = this.session.createConsumer(anycastQueue);
        this.session.start();
        message = consumer.receive(1000L);
        RetroactiveAddressTest.assertNotNull((Object)message);
        message.acknowledge();
        RetroactiveAddressTest.assertEquals((Object)(data + RoutingType.ANYCAST.toString()), (Object)message.getBodyBuffer().readString());
        consumer.close();
        Wait.assertTrue(() -> this.server.locateQueue(anycastQueue).getMessageCount() == 0L);
        Wait.assertTrue(() -> this.server.locateQueue(divertAnycastQueue).getMessageCount() == 1L);
    }

    @Test
    public void testFilter() throws Exception {
        SimpleString queueName1 = SimpleString.toSimpleString((String)"simpleQueue1");
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        ClientProducer producer = this.session.createProducer(addressName);
        ClientMessage message = this.session.createMessage(false);
        message.putLongProperty("xxx", 5L);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        message = this.session.createMessage(false);
        message.putLongProperty("xxx", 15L);
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        producer.close();
        Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessageCount() == 2L);
        this.server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName).setFilterString("xxx > 10").setDurable(Boolean.valueOf(false)));
        Wait.assertTrue(() -> this.server.locateQueue(queueName1) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueName1).getMessageCount() == 1L);
        ClientConsumer consumer = this.session.createConsumer(queueName1);
        this.session.start();
        message = consumer.receive(1000L);
        RetroactiveAddressTest.assertNotNull((Object)message);
        message.acknowledge();
        RetroactiveAddressTest.assertEquals((long)15L, (long)message.getLongProperty("xxx"));
        consumer.close();
        Wait.assertTrue(() -> this.server.locateQueue(queueName1).getMessageCount() == 0L);
        Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessageCount() == 2L);
    }

    @Test
    public void testAddressSettingOnRetroactiveResource() throws Exception {
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertAddress = ResourceNames.getRetroactiveResourceAddressName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName);
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        this.server.addAddressInfo(new AddressInfo(addressName));
        RetroactiveAddressTest.assertEquals((long)-1L, (long)((AddressSettings)this.server.getAddressSettingsRepository().getMatch(divertAddress.toString())).getMaxSizeBytes());
        this.server.getAddressSettingsRepository().addMatch("*" + this.delimiter + "*" + this.delimiter + "*" + this.delimiter + addressName + this.delimiter + "*" + this.delimiter + "retro", (Object)new AddressSettings().setMaxSizeBytes(13L));
        RetroactiveAddressTest.assertEquals((long)13L, (long)((AddressSettings)this.server.getAddressSettingsRepository().getMatch(divertAddress.toString())).getMaxSizeBytes());
    }

    @Test
    public void testPaging() throws Exception {
        SimpleString queueName = SimpleString.toSimpleString((String)"simpleQueue");
        SimpleString randomQueueName = SimpleString.toSimpleString((String)UUID.randomUUID().toString());
        SimpleString addressName = SimpleString.toSimpleString((String)"myAddress");
        SimpleString divertQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        int MESSAGE_COUNT = 20;
        int MESSAGE_SIZE = 1024;
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(20L).setMaxSizeBytes(20480L).setPageSizeBytes(10240).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE));
        this.server.addAddressInfo(new AddressInfo(addressName));
        this.server.createQueue(new QueueConfiguration(randomQueueName).setAddress(addressName));
        ClientProducer producer = this.session.createProducer(addressName);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(RetroactiveAddressTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 40; ++i) {
            ClientMessage message = this.session.createMessage(true);
            message.getBodyBuffer().writeBytes(body);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        producer.close();
        Wait.assertTrue(() -> this.server.locateQueue(randomQueueName).getMessageCount() == 40L);
        Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessageCount() == 20L);
        this.session.createQueue(new QueueConfiguration(queueName).setAddress(addressName));
        Wait.assertTrue(() -> this.server.locateQueue(queueName) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueName).getMessageCount() == 20L);
        ClientConsumer consumer = this.session.createConsumer(queueName);
        this.session.start();
        for (int i = 0; i < 20; ++i) {
            ClientMessage message = consumer.receive(1000L);
            RetroactiveAddressTest.assertNotNull((Object)message);
            message.acknowledge();
        }
        consumer.close();
        Wait.assertTrue(() -> this.server.locateQueue(queueName).getMessageCount() == 0L);
        Wait.assertTrue(() -> this.server.locateQueue(divertQueue).getMessageCount() == 20L);
    }
}

