/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.core.InMemorySessionManagerFactory;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionListener;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Host;

public class UndertowContext
implements Context {
    private Deployment deployment;
    private Host host;

    public UndertowContext(Deployment deployment, Host host) {
        this.deployment = deployment;
        this.host = host;
    }

    public Host getHost() {
        return this.host;
    }

    public String getPath() {
        String path = this.deployment.getDeploymentInfo().getContextPath();
        return "/".equals(path) ? "" : path;
    }

    public boolean isStarted() {
        return this.deployment.getApplicationListeners().isStarted();
    }

    public void addRequestListener(ServletRequestListener listener) {
        ManagedListener ml = new ManagedListener(new ListenerInfo(ServletRequestListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)), true);
        try {
            ml.start();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.deployment.getApplicationListeners().addListener(ml);
    }

    public void removeRequestListener(ServletRequestListener listener) {
    }

    public void addSessionListener(HttpSessionListener listener) {
        ManagedListener ml = new ManagedListener(new ListenerInfo(HttpSessionListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)), true);
        try {
            ml.start();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.deployment.getApplicationListeners().addListener(ml);
    }

    public void removeSessionListener(HttpSessionListener listener) {
    }

    public int getActiveSessionCount() {
        return this.deployment.getSessionManager().getActiveSessions().size();
    }

    public boolean isDistributable() {
        return !(this.deployment.getDeploymentInfo().getSessionManagerFactory() instanceof InMemorySessionManagerFactory);
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowContext)) {
            return false;
        }
        UndertowContext context = (UndertowContext)object;
        return this.host.equals(context.host) && this.getPath().equals(context.getPath());
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.getPath().hashCode();
    }
}

