/*
 * Decompiled with CFR 0.152.
 */
package db.manager.cmd;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurityCmd {
    private static final String KEY = "DBmanagerEncrKey";
    private static final String IVECTOR = "DBmanagerIvector";
    private static final String ALGO = "AES/GCM/NoPadding";
    private static final int TAG_LEN = 128;

    private static SecretKeySpec getSecretKey(String key) throws UnsupportedEncodingException {
        return new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8.name()), "AES");
    }

    private static String encrypt(String key, String initVector, String value) {
        try {
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, initVector.getBytes(StandardCharsets.UTF_8.name()));
            SecretKeySpec skeySpec = SecurityCmd.getSecretKey(key);
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(1, (Key)skeySpec, gcmParameterSpec);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String decrypt(String key, String initVector, String encrypted) {
        try {
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, initVector.getBytes(StandardCharsets.UTF_8.name()));
            SecretKeySpec skeySpec = SecurityCmd.getSecretKey(key);
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(2, (Key)skeySpec, gcmParameterSpec);
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted));
            return new String(original);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decrypt(Path path) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        String cryptedPwd = new String(bytes, StandardCharsets.UTF_8);
        return SecurityCmd.decrypt(KEY, IVECTOR, cryptedPwd);
    }

    public static void main(String[] args) throws IOException {
        String path = args[0];
        String pwd = args[1];
        String crypted = SecurityCmd.encrypt(KEY, IVECTOR, pwd);
        Files.write(Paths.get(path, new String[0]), crypted.getBytes(), new OpenOption[0]);
    }
}

