/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.directbuffer;

import com.cadwin.basic.logger.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;

public class DirectBufferUtil {
    private static final String DIRECT_BYTE_BUFFER_CLASSNAME = "java.nio.DirectByteBuffer";
    private static final Logger LOGGER = Logger.getLogger(DirectBufferUtil.class);

    public static ByteBuffer create(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    public static void free(ByteBuffer buffer) {
        if (buffer != null && buffer.isDirect()) {
            AccessController.doPrivileged(() -> {
                block6: {
                    try {
                        Class<?> directByteBufferClass = buffer.getClass();
                        if (!directByteBufferClass.getName().equals(DIRECT_BYTE_BUFFER_CLASSNAME)) {
                            throw new IllegalArgumentException("Unable to free a direct NIO buffer of the class " + directByteBufferClass.getName() + ". Expecting an instance of the class java.nio.DirectByteBuffer");
                        }
                        try {
                            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                            Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                            theUnsafeField.setAccessible(true);
                            Object theUnsafe = theUnsafeField.get(null);
                            Method invokeCleanerMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                            invokeCleanerMethod.setAccessible(true);
                            invokeCleanerMethod.invoke(theUnsafe, buffer);
                            LOGGER.debug("Direct NIO buffer successfully freed");
                        }
                        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                            Method directByteBufferCleanerMethod = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
                            directByteBufferCleanerMethod.setAccessible(true);
                            Object cleaner = directByteBufferCleanerMethod.invoke((Object)buffer, new Object[0]);
                            if (cleaner == null) {
                                LOGGER.debug("No cleaner found in the direct NIO buffer", ex);
                                break block6;
                            }
                            Method cleanMethod = cleaner.getClass().getDeclaredMethod("clean", new Class[0]);
                            cleanMethod.setAccessible(true);
                            cleanMethod.invoke(cleaner, new Object[0]);
                            LOGGER.debug("Direct NIO buffer successfully freed", ex);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                        LOGGER.warn("Failed to free a direct NIO buffer", ex);
                    }
                }
                return null;
            });
        }
    }

    private DirectBufferUtil() {
    }
}

