/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.encryption;

import com.cadwin.basic.encryption.CryptoException;
import com.cadwin.basic.encryption.CryptoHelper;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class Crypto {
    private final SecretKey secretKey;

    private Crypto(String secretKey) throws UnsupportedEncodingException {
        this.secretKey = CryptoHelper.getSecretKey(secretKey);
    }

    private static byte[] getInitVector() {
        byte[] iv = new byte[12];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(iv);
        return iv;
    }

    private static Cipher createCipher(SecretKey sKey, byte[] iv, int mode) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
        cipher.init(mode, (Key)sKey, ivSpec);
        return cipher;
    }

    public byte[] encrypt(String value) throws CryptoException {
        byte[] iv = Crypto.getInitVector();
        try {
            Cipher cipher = Crypto.createCipher(this.secretKey, iv, 1);
            byte[] ciphertext = cipher.doFinal(CryptoHelper.getBytes(value));
            byte[] encrypted = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, encrypted, 0, iv.length);
            System.arraycopy(ciphertext, 0, encrypted, iv.length, ciphertext.length);
            return encrypted;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw CryptoHelper.buildCryptoException("encrypting", ex);
        }
    }

    public String decrypt(byte[] encrypted) throws CryptoException {
        byte[] iv = Arrays.copyOfRange(encrypted, 0, 12);
        try {
            Cipher cipher = Crypto.createCipher(this.secretKey, iv, 2);
            byte[] ciphertext = cipher.doFinal(encrypted, 12, encrypted.length - 12);
            return new String(ciphertext, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw CryptoHelper.buildCryptoException("decrypting", ex);
        }
    }

    public static Crypto buildAESGCMCrypto(String secretKey) throws CryptoException {
        int keylen = secretKey.length();
        if (keylen != 16 && keylen != 24 && keylen != 32) {
            throw new CryptoException(String.format("%s : invalid AES key length (%d bytes), must be 16, 24 or 32 bytes", secretKey, keylen));
        }
        try {
            return new Crypto(secretKey);
        }
        catch (UnsupportedEncodingException ex) {
            throw CryptoHelper.buildCryptoException("building crypto", ex);
        }
    }
}

