/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.file;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class FileUtil {
    private FileUtil() {
    }

    public static Path writeToTempFile(byte[] byteArray, String prefix, String suffix) throws IOException {
        Path path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        Files.write(path, byteArray, StandardOpenOption.CREATE);
        return path;
    }

    public static void save(Object o, Path filename) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filename.toFile());
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(o);
        }
    }

    private static ObjectInputStream getDefaultObjectInputStream(InputStream inputStream, final ClassLoader classLoader) throws IOException {
        return new ObjectInputStream(inputStream){

            public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                try {
                    return Class.forName(objectStreamClass.getName(), true, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    return super.resolveClass(objectStreamClass);
                }
            }
        };
    }

    public static <T> T load(Class<T> type, Path filename, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        try (FileInputStream fis = new FileInputStream(filename.toFile());){
            T t;
            block11: {
                ObjectInputStream ois = FileUtil.getDefaultObjectInputStream(fis, classLoader);
                try {
                    t = type.cast(ois.readObject());
                    if (ois == null) break block11;
                }
                catch (Throwable throwable) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ois.close();
            }
            return t;
        }
    }

    public static byte[] getByteArrayFromStream(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }
}

