/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.ftp;

import com.cadwin.basic.io.IoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;

public class FTPUtil {
    private FTPUtil() {
    }

    public static String buildURL(String username, String password, String host, String path) {
        return String.format("ftp://%s:%s@%s/%s", username, password, host, path);
    }

    public static URLConnection getURLConnection(String url) throws IOException {
        URL ftpURL = new URL(url);
        return ftpURL.openConnection();
    }

    public static void put(String url, Path source) throws IOException {
        try (OutputStream os = FTPUtil.getURLConnection(url).getOutputStream();){
            Files.copy(source, os);
        }
    }

    public static void put(String url, InputStream is) throws IOException {
        try (OutputStream os = FTPUtil.getURLConnection(url).getOutputStream();){
            IoUtil.copy(is, os);
        }
    }

    public static void get(String url, Path target) throws IOException {
        try (InputStream is = FTPUtil.getURLConnection(url).getInputStream();){
            Files.copy(is, target, new CopyOption[0]);
        }
    }
}

