/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.html;

import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.charset.Charset;

public class HTML {
    private StringBuilder buf;
    private boolean putFooter = false;

    public HTML() {
        this.buf = new StringBuilder(1024);
        this.putFooter = false;
    }

    public HTML(String title, Charset charset) {
        this(title, charset, null);
    }

    public HTML(String title, Charset charset, String style) {
        this.buf = new StringBuilder(4096);
        this.putFooter = true;
        this.buf.append("<html>\n<head>");
        if (title != null) {
            this.buf.append("<title>").append(title).append("</title>");
        }
        if (style != null) {
            this.buf.append("<style type=\"text/css\">").append(style).append("</style>");
        }
        if (charset != null) {
            this.buf.append("<META HTTP-EQUIV= \"Content-Type\" CONTENT=\"text/html;charset=").append(charset.name()).append("\">");
        }
        this.buf.append("</head>\n<body>");
    }

    public HTML(String title) {
        this(title, null);
    }

    public void add(Object obj) {
        this.buf.append(obj.toString());
    }

    public void add(Object obj, boolean linebreak) {
        this.buf.append(obj.toString());
        if (linebreak) {
            this.addLineBreak();
        }
    }

    public Object addFile(String fileName) {
        return this.addFile(fileName, true);
    }

    public Object addHtmlFile(String fileName) {
        return this.addFile(fileName, false);
    }

    public void addLine() {
        this.buf.append("<HR>");
    }

    public void addLineBreak() {
        this.buf.append("<BR>\n");
    }

    public void addLineBreak(int nb) {
        for (int i = 0; i < nb; ++i) {
            this.addLineBreak();
        }
    }

    public String toString() {
        if (this.putFooter) {
            this.buf.append("\n</body></html>");
        }
        return this.buf.toString();
    }

    private Object addFile(String fileName, boolean lineBreak) {
        try (BufferedReader br = new BufferedReader(new FileReader(fileName));){
            while (br.ready()) {
                String line = br.readLine();
                this.add(line, lineBreak);
            }
        }
        catch (Exception e) {
            return e;
        }
        return fileName;
    }
}

