/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IoUtil {
    private static final int DEFAULT_CHUNKSIZE = 8192;

    private IoUtil() {
    }

    public static void copy(Reader reader, Writer writer, int chunkSize) throws IOException {
        int nbRead;
        char[] buff = new char[chunkSize];
        do {
            if ((nbRead = reader.read(buff, 0, chunkSize)) <= 0) continue;
            writer.write(buff, 0, nbRead);
        } while (nbRead > 0 && nbRead == chunkSize);
        writer.flush();
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IoUtil.copy(reader, writer, 8192);
    }

    public static void copy(InputStream is, OutputStream os, int chunkSize) throws IOException {
        int nbRead;
        byte[] buff = new byte[chunkSize];
        do {
            if ((nbRead = is.read(buff, 0, chunkSize)) <= 0) continue;
            os.write(buff, 0, nbRead);
        } while (nbRead > 0 && nbRead == chunkSize);
        os.flush();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        IoUtil.copy(is, os, 8192);
    }

    public static void copy(Reader reader, StringBuilder sb, int chunkSize) throws IOException {
        int nbRead;
        char[] buffer = new char[chunkSize];
        do {
            if ((nbRead = reader.read(buffer, 0, chunkSize)) <= 0) continue;
            sb.append(buffer, 0, nbRead);
        } while (nbRead > 0 && nbRead == chunkSize);
    }

    public static void copy(Reader reader, StringBuilder sb) throws IOException {
        IoUtil.copy(reader, sb, 8192);
    }

    @FunctionalInterface
    public static interface CopyStream<I extends InputStream, O extends OutputStream> {
        public void accept(I var1, O var2) throws IOException;
    }
}

