/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.jboss.as;

import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.ReflectionException;

public class DeploymentUtil {
    private ObjectName jbossDeployment;

    public static DeploymentUtil getInstance() {
        return LazyHolder.instance;
    }

    private DeploymentUtil() {
        try {
            this.jbossDeployment = new ObjectName("jboss.as:deployment=*");
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError("Use only in Jboss / Wildfly application", ex);
        }
    }

    public ObjectName findDeployment(String deploymentName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        ObjectName result = null;
        Set<ObjectName> ons = QueryEval.getMBeanServer().queryNames(this.jbossDeployment, null);
        for (ObjectName on : ons) {
            String runtimeName = (String)String.class.cast(QueryEval.getMBeanServer().getAttribute(on, "runtimeName"));
            if (!runtimeName.equals(deploymentName)) continue;
            result = on;
            break;
        }
        return result;
    }

    private static class LazyHolder {
        private static DeploymentUtil instance = new DeploymentUtil();

        private LazyHolder() {
        }
    }
}

