/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.logger;

import com.cadwin.basic.logger.LoggerIF;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Logger
implements LoggerIF {
    private static final Class<?> implLoggerClass;
    private static final Method methodInfo;
    private static final Method methodDebug;
    private static final Method methodWarn;
    private static final Method methodDebug2;
    private static final Method methodWarn2;
    private static final Method methodError;
    private static final Method methodError2;
    private static final Method methodIsDebugEnabled;
    private final Object implLogger;

    private static RuntimeException buildRuntimeException(Throwable ex) {
        return new RuntimeException("Log4j not found", ex);
    }

    private Logger(Object o) {
        this.implLogger = o;
    }

    private Object getLogger() {
        return this.implLogger;
    }

    public static Logger getLogger(Class<?> clazz) {
        try {
            return new Logger(implLoggerClass.getMethod("getLogger", Class.class).invoke(null, clazz));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    @Override
    public void info(Object value) {
        try {
            methodInfo.invoke(this.getLogger(), value);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    @Override
    public void debug(Object value, Throwable th) {
        try {
            methodDebug2.invoke(this.getLogger(), value, th);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    @Override
    public void warn(Object value, Throwable th) {
        try {
            methodWarn2.invoke(this.getLogger(), value, th);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    @Override
    public void debug(Object value) {
        try {
            methodDebug.invoke(this.getLogger(), value);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    @Override
    public void warn(Object value) {
        try {
            methodWarn.invoke(this.getLogger(), value);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    @Override
    public void error(Object value) {
        try {
            methodError.invoke(this.getLogger(), value);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    @Override
    public void error(Object value, Throwable th) {
        try {
            methodError2.invoke(this.getLogger(), value, th);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    public boolean isDebugEnabled() {
        try {
            return (Boolean)methodIsDebugEnabled.invoke(this.getLogger(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }

    static {
        try {
            String info = "info";
            String debug = "debug";
            String warn = "warn";
            String error = "error";
            implLoggerClass = Class.forName("org.apache.log4j.Logger");
            methodInfo = implLoggerClass.getMethod("info", Object.class);
            methodDebug = implLoggerClass.getMethod("debug", Object.class);
            methodWarn = implLoggerClass.getMethod("warn", Object.class);
            methodDebug2 = implLoggerClass.getMethod("debug", Object.class, Throwable.class);
            methodWarn2 = implLoggerClass.getMethod("warn", Object.class, Throwable.class);
            methodError = implLoggerClass.getMethod("error", Object.class);
            methodError2 = implLoggerClass.getMethod("error", Object.class, Throwable.class);
            methodIsDebugEnabled = implLoggerClass.getMethod("isDebugEnabled", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            throw Logger.buildRuntimeException(ex);
        }
    }
}

