/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.logger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LoggingContext {
    private static final Class<?> implMdcClass;
    private static final Method putMethod;
    private static final Method removeMethod;
    private static final String CONTEXT = "context";

    private static RuntimeException buildRuntimeException(Throwable ex) {
        return new RuntimeException("Log4j not found", ex);
    }

    private LoggingContext() {
    }

    public static void put(String value) {
        try {
            putMethod.invoke(null, CONTEXT, value);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw LoggingContext.buildRuntimeException(ex);
        }
    }

    public static void remove() {
        try {
            removeMethod.invoke(null, CONTEXT);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw LoggingContext.buildRuntimeException(ex);
        }
    }

    static {
        try {
            implMdcClass = Class.forName("org.apache.log4j.MDC");
            putMethod = implMdcClass.getMethod("put", String.class, Object.class);
            removeMethod = implMdcClass.getMethod("remove", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            throw LoggingContext.buildRuntimeException(ex);
        }
    }
}

