/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.mbeans;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MBeanUtil {
    private static final String CADWIN_MBEAN_DOMAIN = "com.cadwin";
    private static final String CADWIN_MBEAN_PROPERTY = "deployment";

    public static ObjectName getDeploymentObjectName(String deploymentName) throws MalformedObjectNameException {
        String name = String.format("%s:%s=%s", CADWIN_MBEAN_DOMAIN, CADWIN_MBEAN_PROPERTY, deploymentName);
        return new ObjectName(name);
    }

    public static ObjectName getDeploymentsObjectName() throws MalformedObjectNameException {
        return MBeanUtil.getDeploymentObjectName("*");
    }

    public static void registerMBean(MBeanServer mBeanServer, ObjectName mBeanName, Object mBean) throws InstanceAlreadyExistsException, InstanceNotFoundException, MBeanRegistrationException, NotCompliantMBeanException {
        MBeanUtil.unregisterMBean(mBeanServer, mBeanName);
        mBeanServer.registerMBean(mBean, mBeanName);
    }

    public static void unregisterMBean(MBeanServer mBeanServer, ObjectName mBeanName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (mBeanServer.isRegistered(mBeanName)) {
            mBeanServer.unregisterMBean(mBeanName);
        }
    }

    private MBeanUtil() {
    }
}

