/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TimerTask;

public abstract class AbstractDirWatcher
extends TimerTask {
    private File path;
    private final HashMap<File, Long> dir = new HashMap();
    private FileFilter fileFilter;
    private boolean readError;

    public AbstractDirWatcher(File path) {
        this(path, null);
    }

    public AbstractDirWatcher(File path, FileFilter fileFilter) {
        this.path = path;
        this.fileFilter = fileFilter;
        File[] filesArray = path.listFiles(fileFilter);
        boolean bl = this.readError = filesArray == null;
        if (filesArray != null) {
            for (File file : filesArray) {
                this.dir.put(file, file.lastModified());
            }
        }
    }

    public boolean isReadError() {
        return this.readError;
    }

    @Override
    public final void run() {
        HashSet<File> checkedFiles = new HashSet<File>();
        File[] filesArray = this.path.listFiles(this.fileFilter);
        if (filesArray != null) {
            for (File file : filesArray) {
                Long current = this.dir.get(file);
                checkedFiles.add(file);
                if (current == null) {
                    this.dir.put(file, file.lastModified());
                    this.onChange(file, Mode.ADD);
                    continue;
                }
                if (current.longValue() == file.lastModified()) continue;
                this.dir.put(file, file.lastModified());
                this.onChange(file, Mode.MODIFY);
            }
            HashSet<File> ref = new HashSet<File>(this.dir.keySet());
            ref.removeAll(checkedFiles);
            for (File deletedFile : ref) {
                this.dir.remove(deletedFile);
                this.onChange(deletedFile, Mode.DELETE);
            }
        }
    }

    protected abstract void onChange(File var1, Mode var2);

    public static enum Mode {
        ADD,
        MODIFY,
        DELETE;

    }
}

