/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.ValuesConstants;
import java.io.Serializable;
import java.sql.Date;
import java.util.Calendar;
import java.util.Objects;

public class DateRange
implements Serializable {
    private Type type = Type.NULL;
    private int since;
    private Date beginDate;
    private Date endDate;

    public DateRange() {
    }

    public DateRange(Type type, int since) {
        if (ValuesConstants.isNull(since)) {
            this.type = Type.NULL;
            return;
        }
        this.type = type;
        this.since = since;
        Calendar cal = Calendar.getInstance();
        this.endDate = new Date(cal.getTimeInMillis());
        this.beginDate = new Date(cal.getTimeInMillis());
        switch (type) {
            case LAST_DAY: {
                cal.add(5, -since);
                this.beginDate = new Date(cal.getTimeInMillis());
                break;
            }
            case LAST_MONTH: {
                cal.add(2, -since);
                this.beginDate = new Date(cal.getTimeInMillis());
                break;
            }
            case LAST_YEAR: {
                cal.add(1, -since);
                this.beginDate = new Date(cal.getTimeInMillis());
                break;
            }
            case NEXT_DAY: {
                cal.add(5, since);
                this.endDate = new Date(cal.getTimeInMillis());
                break;
            }
            case NEXT_MONTH: {
                cal.add(2, since);
                this.endDate = new Date(cal.getTimeInMillis());
                break;
            }
            case NEXT_YEAR: {
                cal.add(1, since);
                this.endDate = new Date(cal.getTimeInMillis());
                break;
            }
            default: {
                throw new Error("Not allowed " + type);
            }
        }
        this.setupDayBoundaries();
    }

    public DateRange(Type type, Date date) {
        if (date == null) {
            this.type = type != Type.EMPTY ? Type.NULL : Type.EMPTY;
            return;
        }
        this.type = type;
        switch (type) {
            case BEFORE: {
                this.beginDate = new Date(0L);
                this.endDate = date;
                break;
            }
            case AFTER: {
                this.beginDate = date;
                this.endDate = new Date(Long.MAX_VALUE);
                break;
            }
            default: {
                throw new Error("Not allowed " + type);
            }
        }
    }

    public DateRange(Date beginDate, Date endDate) {
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.type = this.beginDate != null && this.endDate != null ? Type.BETWEEN : Type.NULL;
        this.setupDayBoundaries();
    }

    private void setupDayBoundaries() {
        Calendar cal = Calendar.getInstance();
        if (this.beginDate != null) {
            cal.setTime(this.beginDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            this.beginDate = new Date(cal.getTimeInMillis());
        }
        if (this.endDate != null) {
            cal.setTime(this.endDate);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            this.endDate = new Date(cal.getTimeInMillis());
        }
    }

    public Check check() {
        if (this.type == Type.BETWEEN) {
            if (this.beginDate == null) {
                return Check.BEGIN_DATE_BAD_FORMAT;
            }
            if (this.endDate == null) {
                return Check.END_DATE_BAD_FORMAT;
            }
            if (this.beginDate.compareTo(this.endDate) >= 0) {
                return Check.RANGE_ERROR;
            }
        }
        return Check.PASS;
    }

    public Type getType() {
        return this.type;
    }

    public int getSince() {
        return this.since;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateRange other = (DateRange)obj;
        return Objects.equals(this.beginDate, other.beginDate) && Objects.equals(this.endDate, other.endDate);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.beginDate != null ? this.beginDate.hashCode() : 0);
        hash = 53 * hash + (this.endDate != null ? this.endDate.hashCode() : 0);
        return hash;
    }

    public static enum Type {
        NULL,
        LAST_DAY,
        LAST_MONTH,
        LAST_YEAR,
        NEXT_DAY,
        NEXT_MONTH,
        NEXT_YEAR,
        BETWEEN,
        BEFORE,
        AFTER,
        EMPTY;

    }

    public static enum Check {
        PASS,
        RANGE_ERROR,
        BEGIN_DATE_BAD_FORMAT,
        END_DATE_BAD_FORMAT;

    }
}

