/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class DurationWithTimeUse {
    private Period periodBetween;
    private long d;
    private long h;
    private long m;
    private long s;
    private long ms;
    private long ns;

    public static DurationWithTimeUse getDurationWithTimeBetweenNowAnd(long duration) {
        DurationWithTimeUse result = new DurationWithTimeUse();
        LocalDate today = LocalDate.now();
        Instant nowInstant = Instant.now();
        Date dateToCompare = new Date(duration);
        Instant instantToCompare = dateToCompare.toInstant();
        ZonedDateTime zdt = instantToCompare.atZone(ZoneId.systemDefault());
        LocalDate birthday = zdt.toLocalDate();
        result.setPeriodBetween(Period.between(birthday, today));
        result.setDuration(Duration.between(instantToCompare, nowInstant));
        return result;
    }

    public void setDuration(Duration duration) {
        Duration dur = duration;
        this.d = dur.toDays();
        dur = dur.minusDays(this.d);
        this.h = dur.toHours();
        dur = dur.minusHours(this.h);
        this.m = dur.toMinutes();
        dur = dur.minusMinutes(this.m);
        this.s = dur.getSeconds();
        dur = dur.minusSeconds(this.s);
        this.ms = dur.toMillis();
        dur = dur.minusMillis(this.ms);
        this.ns = dur.toNanos();
    }

    public void setPeriodBetween(Period period) {
        this.periodBetween = period;
    }

    public Period getPeriodBetween() {
        return this.periodBetween;
    }

    public long getHours() {
        return this.h;
    }

    public long getMinutes() {
        return this.m;
    }

    public long getSeconds() {
        return this.s;
    }

    public long getMilliSeconds() {
        return this.ms;
    }

    public long getNanoSeconds() {
        return this.ns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean sbIsVirgin = true;
        if (this.getPeriodBetween().getYears() > 0) {
            sb.append(this.getPeriodBetween().getYears());
            sb.append(" years ");
            sbIsVirgin = false;
        }
        if (this.getPeriodBetween().getMonths() > 0) {
            sb.append(this.getPeriodBetween().getMonths());
            sb.append(" months ");
            sbIsVirgin = false;
        }
        if (this.getPeriodBetween().getDays() > 0) {
            sb.append(this.getPeriodBetween().getDays());
            sb.append(" days ");
            sbIsVirgin = false;
        }
        if (this.getHours() > 0L) {
            sb.append(this.getHours());
            sb.append(" Hours ");
            sbIsVirgin = false;
        }
        if (sbIsVirgin) {
            if (this.getMinutes() > 0L) {
                sb.append(this.getMinutes());
                sb.append(" minutes");
            }
            if (this.getSeconds() > 0L) {
                sb.append(this.getSeconds());
                sb.append(" seconds ");
            }
            if (this.getMilliSeconds() > 0L) {
                sb.append(this.getMilliSeconds());
                sb.append(" milli-seconds ");
            }
            if (this.getNanoSeconds() > 0L) {
                sb.append(this.getNanoSeconds());
                sb.append(" nano-seconds ");
            }
        }
        return sb.toString();
    }
}

