/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

public class NumberUtil {
    public static final long NULL_LONG = Long.MIN_VALUE;
    public static final double PRECISION = 1.0E-6;
    private static final double INCH_EN_MM = 25.4;
    private static final double FOOT_EN_MM = 304.8;
    private static final double YARD_EN_MM = 914.4;

    public static LinearUnit getLinearUnit(String tag, LinearUnit defaultValue) {
        if (tag == null) {
            return defaultValue;
        }
        try {
            return LinearUnit.valueOf(tag.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Double toDouble(double d) {
        return d == Double.MIN_VALUE ? null : Double.valueOf(d);
    }

    public static Long toLong(long l) {
        return l == Long.MIN_VALUE ? null : Long.valueOf(l);
    }

    public static Integer toInteger(int i) {
        return i == Integer.MIN_VALUE ? null : Integer.valueOf(i);
    }

    public static SurfaceUnit getSurfaceUnit(String tag, SurfaceUnit defaultValue) {
        if (tag == null) {
            return defaultValue;
        }
        try {
            return SurfaceUnit.valueOf(tag.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static VolumeUnit getVolumeUnit(String tag, VolumeUnit defaultValue) {
        if (tag == null) {
            return defaultValue;
        }
        try {
            if ("INCH3".equalsIgnoreCase(tag)) {
                return VolumeUnit.IN3;
            }
            if ("FEET3".equalsIgnoreCase(tag)) {
                return VolumeUnit.FT3;
            }
            if ("YARD3".equalsIgnoreCase(tag)) {
                return VolumeUnit.YD3;
            }
            return VolumeUnit.valueOf(tag.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static WeightUnit getWeightUnit(String tag, WeightUnit defaultValue) {
        if (tag == null) {
            return defaultValue;
        }
        try {
            return WeightUnit.valueOf(tag.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static UnitType getUnitType(String dimension) {
        if (dimension == null) {
            return null;
        }
        if ("LENGTH".equalsIgnoreCase(dimension)) {
            return UnitType.LINEAR;
        }
        if ("AREA".equalsIgnoreCase(dimension)) {
            return UnitType.SURFACE;
        }
        if ("VOLUME".equalsIgnoreCase(dimension)) {
            return UnitType.VOLUME;
        }
        if ("WEIGHT".equalsIgnoreCase(dimension)) {
            return UnitType.WEIGHT;
        }
        try {
            return UnitType.valueOf(dimension.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static float floatValue(Object o, float defaultValue) {
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o != null) {
            try {
                return Float.parseFloat(o.toString().trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static float floatValue(Object o) {
        return NumberUtil.floatValue(o, Float.MIN_VALUE);
    }

    public static double doubleValue(Object o, double defaultValue) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o != null) {
            try {
                return Double.parseDouble(o.toString().trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static double doubleValue(Object o) {
        return NumberUtil.doubleValue(o, Double.MIN_VALUE);
    }

    public static int intValue(Object o, int defaultValue) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o != null) {
            try {
                return Integer.parseInt(o.toString().trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static int intValue(Object o) {
        return NumberUtil.intValue(o, Integer.MIN_VALUE);
    }

    public static long longValue(Object o, long defaultValue) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o != null) {
            try {
                return Long.parseLong(o.toString().trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static long longValue(Object o) {
        return NumberUtil.longValue(o, Long.MIN_VALUE);
    }

    public static int compare(Object o1, Object o2) {
        int result;
        Number number2;
        Number number1;
        Objects.requireNonNull(o1);
        Objects.requireNonNull(o2);
        Function<Object, String> createExceptionFunc = o -> "Cannot convert " + o + " into an instance of BigDecimal";
        Number number = number1 = o1 instanceof Number ? (Number)o1 : NumberUtil.bigDecimalValue(o1, null);
        if (number1 == null) {
            throw new NumberFormatException(createExceptionFunc.apply(o1));
        }
        Number number3 = number2 = o2 instanceof Number ? (Number)o2 : NumberUtil.bigDecimalValue(o2, null);
        if (number2 == null) {
            throw new NumberFormatException(createExceptionFunc.apply(o2));
        }
        if (number1.getClass() == number2.getClass() && number1 instanceof Comparable) {
            result = ((Comparable)((Object)number1)).compareTo((Comparable)((Object)number2));
        } else {
            BigDecimal bg1 = NumberUtil.bigDecimalValue(number1, null);
            if (bg1 == null) {
                throw new NumberFormatException(createExceptionFunc.apply(number1));
            }
            BigDecimal bg2 = NumberUtil.bigDecimalValue(number2, null);
            if (bg2 == null) {
                throw new NumberFormatException(createExceptionFunc.apply(number2));
            }
            result = bg1.compareTo(bg2);
        }
        return result;
    }

    public static boolean equalsWithPrecision(double d1, double d2, double precision) {
        return Math.abs(d1 - d2) < precision;
    }

    public static boolean equalsWithPrecision(double d1, double d2) {
        return NumberUtil.equalsWithPrecision(d1, d2, 1.0E-6);
    }

    public static BigDecimal bigDecimalValue(Object o, BigDecimal defaultValue) {
        BigDecimal result;
        if (o == null) {
            result = defaultValue;
        } else if (o instanceof Number) {
            result = o instanceof BigDecimal ? (BigDecimal)o : (NumberUtil.isIntegral(o) ? (o instanceof BigInteger ? new BigDecimal((BigInteger)o) : BigDecimal.valueOf(((Number)o).longValue())) : BigDecimal.valueOf(((Number)o).doubleValue()));
        } else {
            BigDecimal resultFromString = defaultValue;
            try {
                resultFromString = new BigDecimal(o.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            result = resultFromString;
        }
        return result;
    }

    public static boolean isIntegral(Object o) {
        return o instanceof AtomicLong || o instanceof Long || o instanceof LongAdder || o instanceof LongAccumulator || o instanceof AtomicInteger || o instanceof Integer || o instanceof Short || o instanceof Byte || o instanceof BigInteger;
    }

    public static BigDecimal bigDecimalValue(Object o) {
        return NumberUtil.bigDecimalValue(o, null);
    }

    private NumberUtil() {
    }

    public static interface WithDescriptionIF {
        public String getDescription();
    }

    public static enum WeightUnit implements WithDescriptionIF
    {
        G(1.0, "g"),
        KG(1000.0, "kg");

        private final double factorToGrams;
        private final String description;
        private final String name;

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private WeightUnit(double factorToGrams, String partialDescription) {
            this.description = partialDescription;
            this.name = partialDescription.toUpperCase();
            this.factorToGrams = factorToGrams;
        }

        public double getFactorToGrams() {
            return this.factorToGrams;
        }
    }

    public static enum VolumeUnit implements WithDescriptionIF
    {
        MM3(1.0, "mm"),
        CM3(1000.0, "cm"),
        DM3(1000000.0, "dm"),
        M3(1.0E9, "m"),
        KM3(1.0E18, "km"),
        IN3(16387.064, "in"),
        FT3(2.8316846592000004E7, "ft"),
        YD3(7.64554857984E8, "yd");

        private final double convertFactor;
        private final String description;
        private final String name;

        public double getConvertFactor() {
            return this.convertFactor;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private VolumeUnit(double convertFactor, String partialDescription) {
            this.convertFactor = convertFactor;
            this.description = partialDescription + "\u00b3";
            this.name = partialDescription.toUpperCase() + "3";
        }
    }

    public static enum SurfaceUnit implements WithDescriptionIF
    {
        MM2(1.0, "mm"),
        CM2(100.0, "cm"),
        DM2(10000.0, "dm"),
        M2(1000000.0, "m"),
        KM2(1.0E12, "km"),
        IN2(645.16, "in"),
        FT2(92903.04000000001, "ft"),
        YD2(836127.36, "yd");

        private final double convertFactor;
        private final String description;
        private final String name;

        public double getConvertFactor() {
            return this.convertFactor;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private SurfaceUnit(double convertFactor, String partialDescription) {
            this.convertFactor = convertFactor;
            this.description = partialDescription + "\u00b2";
            this.name = partialDescription.toUpperCase() + "2";
        }
    }

    public static enum RatioUnit implements WithDescriptionIF
    {
        PERCENT(1.0, "%"),
        PERMILLE(0.1, "\u2030");

        private final double convertFactor;
        private final String description;
        private final String name;

        public double getConvertFactor() {
            return this.convertFactor;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private RatioUnit(double convertFactor, String description) {
            this.convertFactor = convertFactor;
            this.description = description;
            this.name = description.toUpperCase();
        }
    }

    public static enum AngularUnit implements WithDescriptionIF
    {
        DEGREE(1.0, "\u00b0"),
        RADIAN(57.29577951308232, "rad");

        private final double convertFactor;
        private final String description;
        private final String name;

        public double getConvertFactor() {
            return this.convertFactor;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private AngularUnit(double convertFactor, String description) {
            this.convertFactor = convertFactor;
            this.description = description;
            this.name = description.toUpperCase();
        }
    }

    public static enum LinearUnit implements WithDescriptionIF
    {
        MM(1.0, "mm"),
        CM(10.0, "cm"),
        DM(100.0, "dm"),
        M(1000.0, "m"),
        KM(1000000.0, "km"),
        IN(25.4, "in"),
        FT(304.8, "ft"),
        YD(914.4, "yd");

        private final double convertFactor;
        private final String description;
        private final String name;

        public double getConvertFactor() {
            return this.convertFactor;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        private LinearUnit(double convertFactor, String description) {
            this.convertFactor = convertFactor;
            this.description = description;
            this.name = description.toUpperCase();
        }
    }

    public static enum UnitType {
        LINEAR,
        SURFACE,
        VOLUME,
        WEIGHT,
        CURRENCY,
        PERCENTAGE;

    }
}

