/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import java.lang.ref.WeakReference;

public class PictureCacheStorage {
    private static final long CHECK_DELAY = 5000L;
    private final long lastModified;
    private long lastCheck;
    private final WeakReference<Object> picture;

    public PictureCacheStorage(long lastModified, Object picture) {
        this.lastModified = lastModified;
        this.lastCheck = System.currentTimeMillis();
        if (picture == null) {
            throw new IllegalArgumentException("The argument \"picture\" cannot be null");
        }
        this.picture = new WeakReference<Object>(picture);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean mustCheck() {
        long time = System.currentTimeMillis();
        if (this.lastCheck + 5000L < time) {
            this.lastCheck = time;
            return true;
        }
        return false;
    }

    public Object getPicture() {
        return this.picture.get();
    }
}

