/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.misc.StringUtil;

public class Timer {
    private long start;
    private long total;
    private boolean stopped;
    private static boolean perfEnabled;

    public Timer() {
        this.resetAndStart();
    }

    public void resetAndStart() {
        this.total = 0L;
        this.start();
    }

    public void resetAndStop() {
        this.total = 0L;
        this.stopped = true;
    }

    public long stop() {
        if (!this.stopped) {
            this.stopped = true;
            long time = System.currentTimeMillis() - this.start;
            this.total += time;
            return time;
        }
        return 0L;
    }

    public void start() {
        this.start = System.currentTimeMillis();
        this.stopped = false;
    }

    public long getDurationSinceBegining() {
        long time = 0L;
        if (!this.stopped) {
            time = System.currentTimeMillis() - this.start;
        }
        return this.total + time;
    }

    public String toString() {
        return StringUtil.durationToString(this.getDurationSinceBegining());
    }

    public static boolean isPerfEnabled() {
        return perfEnabled;
    }

    public static void enablePerf() {
        perfEnabled = true;
    }
}

