/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;

public class ToStringUtil {
    private ToStringUtil() {
    }

    public static String toString(Object o) {
        StringBuilder sb = new StringBuilder();
        ToStringUtil.toString(sb, o, 0);
        return sb.toString();
    }

    private static void toString(StringBuilder sb, Object o, int rank) {
        if (o == null) {
            sb.append("null");
            return;
        }
        sb.append(o.getClass().getSimpleName());
        sb.append("[");
        if (o.getClass().isEnum()) {
            sb.append(o);
        } else {
            try {
                BeanInfo bi = Introspector.getBeanInfo(o.getClass());
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    Method readMethod;
                    if (pd.getReadMethod() == null || Class.class.equals(pd.getPropertyType()) || (readMethod = pd.getReadMethod()).getParameterTypes() != null && pd.getReadMethod().getParameterTypes().length != 0) continue;
                    Object v = readMethod.invoke(o, (Object[])null);
                    sb.append(" ");
                    sb.append(pd.getName());
                    sb.append("=");
                    if (v != null && !(v instanceof Collection)) {
                        try {
                            if (readMethod.getReturnType().getPackage() != null && readMethod.getReturnType().getPackage().getName().startsWith("java")) {
                                sb.append(v);
                                continue;
                            }
                            ToStringUtil.toString(sb, v, rank + 1);
                        }
                        catch (NullPointerException npe) {
                            sb.append("***********NPE***********");
                        }
                        continue;
                    }
                    sb.append("null ");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        sb.append("]");
    }
}

