/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.logger.Logger;
import com.cadwin.basic.misc.ValuesConstants;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.sql.Date;
import java.util.Collection;
import java.util.Map;

public class UniversalDataUtil {
    private static boolean toStringExists(Object o) {
        try {
            o.getClass().getDeclaredMethod("toString", null);
            return true;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return false;
        }
    }

    public static String toString(Object o) {
        return UniversalDataUtil.toString(o, ", ", false);
    }

    public static String toString(Object o, String sep) {
        return UniversalDataUtil.toString(o, sep, false);
    }

    private static String toString(Object o, String sep, boolean useToString) {
        StringBuilder sb = new StringBuilder();
        if (o == null) {
            return null;
        }
        if (useToString && UniversalDataUtil.toStringExists(o) || o.getClass().isEnum()) {
            return o.toString();
        }
        if (o.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                if (i > 0) {
                    sb.append(sep);
                }
                sb.append(UniversalDataUtil.toString(Array.get(o, i), sep, true));
            }
        } else if (o instanceof Collection) {
            Collection c = (Collection)o;
            boolean first = true;
            for (Object i : c) {
                if (!first) {
                    sb.append(sep);
                }
                first = false;
                sb.append(UniversalDataUtil.toString(i, sep, true));
            }
        } else if (o instanceof Map) {
            Map m = (Map)o;
            boolean first = true;
            for (Object k : m.keySet()) {
                if (!first) {
                    sb.append(sep);
                }
                first = false;
                sb.append("{");
                sb.append(UniversalDataUtil.toString(k, sep, true));
                sb.append("=");
                sb.append(UniversalDataUtil.toString(m.get(k), sep, true));
                sb.append("}");
            }
        } else {
            try {
                BeanInfo bi = Introspector.getBeanInfo(o.getClass());
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    Object v;
                    if (pd.getReadMethod() == null || pd.getReadMethod().getParameterTypes() != null && pd.getReadMethod().getParameterTypes().length != 0 || Class.class.equals(pd.getPropertyType()) || ValuesConstants.isNull(v = pd.getReadMethod().invoke(o, (Object[])null))) continue;
                    if (sb.length() != 0) {
                        sb.append(sep);
                    }
                    sb.append(pd.getName());
                    sb.append('=');
                    sb.append(UniversalDataUtil.toString(v, sep, true));
                }
            }
            catch (IllegalAccessException iae) {
                Logger.getLogger(UniversalDataUtil.class).warn("toString IllegalAccessException " + o.getClass());
                return o.toString();
            }
            catch (Exception e) {
                Logger.getLogger(UniversalDataUtil.class).error("toString", e);
                return o.toString();
            }
        }
        sb.insert(0, " [");
        sb.insert(0, o.getClass().getSimpleName());
        sb.append("]");
        return sb.toString();
    }

    private static boolean equalsExists(Object o) {
        if (o instanceof Date) {
            return true;
        }
        try {
            o.getClass().getDeclaredMethod("equals", Object.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return false;
        }
    }

    private static boolean equalsArray(Object o1, Object o2) throws Exception {
        int l2;
        int l1 = Array.getLength(o1);
        if (l1 != (l2 = Array.getLength(o2))) {
            return false;
        }
        for (int i = 0; i < l1; ++i) {
            Object oi1 = Array.get(o1, i);
            boolean found = false;
            for (int j = 0; j < l2; ++j) {
                if (!UniversalDataUtil.equals(oi1, Array.get(o2, j), false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object o1, Object o2) throws Exception {
        return UniversalDataUtil.equals(o1, o2, true);
    }

    public static boolean equals(Object o1, Object o2, boolean skeepEqualMethod) throws Exception {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof Comparable && o1.getClass().equals(o2.getClass())) {
            return ((Comparable)o1).compareTo(o2) == 0;
        }
        if (!skeepEqualMethod && UniversalDataUtil.equalsExists(o1)) {
            return o1.equals(o2);
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return UniversalDataUtil.equalsArray(o1, o2);
        }
        if (o1 instanceof Collection && o2 instanceof Collection) {
            Collection col1 = (Collection)o1;
            Collection col2 = (Collection)o2;
            return UniversalDataUtil.equalsArray(col1.toArray(), col2.toArray());
        }
        BeanInfo bi = Introspector.getBeanInfo(o1.getClass());
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            Object v2;
            Object v1;
            if (pd.getReadMethod() == null || pd.getReadMethod().getParameterTypes().length != 0 || Class.class.equals(pd.getPropertyType()) || UniversalDataUtil.equals(v1 = pd.getReadMethod().invoke(o1, (Object[])null), v2 = pd.getReadMethod().invoke(o2, (Object[])null), false)) continue;
            return false;
        }
        return true;
    }

    private UniversalDataUtil() {
    }
}

