/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.misc;

import com.cadwin.basic.dictionnary.DictionnaryValue;
import com.cadwin.basic.misc.IsDifferentValuesIF;
import com.cadwin.basic.misc.IsEmptyIF;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class ValuesConstants {
    public static final int NULL_INT = Integer.MIN_VALUE;
    public static final long NULL_LONG = Long.MIN_VALUE;
    public static final float NULL_FLOAT = Float.MIN_VALUE;
    public static final double NULL_DOUBLE = Double.MIN_VALUE;
    public static final char NULL_CHAR = '\u0000';
    public static final int DIFFERENT_INT_VALUES = Integer.MAX_VALUE;
    public static final long DIFFERENT_LONG_VALUES = Long.MAX_VALUE;
    public static final float DIFFERENT_FLOAT_VALUES = Float.MAX_VALUE;
    public static final double DIFFERENT_DOUBLE_VALUES = Double.MAX_VALUE;
    public static final char DIFFERENT_CHAR_VALUES = '\uffff';
    public static final String DIFFERENT_STRING_VALUES = "\uffffDIFFERENT_STRING_VALUES\uffff";
    public static final Date DIFFERENT_DATE_VALUES = new Date(Long.MAX_VALUE);
    public static final Timestamp DIFFERENT_TIMESTAMP_VALUES = new Timestamp(Long.MAX_VALUE);
    public static final BigDecimal DIFFERENT_BIG_DECIMAL_VALUES = new BigDecimal(Long.MAX_VALUE);
    public static final DictionnaryValue DIFFERENT_DICTIONNARY_VALUE_VALUES = new DictionnaryValue(true);
    private static String DIFFERENT_VALUE_VALUES = "<Unchanged value>";
    public static final Color DIFFERENT_COLOR_VALUES = new DifferentValuesColor();
    private static Map<Class<?>, IsDifferentValuesIF> isDifferentValuesMap;
    public static final int USER_ERROR = 20001;
    public static final int UNIQUE_CONSTRAINT_VIOLATED = 1;
    public static final int TABLE_OR_VIEW_DOES_NOT_EXIST = 942;
    public static final int CHILD_FOUND = 2292;
    public static final int CANNOT_INSERT_NULL = 1400;
    public static final int INSERTED_VALUE_TOO_LARGE_FOR_COLUMN = 1401;
    public static final int RESOURCE_BUSY_AND_ACQUIRE_WITH_NOWAIT_SPECIFIED = 54;
    public static final int RESOURCE_BUSY_AND_ACQUIRE_WITH_WAIT_SPECIFIED = 30006;
    public static final int NO_MORE_DATA_FROM_SOCKET = 17410;
    public static final int NO_DATA_FOUND = 1403;
    public static final int[] HANDLED_ERRORS;
    public static final String CDB_EXT = ".cdb";
    public static final String CSV_EXT = ".csv";
    public static final String DRL_EXT = ".drl";
    public static final String DRW_EXT = ".drw";
    public static final String EXT_EXT = ".ext";
    public static final String TXT_EXT = ".txt";
    public static final String XML_EXT = ".xml";
    public static final String ZIP_EXT = ".zip";
    public static final String DEFAULT_WEB_APPLICATION_NAME = "webapp";
    public static final String WEB_APPLICATION_PARAM_NAME = "webApplicationName";
    public static final String DISPLAY_ACTION = "doDisplay";
    public static final String INIT_COMMAND = "Init";
    public static final String DICTIONNARY_COMMAND = "Dictionnary";
    public static final String COMMAND_PARAM = "Command";
    public static final String SESSION_ID_PARAM = "SessionID";
    public static final String JUNON_COMPILER_PARAM = "junon_compiler";
    public static String TRUE;
    public static String FALSE;

    public static boolean isDifferentValues(Object o) {
        if (o != null) {
            if (o.equals(DIFFERENT_STRING_VALUES) || o instanceof Integer && (Integer)o == Integer.MAX_VALUE || o instanceof Number && (((Number)o).longValue() == Long.MAX_VALUE || ((Number)o).floatValue() == Float.MAX_VALUE || ((Number)o).doubleValue() == Double.MAX_VALUE) || o instanceof Character && ((Character)o).charValue() == '\uffff' || o.equals(DIFFERENT_DATE_VALUES) || o.equals(DIFFERENT_TIMESTAMP_VALUES) || o instanceof DictionnaryValue && ((DictionnaryValue)o).isDifferentValues() || o instanceof DifferentValuesColor) {
                return true;
            }
            if (isDifferentValuesMap != null && isDifferentValuesMap.keySet().stream().anyMatch(objectClass -> objectClass.isInstance(o) && isDifferentValuesMap.get(objectClass).isDifferentValues(o))) {
                return true;
            }
        }
        return false;
    }

    public static void addDifferentValues(Class<?> objectClass, IsDifferentValuesIF isDifferentValues) {
        if (isDifferentValuesMap == null) {
            isDifferentValuesMap = new HashMap();
        }
        isDifferentValuesMap.put(objectClass, isDifferentValues);
    }

    public static void setDifferentValuesText(String differentValuesText) {
        DIFFERENT_VALUE_VALUES = "<" + differentValuesText + ">";
    }

    public static String getDifferentValuesText() {
        return DIFFERENT_VALUE_VALUES;
    }

    public static boolean nonNull(Object o) {
        return !ValuesConstants.isNull(o);
    }

    public static boolean nonNullLong(long val) {
        return val != Long.MIN_VALUE;
    }

    public static boolean isNull(Object o) {
        return o == null || o instanceof IsEmptyIF || o instanceof Integer && (Integer)o == Integer.MIN_VALUE || o instanceof Number && (((Number)o).longValue() == Long.MIN_VALUE || ((Number)o).floatValue() == Float.MIN_VALUE || ((Number)o).doubleValue() == Double.MIN_VALUE) || o instanceof Character && ((Character)o).charValue() == '\u0000' || o instanceof String && ((String)o).isEmpty();
    }

    private ValuesConstants() {
    }

    static {
        HANDLED_ERRORS = new int[]{2292, 1400, 1401, 1403, 1, 20001, 54, 30006};
        TRUE = Boolean.TRUE.toString().toUpperCase();
        FALSE = Boolean.FALSE.toString().toUpperCase();
    }

    private static class DifferentValuesColor
    extends Color {
        DifferentValuesColor() {
            super(0);
        }
    }
}

