/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.number;

import com.cadwin.basic.misc.NumberUtil;
import com.cadwin.basic.misc.ValuesConstants;
import com.cadwin.basic.number.StrBigDecimal;
import com.cadwin.basic.number.UnitBaseInfos;

public class AngularBigDecimal
extends StrBigDecimal {
    private static final long serialVersionUID = 1L;
    private NumberUtil.AngularUnit angularUnit;

    public AngularBigDecimal(Object o) {
        this(o, null);
    }

    public AngularBigDecimal(Object o, NumberUtil.AngularUnit angularUnit) {
        super(o);
        this.angularUnit = angularUnit;
    }

    public NumberUtil.AngularUnit getUnit() {
        return this.angularUnit == null ? UnitBaseInfos.getAngularUnit() : this.angularUnit;
    }

    @Override
    public String toStringWithoutUnitDescription() {
        String result;
        if (ValuesConstants.isNull(this.doubleValue())) {
            result = "";
        } else {
            double value = this.doubleValueInUserDefinedUnit();
            result = UnitBaseInfos.getAngluarFormatter(this.getUnit()).format(value);
        }
        return result;
    }

    @Override
    public String toString() {
        String resultWithoutUnitDesc = this.toStringWithoutUnitDescription();
        return resultWithoutUnitDesc.isEmpty() ? resultWithoutUnitDesc : resultWithoutUnitDesc + " " + this.getUnit().getDescription();
    }

    @Override
    public double doubleValueInUserDefinedUnit() {
        return this.doubleValue() / this.getUnit().getConvertFactor();
    }
}

